/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.extensibility;

import groovy.lang.Closure;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.Describable;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.plugins.ExtensionContainerInternal;
import org.gradle.api.plugins.ExtensionsSchema;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.reflect.TypeOf;
import org.gradle.internal.Cast;
import org.gradle.internal.Describables;
import org.gradle.internal.extensibility.DefaultExtraPropertiesExtension;
import org.gradle.internal.extensibility.ExtensionsStorage;
import org.gradle.internal.instantiation.InstanceGenerator;
import org.gradle.internal.metaobject.AbstractDynamicObject;
import org.gradle.internal.metaobject.DynamicInvokeResult;
import org.gradle.internal.metaobject.DynamicObject;
import org.gradle.util.internal.ConfigureUtil;
import org.jspecify.annotations.Nullable;

public class DefaultExtensionContainer
implements ExtensionContainerInternal {
    private static final TypeOf<ExtraPropertiesExtension> EXTRA_PROPERTIES_EXTENSION_TYPE = TypeOf.typeOf(ExtraPropertiesExtension.class);
    private final ExtensionsDynamicObject extensionsDynamicObject = new ExtensionsDynamicObject();
    private final ExtensionsStorage extensionsStorage = new ExtensionsStorage();
    private final ExtraPropertiesExtension extraProperties = new DefaultExtraPropertiesExtension();
    private final InstanceGenerator instanceGenerator;

    public DefaultExtensionContainer(InstanceGenerator instanceGenerator) {
        this.instanceGenerator = instanceGenerator;
        this.add(EXTRA_PROPERTIES_EXTENSION_TYPE, "ext", this.extraProperties);
    }

    public DynamicObject getExtensionsAsDynamicObject() {
        return this.extensionsDynamicObject;
    }

    public void add(String name, Object extension) {
        if (extension instanceof Class) {
            this.create(name, (Class)extension, new Object[0]);
        } else {
            this.addWithDefaultPublicType(name, extension);
        }
    }

    public <T> void add(Class<T> publicType, String name, T extension) {
        this.add(TypeOf.typeOf(publicType), name, extension);
    }

    public <T> void add(TypeOf<T> publicType, String name, T extension) {
        this.extensionsStorage.add(publicType, name, extension);
    }

    public <T> T create(String name, Class<T> instanceType, Object ... constructionArguments) {
        T instance = this.instantiate(instanceType, name, constructionArguments);
        this.addWithDefaultPublicType(name, instance);
        return instance;
    }

    public <T> T create(Class<T> publicType, String name, Class<? extends T> instanceType, Object ... constructionArguments) {
        return this.create(TypeOf.typeOf(publicType), name, instanceType, constructionArguments);
    }

    public <T> T create(TypeOf<T> publicType, String name, Class<? extends T> instanceType, Object ... constructionArguments) {
        T instance = this.instantiate(instanceType, name, constructionArguments);
        this.add(publicType, name, instance);
        return instance;
    }

    public ExtraPropertiesExtension getExtraProperties() {
        return this.extraProperties;
    }

    public ExtensionsSchema getExtensionsSchema() {
        return this.extensionsStorage.getSchema();
    }

    public <T> T getByType(Class<T> type) {
        return this.getByType(TypeOf.typeOf(type));
    }

    public <T> T getByType(TypeOf<T> type) {
        return this.extensionsStorage.getByType(type);
    }

    public <T> T findByType(Class<T> type) {
        return this.findByType(TypeOf.typeOf(type));
    }

    public <T> T findByType(TypeOf<T> type) {
        return this.extensionsStorage.findByType(type);
    }

    public Object getByName(String name) {
        return this.extensionsStorage.getByName(name);
    }

    public Object findByName(String name) {
        return this.extensionsStorage.findByName(name);
    }

    public <T> void configure(Class<T> type, Action<? super T> action) {
        this.configure(TypeOf.typeOf(type), action);
    }

    public <T> void configure(TypeOf<T> type, Action<? super T> action) {
        this.extensionsStorage.configureExtension(type, action);
    }

    public <T> void configure(String name, Action<? super T> action) {
        this.extensionsStorage.configureExtension(name, action);
    }

    @Override
    public Map<String, Object> getAsMap() {
        return this.extensionsStorage.getAsMap();
    }

    public Object propertyMissing(String name) {
        return this.getByName(name);
    }

    public void propertyMissing(String name, Object value) {
        this.checkExtensionIsNotReassigned(name);
        this.add(name, value);
    }

    private void addWithDefaultPublicType(String name, Object extension) {
        this.add(new DslObject(extension).getPublicType(), name, extension);
    }

    private <T> T instantiate(Class<? extends T> instanceType, String name, Object[] constructionArguments) {
        return this.instanceGenerator.newInstanceWithDisplayName(instanceType, (Describable)Describables.withTypeAndName((Object)"extension", (String)name), constructionArguments);
    }

    private void checkExtensionIsNotReassigned(String name) {
        if (this.extensionsStorage.hasExtension(name)) {
            throw new IllegalArgumentException(String.format("There's an extension registered with name '%s'. You should not reassign it via a property setter.", name));
        }
    }

    private boolean isConfigureExtensionMethod(String name, @Nullable Object[] args) {
        return args.length == 1 && (args[0] instanceof Closure || args[0] instanceof Action) && this.extensionsStorage.hasExtension(name);
    }

    private Object configureExtension(String name, Object[] args) {
        Action action = args[0] instanceof Closure ? ConfigureUtil.configureUsing((Closure)Cast.uncheckedCast((Object)args[0])) : (Action)Cast.uncheckedCast((Object)args[0]);
        return this.extensionsStorage.configureExtension(name, action);
    }

    private class ExtensionsDynamicObject
    extends AbstractDynamicObject {
        private ExtensionsDynamicObject() {
        }

        @Override
        public String getDisplayName() {
            return "extensions";
        }

        @Override
        public boolean hasProperty(String name) {
            return DefaultExtensionContainer.this.extensionsStorage.hasExtension(name);
        }

        public Map<String, @Nullable Object> getProperties() {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.putAll(DefaultExtensionContainer.this.extensionsStorage.getAsMap());
            return properties;
        }

        @Override
        public DynamicInvokeResult tryGetProperty(String name) {
            Object extension = DefaultExtensionContainer.this.extensionsStorage.findByName(name);
            if (extension != null) {
                return DynamicInvokeResult.found((Object)extension);
            }
            return DynamicInvokeResult.notFound();
        }

        public @Nullable Object propertyMissing(String name) {
            return this.getProperty(name);
        }

        public void propertyMissing(String name, Object value) {
            this.setProperty(name, value);
        }

        @Override
        public DynamicInvokeResult trySetProperty(String name, @Nullable Object value) {
            return this.trySetProperty(name);
        }

        @Override
        public DynamicInvokeResult trySetPropertyWithoutInstrumentation(String name, @Nullable Object value) {
            return this.trySetProperty(name);
        }

        private DynamicInvokeResult trySetProperty(String name) {
            DefaultExtensionContainer.this.checkExtensionIsNotReassigned(name);
            return DynamicInvokeResult.notFound();
        }

        @Override
        public DynamicInvokeResult tryInvokeMethod(String name, Object ... args) {
            if (DefaultExtensionContainer.this.isConfigureExtensionMethod(name, args)) {
                return DynamicInvokeResult.found((Object)DefaultExtensionContainer.this.configureExtension(name, args));
            }
            return DynamicInvokeResult.notFound();
        }

        public @Nullable Object methodMissing(String name, Object args) {
            return this.invokeMethod(name, (Object[])args);
        }

        @Override
        public boolean hasMethod(String name, Object ... args) {
            return DefaultExtensionContainer.this.isConfigureExtensionMethod(name, args);
        }
    }
}

