/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.problems.failure;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.gradle.internal.problems.failure.Failure;
import org.gradle.internal.problems.failure.StackTraceRelevance;

class DefaultFailure
implements Failure {
    private final Class<? extends Throwable> exceptionType;
    private final String message;
    private final List<StackTraceElement> stackTrace;
    private final List<StackTraceRelevance> frameRelevance;
    private final List<Failure> suppressed;
    private final List<Failure> causes;

    public DefaultFailure(Throwable original, List<StackTraceElement> stackTrace, List<StackTraceRelevance> frameRelevance, List<Failure> suppressed, List<Failure> causes) {
        if (stackTrace.size() != frameRelevance.size()) {
            throw new IllegalArgumentException("stackTrace and frameRelevance must have the same size.");
        }
        this.exceptionType = original.getClass();
        this.message = original.getLocalizedMessage();
        this.stackTrace = ImmutableList.copyOf(stackTrace);
        this.frameRelevance = ImmutableList.copyOf(frameRelevance);
        this.suppressed = ImmutableList.copyOf(suppressed);
        this.causes = ImmutableList.copyOf(causes);
    }

    public Class<? extends Throwable> getExceptionType() {
        return this.exceptionType;
    }

    public String getHeader() {
        return this.exceptionType.getName() + ": " + this.message;
    }

    public List<StackTraceElement> getStackTrace() {
        return this.stackTrace;
    }

    public StackTraceRelevance getStackTraceRelevance(int frameIndex) {
        return this.frameRelevance.get(frameIndex);
    }

    public List<Failure> getSuppressed() {
        return this.suppressed;
    }

    public List<Failure> getCauses() {
        return this.causes;
    }
}

