/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configurationcache.problems;

import java.io.Writer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.configurationcache.problems.DecoratedPropertyProblem;
import org.gradle.configurationcache.problems.DiagnosticKind;
import org.gradle.configurationcache.problems.HtmlReportTemplate;
import org.gradle.configurationcache.problems.JsonModelWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u00020\rH\u0002J\u0006\u0010\u000f\u001a\u00020\rJ*\u0010\u0010\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0012\u001a\u00020\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u00020\rH\u0002J\u0016\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bR\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lorg/gradle/configurationcache/problems/HtmlReportWriter;", "", "writer", "Ljava/io/Writer;", "(Ljava/io/Writer;)V", "htmlTemplate", "Lkotlin/Pair;", "", "jsonModelWriter", "Lorg/gradle/configurationcache/problems/JsonModelWriter;", "getWriter", "()Ljava/io/Writer;", "beginHtmlReport", "", "beginReportData", "close", "endHtmlReport", "buildDisplayName", "cacheAction", "requestedTasks", "totalProblemCount", "", "endReportData", "writeDiagnostic", "kind", "Lorg/gradle/configurationcache/problems/DiagnosticKind;", "details", "Lorg/gradle/configurationcache/problems/DecoratedPropertyProblem;", "configuration-cache"})
public final class HtmlReportWriter {
    @NotNull
    private final Writer writer;
    @NotNull
    private final JsonModelWriter jsonModelWriter;
    @NotNull
    private final Pair<String, String> htmlTemplate;

    public HtmlReportWriter(@NotNull Writer writer2) {
        Intrinsics.checkNotNullParameter((Object)writer2, (String)"writer");
        this.writer = writer2;
        this.jsonModelWriter = new JsonModelWriter(this.writer);
        this.htmlTemplate = HtmlReportTemplate.INSTANCE.load();
    }

    @NotNull
    public final Writer getWriter() {
        return this.writer;
    }

    public final void beginHtmlReport() {
        this.writer.append((CharSequence)this.htmlTemplate.getFirst());
        this.beginReportData();
        this.jsonModelWriter.beginModel();
    }

    public final void endHtmlReport(@Nullable String buildDisplayName, @NotNull String cacheAction, @Nullable String requestedTasks, int totalProblemCount) {
        Intrinsics.checkNotNullParameter((Object)cacheAction, (String)"cacheAction");
        this.jsonModelWriter.endModel(buildDisplayName, cacheAction, requestedTasks, totalProblemCount);
        this.endReportData();
        this.writer.append((CharSequence)this.htmlTemplate.getSecond());
    }

    private final void beginReportData() {
        Writer $this$beginReportData_u24lambda_u240 = this.writer;
        boolean bl = false;
        Appendable appendable = ((Appendable)$this$beginReportData_u24lambda_u240).append("<script type=\"text/javascript\">");
        Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)appendable.append('\n'), (String)"append(...)");
        Appendable appendable2 = ((Appendable)$this$beginReportData_u24lambda_u240).append("function configurationCacheProblems() { return (");
        Intrinsics.checkNotNullExpressionValue((Object)appendable2, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)appendable2.append('\n'), (String)"append(...)");
        Appendable appendable3 = ((Appendable)$this$beginReportData_u24lambda_u240).append("// begin-report-data");
        Intrinsics.checkNotNullExpressionValue((Object)appendable3, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)appendable3.append('\n'), (String)"append(...)");
    }

    private final void endReportData() {
        Writer $this$endReportData_u24lambda_u241 = this.writer;
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)((Appendable)$this$endReportData_u24lambda_u241).append('\n'), (String)"append(...)");
        Appendable appendable = ((Appendable)$this$endReportData_u24lambda_u241).append("// end-report-data");
        Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)appendable.append('\n'), (String)"append(...)");
        Appendable appendable2 = ((Appendable)$this$endReportData_u24lambda_u241).append(");}");
        Intrinsics.checkNotNullExpressionValue((Object)appendable2, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)appendable2.append('\n'), (String)"append(...)");
        Appendable appendable3 = ((Appendable)$this$endReportData_u24lambda_u241).append("</script>");
        Intrinsics.checkNotNullExpressionValue((Object)appendable3, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)appendable3.append('\n'), (String)"append(...)");
    }

    public final void writeDiagnostic(@NotNull DiagnosticKind kind, @NotNull DecoratedPropertyProblem details) {
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        Intrinsics.checkNotNullParameter((Object)details, (String)"details");
        this.jsonModelWriter.writeDiagnostic(kind, details);
    }

    public final void close() {
        this.writer.close();
    }
}

