/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.Collection;
import org.gradle.api.NonNullApi;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.Directory;
import org.gradle.buildinit.plugins.internal.BuildContentGenerationContext;
import org.gradle.buildinit.plugins.internal.VersionCatalogDependencyRegistry;
import org.gradle.util.internal.GFileUtils;

@NonNullApi
public class VersionCatalogGenerator {
    final Directory target;

    private VersionCatalogGenerator(Directory target) {
        this.target = target;
    }

    public static VersionCatalogGenerator create(Directory target) {
        return new VersionCatalogGenerator(target);
    }

    public void generate(BuildContentGenerationContext buildContentGenerationContext) {
        VersionCatalogDependencyRegistry versionCatalogDependencyRegistry = buildContentGenerationContext.getVersionCatalogDependencyRegistry();
        Path gradleDirectory = this.target.getAsFile().toPath().resolve("gradle");
        GFileUtils.mkdirs((File)gradleDirectory.toFile());
        try (PrintWriter writer = new PrintWriter(new FileWriter(gradleDirectory.resolve("libs.versions.toml").toFile()));){
            Collection<VersionCatalogDependencyRegistry.PluginEntry> collection;
            Collection<VersionCatalogDependencyRegistry.LibraryEntry> libraries;
            writer.println("# This file was generated by the Gradle 'init' task.");
            writer.println("# https://docs.gradle.org/current/userguide/platforms.html#sub::toml-dependencies-format");
            Collection<VersionCatalogDependencyRegistry.VersionEntry> versions = versionCatalogDependencyRegistry.getVersions();
            if (!versions.isEmpty()) {
                writer.println();
                writer.println("[versions]");
                for (VersionCatalogDependencyRegistry.VersionEntry versionEntry : versions) {
                    writer.println(String.format("%s = \"%s\"", versionEntry.alias, versionEntry.version));
                }
            }
            if (!(libraries = versionCatalogDependencyRegistry.getLibraries()).isEmpty()) {
                writer.println();
                writer.println("[libraries]");
                for (VersionCatalogDependencyRegistry.LibraryEntry l : versionCatalogDependencyRegistry.getLibraries()) {
                    writer.println(String.format("%s = { module = \"%s\", version.ref = \"%s\" }", l.alias, l.module, l.versionRef));
                }
            }
            if (!(collection = versionCatalogDependencyRegistry.getPlugins()).isEmpty()) {
                writer.println();
                writer.println("[plugins]");
                for (VersionCatalogDependencyRegistry.PluginEntry p : collection) {
                    writer.println(String.format("%s = { id = \"%s\", version = \"%s\" }", p.alias, p.pluginId, p.version));
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }
}

