/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.locking;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.StartParameter;
import org.gradle.api.Action;
import org.gradle.api.Describable;
import org.gradle.api.artifacts.ArtifactSelectionDetails;
import org.gradle.api.artifacts.DependencyArtifactSelector;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.dsl.LockMode;
import org.gradle.api.artifacts.result.ComponentSelectionDescriptor;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.DependencySubstitutionInternal;
import org.gradle.api.internal.artifacts.dependencies.DefaultMutableVersionConstraint;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyLockingProvider;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyLockingState;
import org.gradle.api.internal.artifacts.dsl.dependencies.LockEntryFilter;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DependencySubstitutionRules;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorInternal;
import org.gradle.api.internal.file.FilePropertyFactory;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.provider.PropertyFactory;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.locking.DefaultDependencyLockingState;
import org.gradle.internal.locking.DependencyLockingNotationConverter;
import org.gradle.internal.locking.InvalidLockFileException;
import org.gradle.internal.locking.LockEntryFilterFactory;
import org.gradle.internal.locking.LockFileReaderWriter;
import org.gradle.internal.locking.MissingLockStateException;
import org.gradle.internal.resource.local.FileResourceListener;

public class DefaultDependencyLockingProvider
implements DependencyLockingProvider {
    private static final Logger LOGGER = Logging.getLogger(DefaultDependencyLockingProvider.class);
    private static final DocumentationRegistry DOC_REG = new DocumentationRegistry();
    private final DependencyLockingNotationConverter converter = new DependencyLockingNotationConverter();
    private final LockFileReaderWriter lockFileReaderWriter;
    private final boolean writeLocks;
    private final boolean partialUpdate;
    private final LockEntryFilter updateLockEntryFilter;
    private final DomainObjectContext context;
    private final DependencySubstitutionRules dependencySubstitutionRules;
    private final Property<LockMode> lockMode;
    private final RegularFileProperty lockFile;
    private final ListProperty<String> ignoredDependencies;
    private boolean uniqueLockStateLoaded;
    private Map<String, List<String>> allLockState;
    private LockEntryFilter compoundLockEntryFilter;
    private LockEntryFilter ignoredEntryFilter;

    public DefaultDependencyLockingProvider(FileResolver fileResolver, StartParameter startParameter, DomainObjectContext context, DependencySubstitutionRules dependencySubstitutionRules, PropertyFactory propertyFactory, FilePropertyFactory filePropertyFactory, FileResourceListener listener) {
        List lockedDependenciesToUpdate;
        this.context = context;
        this.dependencySubstitutionRules = dependencySubstitutionRules;
        this.writeLocks = startParameter.isWriteDependencyLocks();
        if (this.writeLocks) {
            LOGGER.debug("Write locks is enabled");
        }
        this.partialUpdate = !(lockedDependenciesToUpdate = startParameter.getLockedDependenciesToUpdate()).isEmpty();
        this.updateLockEntryFilter = LockEntryFilterFactory.forParameter(lockedDependenciesToUpdate, "Update lock", true);
        this.lockMode = propertyFactory.property(LockMode.class);
        this.lockMode.convention((Object)LockMode.DEFAULT);
        this.lockFile = filePropertyFactory.newFileProperty();
        this.ignoredDependencies = propertyFactory.listProperty(String.class);
        this.lockFileReaderWriter = new LockFileReaderWriter(fileResolver, context, this.lockFile, listener);
    }

    private static ComponentSelector toComponentSelector(ModuleComponentIdentifier lockIdentifier) {
        String lockedVersion = lockIdentifier.getVersion();
        DefaultMutableVersionConstraint versionConstraint = DefaultMutableVersionConstraint.withVersion(lockedVersion);
        return DefaultModuleComponentSelector.newSelector(DefaultModuleIdentifier.newId(lockIdentifier.getGroup(), lockIdentifier.getModule()), versionConstraint);
    }

    @Override
    public DependencyLockingState loadLockState(String lockId, DisplayName lockOwner) {
        this.recordUsage();
        this.loadLockState();
        if (!this.writeLocks || this.partialUpdate) {
            List<String> lockedModules = this.findLockedModules(lockId);
            if (lockedModules == null && this.lockMode.get() == LockMode.STRICT) {
                throw new MissingLockStateException(lockOwner);
            }
            if (lockedModules != null) {
                HashSet results = Sets.newHashSetWithExpectedSize((int)lockedModules.size());
                for (String module : lockedModules) {
                    ModuleComponentIdentifier lockedIdentifier = this.parseLockNotation((Describable)lockOwner, module);
                    if (this.getCompoundLockEntryFilter().isSatisfiedBy(lockedIdentifier) || this.isSubstitutedInComposite(lockedIdentifier)) continue;
                    results.add(lockedIdentifier);
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Loaded state for lock with ID '{}', state is: {}", (Object)lockId, lockedModules);
                } else {
                    LOGGER.info("Loaded state for lock with ID '{}'", (Object)lockId);
                }
                boolean strictlyValidate = !this.partialUpdate && this.lockMode.get() != LockMode.LENIENT;
                return new DefaultDependencyLockingState(strictlyValidate, results, this.getIgnoredEntryFilter());
            }
        }
        return DefaultDependencyLockingState.EMPTY_LOCK_CONSTRAINT;
    }

    private LockEntryFilter getCompoundLockEntryFilter() {
        if (this.compoundLockEntryFilter == null) {
            this.compoundLockEntryFilter = LockEntryFilterFactory.combine(this.getIgnoredEntryFilter(), this.updateLockEntryFilter);
        }
        return this.compoundLockEntryFilter;
    }

    private LockEntryFilter getIgnoredEntryFilter() {
        if (this.ignoredEntryFilter == null) {
            this.ignoredEntryFilter = LockEntryFilterFactory.forParameter((List)this.ignoredDependencies.getOrElse(Collections.emptyList()), "Ignored dependencies", false);
        }
        return this.ignoredEntryFilter;
    }

    @Nullable
    private List<String> findLockedModules(String lockId) {
        List<String> result = this.allLockState.get(lockId);
        if (result == null) {
            result = this.lockFileReaderWriter.readLockFile(lockId);
        }
        return result;
    }

    private synchronized void loadLockState() {
        if (!this.uniqueLockStateLoaded) {
            try {
                this.allLockState = this.lockFileReaderWriter.readUniqueLockFile();
                this.uniqueLockStateLoaded = true;
            }
            catch (IllegalStateException e) {
                throw new InvalidLockFileException(this.context.getDisplayName(), e, LockFileReaderWriter.FORMATTING_DOC_LINK);
            }
        }
    }

    private void recordUsage() {
        this.lockMode.finalizeValue();
        this.lockFile.finalizeValue();
        this.ignoredDependencies.finalizeValue();
    }

    private boolean isSubstitutedInComposite(ModuleComponentIdentifier lockedIdentifier) {
        if (this.dependencySubstitutionRules.rulesMayAddProjectDependency()) {
            LockingDependencySubstitution lockingDependencySubstitution = new LockingDependencySubstitution(DefaultDependencyLockingProvider.toComponentSelector(lockedIdentifier));
            this.dependencySubstitutionRules.getRuleAction().execute((Object)lockingDependencySubstitution);
            return lockingDependencySubstitution.didSubstitute();
        }
        return false;
    }

    private ModuleComponentIdentifier parseLockNotation(Describable lockOwner, String module) {
        ModuleComponentIdentifier lockedIdentifier;
        try {
            lockedIdentifier = this.converter.convertFromLockNotation(module);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidLockFileException(lockOwner.getDisplayName(), e, LockFileReaderWriter.FORMATTING_DOC_LINK);
        }
        return lockedIdentifier;
    }

    @Override
    public void persistResolvedDependencies(String lockId, DisplayName lockOwner, Set<ModuleComponentIdentifier> resolvedModules, Set<ModuleComponentIdentifier> changingResolvedModules) {
        if (this.writeLocks) {
            List<String> modulesOrdered = this.getModulesOrdered(resolvedModules);
            if (!changingResolvedModules.isEmpty()) {
                LOGGER.warn("Dependency lock state for {} contains changing modules: {}. This means that dependencies content may still change over time. {}", new Object[]{lockOwner, this.getModulesOrdered(changingResolvedModules), DOC_REG.getDocumentationRecommendationFor("details", "dependency_locking")});
            }
            this.allLockState.put(lockId, modulesOrdered);
        }
    }

    @Override
    public void buildFinished() {
        if (this.uniqueLockStateLoaded && this.lockFileReaderWriter.canWrite()) {
            this.lockFileReaderWriter.writeUniqueLockfile(this.allLockState);
            LOGGER.lifecycle("Persisted dependency lock state for {}", new Object[]{this.context.getDisplayName()});
        }
    }

    private List<String> getModulesOrdered(Collection<ModuleComponentIdentifier> resolvedComponents) {
        ArrayList<String> modules = new ArrayList<String>(resolvedComponents.size());
        for (ModuleComponentIdentifier identifier : resolvedComponents) {
            if (this.getIgnoredEntryFilter().isSatisfiedBy(identifier)) continue;
            modules.add(this.converter.convertToLockNotation(identifier));
        }
        Collections.sort(modules);
        return modules;
    }

    @Override
    public Property<LockMode> getLockMode() {
        return this.lockMode;
    }

    @Override
    public RegularFileProperty getLockFile() {
        return this.lockFile;
    }

    @Override
    public ListProperty<String> getIgnoredDependencies() {
        return this.ignoredDependencies;
    }

    @Override
    public void confirmNotLocked(String lockId) {
        if (this.writeLocks) {
            this.loadLockState();
            this.allLockState.remove(lockId);
        }
    }

    private static class LockingDependencySubstitution
    implements DependencySubstitutionInternal {
        private final ComponentSelector selector;
        private boolean didSubstitute = false;

        private LockingDependencySubstitution(ComponentSelector selector) {
            this.selector = selector;
        }

        public ComponentSelector getRequested() {
            return this.selector;
        }

        public void useTarget(Object notation) {
            this.didSubstitute = true;
        }

        public void useTarget(Object notation, String reason) {
            this.didSubstitute = true;
        }

        public void artifactSelection(Action<? super ArtifactSelectionDetails> action) {
        }

        boolean didSubstitute() {
            return this.didSubstitute;
        }

        @Override
        public void useTarget(Object notation, ComponentSelectionDescriptor ruleDescriptor) {
            this.didSubstitute = true;
        }

        @Override
        @Nullable
        public ComponentSelector getConfiguredTargetSelector() {
            return this.selector;
        }

        @Override
        @Nullable
        public ImmutableList<ComponentSelectionDescriptorInternal> getRuleDescriptors() {
            throw new UnsupportedOperationException("Should not be called");
        }

        @Override
        @Nullable
        public ImmutableList<DependencyArtifactSelector> getConfiguredArtifactSelectors() {
            throw new UnsupportedOperationException("Should not be called");
        }
    }
}

