/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DependencySubstitutionApplicator;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExclusions;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ExcludeSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.ResolvedGraphVariant;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ComponentState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.DependencyState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.EdgeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.LenientPlatformDependencyMetadata;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.LenientPlatformGraphResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ModuleResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.PendingDependencies;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.PendingDependenciesVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.RootNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.VirtualPlatformState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.strict.StrictVersionConstraints;
import org.gradle.api.internal.capabilities.ImmutableCapability;
import org.gradle.api.internal.capabilities.ShadowedCapability;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.external.model.VirtualComponentIdentifier;
import org.gradle.internal.component.local.model.LocalFileDependencyMetadata;
import org.gradle.internal.component.local.model.LocalVariantGraphResolveState;
import org.gradle.internal.component.model.ComponentGraphResolveState;
import org.gradle.internal.component.model.ComponentGraphSpecificResolveState;
import org.gradle.internal.component.model.DelegatingDependencyMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.VariantGraphResolveMetadata;
import org.gradle.internal.component.model.VariantGraphResolveState;
import org.gradle.internal.logging.text.TreeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeState
implements DependencyGraphNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeState.class);
    private final long nodeId;
    private final ComponentState component;
    private final List<EdgeState> incomingEdges = new ArrayList<EdgeState>();
    private final List<EdgeState> outgoingEdges = new ArrayList<EdgeState>();
    private final VariantGraphResolveState variantState;
    private final VariantGraphResolveMetadata metadata;
    private final ResolveState resolveState;
    private final ModuleExclusions moduleExclusions;
    private final boolean isTransitive;
    private final boolean selectedByVariantAwareResolution;
    private final boolean dependenciesMayChange;
    @Nullable
    ExcludeSpec previousTraversalExclusions;
    @Nullable
    private List<EdgeState> virtualEdges;
    private boolean queued;
    private boolean evicted;
    private int transitiveEdgeCount;
    @Nullable
    private Set<ModuleIdentifier> upcomingNoLongerPendingConstraints;
    private boolean virtualPlatformNeedsRefresh;
    @Nullable
    private Set<EdgeState> edgesToRecompute;
    @Nullable
    private Multimap<ModuleIdentifier, DependencyState> potentiallyActivatedConstraints;
    private final Map<DependencyMetadata, DependencyState> dependencyStateCache = new HashMap<DependencyMetadata, DependencyState>();
    private final Map<DependencyState, EdgeState> edgesCache = new HashMap<DependencyState, EdgeState>();
    @Nullable
    private List<DependencyState> cachedDependencyStates;
    @Nullable
    private List<DependencyState> cachedFilteredDependencyStates;
    @Nullable
    private ExcludeSpec cachedNodeExclusions;
    private int previousIncomingEdgeCount;
    private long previousIncomingHash;
    private long incomingHash;
    @Nullable
    private ExcludeSpec cachedModuleResolutionFilter;
    private boolean visitedDependencies = false;
    @Nullable
    private StrictVersionConstraints previousAncestorsStrictVersions;
    @VisibleForTesting
    StrictVersionConstraints ancestorsStrictVersions = StrictVersionConstraints.EMPTY;
    @Nullable
    @VisibleForTesting
    StrictVersionConstraints ownStrictVersions;
    @Nullable
    private StrictVersionConstraints cachedEndorsedStrictVersions;
    private boolean findingExternalVariants;

    public NodeState(long nodeId, ComponentState component, ResolveState resolveState, VariantGraphResolveState variant, boolean selectedByVariantAwareResolution) {
        this.nodeId = nodeId;
        this.component = component;
        this.resolveState = resolveState;
        this.variantState = variant;
        this.metadata = variant.getMetadata();
        this.isTransitive = this.metadata.isTransitive() || this.metadata.isExternalVariant();
        this.selectedByVariantAwareResolution = selectedByVariantAwareResolution;
        this.moduleExclusions = resolveState.getModuleExclusions();
        this.dependenciesMayChange = component.getModule().isVirtualPlatform();
    }

    boolean enqueue() {
        if (this.queued) {
            return false;
        }
        this.queued = true;
        return true;
    }

    NodeState dequeue() {
        this.queued = false;
        return this;
    }

    @Override
    public ComponentState getComponent() {
        return this.component;
    }

    @Override
    public long getNodeId() {
        return this.nodeId;
    }

    @Override
    public ComponentGraphResolveState getComponentResolveState() {
        return this.getComponent().getResolveState();
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    @Override
    public ComponentState getOwner() {
        return this.component;
    }

    public List<EdgeState> getIncomingEdges() {
        return this.incomingEdges;
    }

    public List<EdgeState> getOutgoingEdges() {
        return this.outgoingEdges;
    }

    @Override
    public VariantGraphResolveMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public VariantGraphResolveState getResolveState() {
        return this.variantState;
    }

    @Override
    public Set<? extends LocalFileDependencyMetadata> getOutgoingFileEdges() {
        if (this.variantState instanceof LocalVariantGraphResolveState) {
            return ((LocalVariantGraphResolveState)this.variantState).getFiles();
        }
        return Collections.emptySet();
    }

    public String toString() {
        return this.getDisplayName();
    }

    public String getDisplayName() {
        return String.format("'%s' (%s)", this.component.getComponentId().getDisplayName(), this.metadata.getDisplayName());
    }

    public boolean isTransitive() {
        return this.isTransitive;
    }

    void visitOutgoingDependenciesAndCollectEdges(Collection<EdgeState> discoveredEdges) {
        ExcludeSpec resolutionFilter = this.computeModuleResolutionFilter(this.incomingEdges);
        StrictVersionConstraints ancestorsStrictVersions = this.ancestorsStrictVersions;
        this.doVisitDependencies(resolutionFilter, ancestorsStrictVersions, discoveredEdges);
        assert (this.previousTraversalExclusions == null == (this.previousAncestorsStrictVersions == null));
        this.previousTraversalExclusions = resolutionFilter;
        this.previousAncestorsStrictVersions = ancestorsStrictVersions;
    }

    private void doVisitDependencies(ExcludeSpec resolutionFilter, StrictVersionConstraints ancestorsStrictVersions, Collection<EdgeState> discoveredEdges) {
        if (this.transitiveEdgeCount == 0 && !this.isRoot() && this.canIgnoreExternalVariant()) {
            assert (!this.incomingEdges.isEmpty());
            this.removeOutgoingEdges();
            if (this.ownStrictVersions == null) {
                this.collectOwnStrictVersions(resolutionFilter);
            }
            this.visitOwners(resolutionFilter, ancestorsStrictVersions, discoveredEdges);
            return;
        }
        boolean sameExcludes = resolutionFilter.equals(this.previousTraversalExclusions);
        if (this.visitedDependencies && !this.virtualPlatformNeedsRefresh && (sameExcludes || this.applyDependencyExcludes(resolutionFilter, this.dependencyStates()).equals(this.cachedFilteredDependencyStates))) {
            if (!sameExcludes) {
                for (EdgeState outgoingEdge : this.outgoingEdges) {
                    outgoingEdge.updateTransitiveExcludesAndRequeueTargetNodes(resolutionFilter);
                }
                if (this.virtualEdges != null) {
                    for (EdgeState virtualEdge : this.virtualEdges) {
                        virtualEdge.updateTransitiveExcludesAndRequeueTargetNodes(resolutionFilter);
                    }
                }
            }
            if (!ancestorsStrictVersions.equals(this.previousAncestorsStrictVersions)) {
                for (EdgeState outgoingEdge : this.outgoingEdges) {
                    outgoingEdge.recomputeSelectorAndRequeueTargetNodes(ancestorsStrictVersions, discoveredEdges);
                }
                if (this.virtualEdges != null) {
                    for (EdgeState virtualEdge : this.virtualEdges) {
                        virtualEdge.recomputeSelectorAndRequeueTargetNodes(ancestorsStrictVersions, discoveredEdges);
                    }
                }
            }
            this.visitNewAndInvalidatedDependencies(resolutionFilter, ancestorsStrictVersions, discoveredEdges);
            return;
        }
        assert (!this.visitedDependencies || this.previousTraversalExclusions != null);
        this.removeOutgoingEdges();
        this.visitDependencies(resolutionFilter, ancestorsStrictVersions, discoveredEdges);
        this.visitOwners(resolutionFilter, ancestorsStrictVersions, discoveredEdges);
    }

    private void visitNewAndInvalidatedDependencies(ExcludeSpec resolutionFilter, StrictVersionConstraints ancestorsStrictVersions, Collection<EdgeState> discoveredEdges) {
        if (this.upcomingNoLongerPendingConstraints != null && this.potentiallyActivatedConstraints != null) {
            for (ModuleIdentifier moduleId : this.upcomingNoLongerPendingConstraints) {
                Collection dependencyStates = this.potentiallyActivatedConstraints.get((Object)moduleId);
                if (dependencyStates.isEmpty()) continue;
                ModuleResolveState module = this.resolveState.getModule(moduleId);
                if (module.isPending()) {
                    module.getPendingDependencies().registerConstraintProvider(this);
                    continue;
                }
                for (DependencyState dependencyState : dependencyStates) {
                    this.createAndLinkEdgeState(dependencyState, discoveredEdges, resolutionFilter, ancestorsStrictVersions, false);
                }
            }
            this.upcomingNoLongerPendingConstraints = null;
        }
        if (this.edgesToRecompute != null) {
            discoveredEdges.addAll(this.edgesToRecompute);
            this.edgesToRecompute = null;
        }
    }

    private boolean canIgnoreExternalVariant() {
        if (!this.metadata.isExternalVariant()) {
            return true;
        }
        for (EdgeState incomingEdge : this.incomingEdges) {
            if (incomingEdge.isArtifactOnlyEdge()) continue;
            return false;
        }
        return true;
    }

    private void cleanupConstraints() {
        if (this.upcomingNoLongerPendingConstraints != null) {
            for (ModuleIdentifier identifier : this.upcomingNoLongerPendingConstraints) {
                ModuleResolveState module = this.resolveState.getModule(identifier);
                for (EdgeState unattachedEdge : module.getUnattachedEdges()) {
                    if (unattachedEdge.getSelector().isResolved()) continue;
                    NodeState from = unattachedEdge.getFrom();
                    from.prepareToRecomputeEdge(unattachedEdge);
                }
            }
            this.upcomingNoLongerPendingConstraints = null;
        }
        if (this.cachedFilteredDependencyStates != null && !this.cachedFilteredDependencyStates.isEmpty()) {
            for (DependencyState dependencyState : this.cachedFilteredDependencyStates) {
                ModuleResolveState targetModule;
                if (!dependencyState.getDependency().isConstraint() || !(targetModule = this.resolveState.getModule(dependencyState.getModuleIdentifier(this.resolveState.getComponentSelectorConverter()))).isPending()) continue;
                targetModule.unregisterConstraintProvider(this);
            }
        }
    }

    void prepareToRecomputeEdge(EdgeState edgeToRecompute) {
        if (this.edgesToRecompute == null) {
            this.edgesToRecompute = new LinkedHashSet<EdgeState>();
        }
        this.edgesToRecompute.add(edgeToRecompute);
        this.resolveState.onMoreSelected(this);
    }

    private void visitDependencies(ExcludeSpec resolutionFilter, StrictVersionConstraints ancestorsStrictVersions, Collection<EdgeState> discoveredEdges) {
        this.potentiallyActivatedConstraints = null;
        this.upcomingNoLongerPendingConstraints = null;
        PendingDependenciesVisitor pendingDepsVisitor = this.resolveState.newPendingDependenciesVisitor();
        Set<ModuleIdentifier> strictVersionsSet = null;
        for (DependencyState dependencyState : this.dependencies(resolutionFilter)) {
            PendingDependenciesVisitor.PendingState pendingState = pendingDepsVisitor.maybeAddAsPendingDependency(this, dependencyState);
            if (dependencyState.getDependency().isConstraint()) {
                this.registerActivatingConstraint(dependencyState);
            }
            if (!pendingState.isPending()) {
                this.createAndLinkEdgeState(dependencyState, discoveredEdges, resolutionFilter, ancestorsStrictVersions, pendingState == PendingDependenciesVisitor.PendingState.NOT_PENDING_ACTIVATING);
            }
            strictVersionsSet = this.maybeCollectStrictVersions(strictVersionsSet, dependencyState);
        }
        pendingDepsVisitor.complete();
        this.storeOwnStrictVersions(strictVersionsSet);
        this.visitedDependencies = true;
    }

    private void registerActivatingConstraint(DependencyState dependencyState) {
        if (this.potentiallyActivatedConstraints == null) {
            this.potentiallyActivatedConstraints = LinkedHashMultimap.create();
        }
        this.potentiallyActivatedConstraints.put((Object)dependencyState.getModuleIdentifier(this.resolveState.getComponentSelectorConverter()), (Object)dependencyState);
    }

    private List<DependencyState> dependencyStates() {
        if (this.dependenciesMayChange || this.cachedDependencyStates == null) {
            List<? extends DependencyMetadata> dependencies = this.getAllDependencies();
            if (this.transitiveEdgeCount == 0 && this.metadata.isExternalVariant()) {
                assert (dependencies.size() == 1);
                dependencies = Collections.singletonList(NodeState.makeNonTransitive(dependencies.get(0)));
            }
            this.cachedDependencyStates = this.cacheDependencyStates(dependencies);
        }
        return this.cachedDependencyStates;
    }

    protected List<? extends DependencyMetadata> getAllDependencies() {
        return this.variantState.getDependencies();
    }

    private static DependencyMetadata makeNonTransitive(DependencyMetadata dependencyMetadata) {
        return new NonTransitiveVariantDependencyMetadata(dependencyMetadata);
    }

    private List<DependencyState> dependencies(ExcludeSpec spec) {
        if (this.dependenciesMayChange || this.cachedFilteredDependencyStates == null) {
            this.cachedFilteredDependencyStates = this.applyDependencyExcludes(spec, this.dependencyStates());
        }
        return this.cachedFilteredDependencyStates;
    }

    private List<DependencyState> applyDependencyExcludes(ExcludeSpec spec, List<DependencyState> from) {
        if (from.isEmpty()) {
            return from;
        }
        ArrayList<DependencyState> tmp = new ArrayList<DependencyState>(from.size());
        for (DependencyState dependencyState : from) {
            if (this.isExcluded(spec, dependencyState)) continue;
            tmp.add(dependencyState);
        }
        return tmp;
    }

    private List<DependencyState> cacheDependencyStates(List<? extends DependencyMetadata> dependencies) {
        if (dependencies.isEmpty()) {
            return Collections.emptyList();
        }
        DependencySubstitutionApplicator dependencySubstitutionApplicator = this.resolveState.getDependencySubstitutionApplicator();
        ArrayList<DependencyState> result = new ArrayList<DependencyState>(dependencies.size());
        for (DependencyMetadata dependencyMetadata : dependencies) {
            result.add(this.dependencyStateCache.computeIfAbsent(dependencyMetadata, dependencySubstitutionApplicator::applySubstitutions));
        }
        return result;
    }

    private void createAndLinkEdgeState(DependencyState dependencyState, Collection<EdgeState> discoveredEdges, ExcludeSpec resolutionFilter, StrictVersionConstraints ancestorsStrictVersions, boolean deferSelection) {
        EdgeState dependencyEdge = this.edgesCache.computeIfAbsent(dependencyState, ds -> new EdgeState(this, (DependencyState)ds, this.resolveState));
        dependencyEdge.updateTransitiveExcludes(resolutionFilter);
        dependencyEdge.computeSelector(ancestorsStrictVersions, deferSelection);
        discoveredEdges.add(dependencyEdge);
        this.outgoingEdges.add(dependencyEdge);
    }

    private void visitOwners(ExcludeSpec resolutionFilter, StrictVersionConstraints ancestorsStrictVersions, Collection<EdgeState> discoveredEdges) {
        List<? extends VirtualComponentIdentifier> owners = this.component.getMetadata().getPlatformOwners();
        if (!owners.isEmpty()) {
            PendingDependenciesVisitor visitor = this.resolveState.newPendingDependenciesVisitor();
            for (VirtualComponentIdentifier virtualComponentIdentifier : owners) {
                if (!(virtualComponentIdentifier instanceof ModuleComponentIdentifier)) continue;
                ModuleComponentIdentifier platformId = (ModuleComponentIdentifier)virtualComponentIdentifier;
                this.resolvePlatform(platformId);
                this.visitVirtualPlatformEdge(discoveredEdges, platformId, ancestorsStrictVersions, resolutionFilter);
                visitor.markNotPending(platformId.getModuleIdentifier());
            }
            visitor.complete();
        }
    }

    private void resolvePlatform(ModuleComponentIdentifier componentId) {
        ModuleVersionIdentifier toModuleVersionId = DefaultModuleVersionIdentifier.newId(componentId.getModuleIdentifier(), componentId.getVersion());
        ComponentState componentState = this.resolveState.getModule(componentId.getModuleIdentifier()).getVersion(toModuleVersionId, (ComponentIdentifier)componentId);
        ComponentGraphResolveState resolvedComponent = componentState.getResolveStateOrNull();
        VirtualPlatformState virtualPlatformState = null;
        if (resolvedComponent == null || resolvedComponent instanceof LenientPlatformGraphResolveState) {
            virtualPlatformState = componentState.getModule().getPlatformState();
            virtualPlatformState.participatingModule(this.component.getModule());
        }
        if (resolvedComponent == null) {
            LenientPlatformGraphResolveState newLenientPlatform = LenientPlatformGraphResolveState.of(this.resolveState.getIdGenerator(), componentId, toModuleVersionId, virtualPlatformState, this, this.resolveState);
            componentState.setState(newLenientPlatform, ComponentGraphSpecificResolveState.EMPTY_STATE);
            componentState.getModule().maybeCreateVirtualMetadata(this.resolveState);
        }
    }

    private void visitVirtualPlatformEdge(Collection<EdgeState> discoveredEdges, ModuleComponentIdentifier componentId, StrictVersionConstraints ancestorsStrictVersions, ExcludeSpec resolutionFilter) {
        boolean forced = this.hasStrongOpinion();
        ModuleComponentSelector selector = DefaultModuleComponentSelector.newSelector(componentId.getModuleIdentifier(), componentId.getVersion());
        LenientPlatformDependencyMetadata dependencyMetadata = new LenientPlatformDependencyMetadata(this.resolveState, this, selector, componentId, (ComponentIdentifier)componentId, forced, true);
        DependencyState dependencyState = this.resolveState.getDependencySubstitutionApplicator().applySubstitutions(dependencyMetadata);
        EdgeState edge = new EdgeState(this, dependencyState, this.resolveState);
        edge.updateTransitiveExcludes(resolutionFilter);
        edge.computeSelector(ancestorsStrictVersions, false);
        discoveredEdges.add(edge);
        if (this.virtualEdges == null) {
            this.virtualEdges = new ArrayList<EdgeState>();
        }
        this.virtualEdges.add(edge);
    }

    private boolean hasStrongOpinion() {
        for (EdgeState edgeState : this.incomingEdges) {
            if (!edgeState.getSelector().hasStrongOpinion()) continue;
            return true;
        }
        return false;
    }

    private boolean isExcluded(ExcludeSpec excludeSpec, DependencyState dependencyState) {
        DependencyMetadata dependency = dependencyState.getDependency();
        if (!this.resolveState.getEdgeFilter().isSatisfiedBy((Object)dependency)) {
            LOGGER.debug("{} is filtered.", (Object)dependency);
            return true;
        }
        if (excludeSpec == this.moduleExclusions.nothing()) {
            return false;
        }
        ModuleIdentifier targetModuleId = dependencyState.getModuleIdentifier(this.resolveState.getComponentSelectorConverter());
        if (excludeSpec.excludes(targetModuleId)) {
            LOGGER.debug("{} is excluded from {} by {}.", new Object[]{targetModuleId, this, excludeSpec});
            return true;
        }
        return false;
    }

    void addIncomingEdge(EdgeState dependencyEdge) {
        if (!this.incomingEdges.contains(dependencyEdge)) {
            this.incomingEdges.add(dependencyEdge);
            this.incomingHash += (long)dependencyEdge.hashCode();
            if (dependencyEdge.isTransitive()) {
                ++this.transitiveEdgeCount;
            }
            this.requeueChildrenOfEndorsingParent(dependencyEdge);
            this.cachedModuleResolutionFilter = null;
            if (this.incomingEdges.size() == 1) {
                this.updateAncestorsStrictVersions(this.getStrictVersionsForEdge(dependencyEdge));
            } else {
                this.updateAncestorsStrictVersions(this.ancestorsStrictVersions.intersect(this.getStrictVersionsForEdge(dependencyEdge)));
            }
            this.resolveState.onMoreSelected(this);
        }
    }

    void removeIncomingEdge(EdgeState dependencyEdge) {
        if (this.incomingEdges.remove(dependencyEdge)) {
            this.incomingHash -= (long)dependencyEdge.hashCode();
            if (dependencyEdge.isTransitive()) {
                --this.transitiveEdgeCount;
            }
            this.requeueChildrenOfEndorsingParent(dependencyEdge);
            this.cachedModuleResolutionFilter = null;
            this.recomputeAncestorsStrictVersions();
            this.resolveState.onFewerSelected(this);
        }
    }

    private void requeueChildrenOfEndorsingParent(EdgeState incomingEdge) {
        if (incomingEdge.getDependencyMetadata().isEndorsingStrictVersions()) {
            NodeState sourceNode = incomingEdge.getFrom();
            sourceNode.invalidateEndorsedStrictVersions();
            for (EdgeState edge : sourceNode.getOutgoingEdges()) {
                for (NodeState node : edge.getTargetNodes()) {
                    if (node == this) continue;
                    this.resolveState.onMoreSelected(node);
                }
            }
        }
    }

    void clearTransitiveExclusionsAndEnqueue() {
        this.cachedModuleResolutionFilter = null;
        this.resolveState.onMoreSelected(this);
    }

    @Override
    public boolean isSelected() {
        return !this.incomingEdges.isEmpty();
    }

    public void evict() {
        this.evicted = true;
    }

    boolean shouldIncludedInGraphResult() {
        return this.isSelected() && !this.component.getModule().isVirtualPlatform();
    }

    private ExcludeSpec computeModuleResolutionFilter(List<EdgeState> incomingEdges) {
        NodeState from;
        if (this.metadata.isExternalVariant()) {
            return this.moduleExclusions.excludeAny(incomingEdges.stream().map(EdgeState::getTransitiveExclusions).filter(Objects::nonNull).collect(Collectors.toSet()));
        }
        if (incomingEdges.size() == 1 && (from = incomingEdges.get(0).getFrom()).getMetadata().isExternalVariant()) {
            return this.computeModuleResolutionFilter((List<EdgeState>)from.getIncomingEdges());
        }
        ExcludeSpec nodeExclusions = this.computeNodeExclusions();
        if (incomingEdges.isEmpty()) {
            return nodeExclusions;
        }
        return this.computeExclusionFilter(incomingEdges, nodeExclusions);
    }

    private ExcludeSpec computeNodeExclusions() {
        if (this.cachedNodeExclusions == null) {
            this.cachedNodeExclusions = this.moduleExclusions.excludeAny(this.variantState.getExcludes());
        }
        return this.cachedNodeExclusions;
    }

    private ExcludeSpec computeExclusionFilter(List<EdgeState> incomingEdges, ExcludeSpec nodeExclusions) {
        int incomingEdgeCount = incomingEdges.size();
        if (this.sameIncomingEdgesAsPreviousPass(incomingEdgeCount)) {
            return this.cachedModuleResolutionFilter;
        }
        if (incomingEdgeCount == 1) {
            return this.computeExclusionFilterSingleIncomingEdge(incomingEdges.get(0), nodeExclusions);
        }
        return this.computeModuleExclusionsManyEdges(incomingEdges, nodeExclusions, incomingEdgeCount);
    }

    private ExcludeSpec computeModuleExclusionsManyEdges(List<EdgeState> incomingEdges, ExcludeSpec nodeExclusions, int incomingEdgeCount) {
        ExcludeSpec nothing = this.moduleExclusions.nothing();
        ExcludeSpec edgeExclusions = null;
        HashSet excludedByBoth = null;
        Set<ExcludeSpec> excludedByEither = null;
        for (EdgeState dependencyEdge : incomingEdges) {
            if (dependencyEdge.isTransitive()) {
                if (edgeExclusions == nothing) continue;
                ExcludeSpec exclusions = dependencyEdge.getExclusions();
                if (edgeExclusions == null || exclusions == nothing) {
                    edgeExclusions = exclusions;
                } else if (edgeExclusions != exclusions) {
                    if (excludedByBoth == null) {
                        excludedByBoth = Sets.newHashSetWithExpectedSize((int)incomingEdgeCount);
                    }
                    excludedByBoth.add(exclusions);
                }
                if (edgeExclusions != nothing) continue;
                excludedByBoth = null;
                continue;
            }
            if (!dependencyEdge.isConstraint()) continue;
            excludedByEither = NodeState.collectEdgeConstraint(nodeExclusions, excludedByEither, dependencyEdge, nothing, incomingEdgeCount);
        }
        edgeExclusions = this.intersectEdgeExclusions(edgeExclusions, excludedByBoth);
        nodeExclusions = this.joinNodeExclusions(nodeExclusions, excludedByEither);
        return this.joinEdgeAndNodeExclusionsThenCacheResult(nodeExclusions, edgeExclusions, incomingEdgeCount);
    }

    private ExcludeSpec computeExclusionFilterSingleIncomingEdge(EdgeState dependencyEdge, ExcludeSpec nodeExclusions) {
        ExcludeSpec exclusions = null;
        if (dependencyEdge.isTransitive()) {
            exclusions = dependencyEdge.getExclusions();
        } else if (dependencyEdge.isConstraint()) {
            exclusions = dependencyEdge.getEdgeExclusions();
        }
        if (exclusions == null) {
            exclusions = this.moduleExclusions.nothing();
        }
        return this.joinEdgeAndNodeExclusionsThenCacheResult(nodeExclusions, exclusions, 1);
    }

    private ExcludeSpec joinEdgeAndNodeExclusionsThenCacheResult(ExcludeSpec nodeExclusions, ExcludeSpec edgeExclusions, int incomingEdgeCount) {
        ExcludeSpec result = this.moduleExclusions.excludeAny(edgeExclusions, nodeExclusions);
        this.previousIncomingEdgeCount = incomingEdgeCount;
        this.previousIncomingHash = this.incomingHash;
        this.cachedModuleResolutionFilter = result;
        return result;
    }

    @Nullable
    private static Set<ExcludeSpec> collectEdgeConstraint(ExcludeSpec nodeExclusions, @Nullable Set<ExcludeSpec> excludedByEither, EdgeState dependencyEdge, ExcludeSpec nothing, int incomingEdgeCount) {
        ExcludeSpec constraintExclusions = dependencyEdge.getEdgeExclusions();
        if (constraintExclusions != nothing && constraintExclusions != nodeExclusions) {
            if (excludedByEither == null) {
                excludedByEither = Sets.newHashSetWithExpectedSize((int)incomingEdgeCount);
            }
            excludedByEither.add(constraintExclusions);
        }
        return excludedByEither;
    }

    @Nullable
    private ExcludeSpec joinNodeExclusions(@Nullable ExcludeSpec nodeExclusions, @Nullable Set<ExcludeSpec> excludedByEither) {
        if (excludedByEither != null && nodeExclusions != null) {
            excludedByEither.add(nodeExclusions);
            nodeExclusions = this.moduleExclusions.excludeAny(excludedByEither);
        }
        return nodeExclusions;
    }

    @Nullable
    private ExcludeSpec intersectEdgeExclusions(@Nullable ExcludeSpec edgeExclusions, @Nullable Set<ExcludeSpec> excludedByBoth) {
        if (edgeExclusions == this.moduleExclusions.nothing()) {
            return edgeExclusions;
        }
        if (excludedByBoth != null) {
            if (edgeExclusions != null) {
                excludedByBoth.add(edgeExclusions);
            }
            edgeExclusions = this.moduleExclusions.excludeAll(excludedByBoth);
        }
        return edgeExclusions;
    }

    @VisibleForTesting
    void collectOwnStrictVersions(ExcludeSpec moduleResolutionFilter) {
        List<DependencyState> dependencies = this.dependencies(moduleResolutionFilter);
        Set<ModuleIdentifier> constraintsSet = null;
        for (DependencyState dependencyState : dependencies) {
            constraintsSet = this.maybeCollectStrictVersions(constraintsSet, dependencyState);
        }
        this.storeOwnStrictVersions(constraintsSet);
    }

    @Nullable
    private Set<ModuleIdentifier> maybeCollectStrictVersions(@Nullable Set<ModuleIdentifier> constraintsSet, DependencyState dependencyState) {
        ModuleComponentSelector selector;
        if (dependencyState.getDependency().getSelector() instanceof ModuleComponentSelector && !StringUtils.isEmpty((String)(selector = (ModuleComponentSelector)dependencyState.getDependency().getSelector()).getVersionConstraint().getStrictVersion())) {
            if (constraintsSet == null) {
                constraintsSet = new HashSet<ModuleIdentifier>();
            }
            constraintsSet.add(selector.getModuleIdentifier());
        }
        return constraintsSet;
    }

    private void storeOwnStrictVersions(@Nullable Set<ModuleIdentifier> constraintsSet) {
        StrictVersionConstraints newStrictVersions = constraintsSet == null ? StrictVersionConstraints.EMPTY : StrictVersionConstraints.of((ImmutableSet<ModuleIdentifier>)ImmutableSet.copyOf(constraintsSet));
        StrictVersionConstraints existingOwnStrictVersions = this.ownStrictVersions;
        this.ownStrictVersions = newStrictVersions;
        if (existingOwnStrictVersions == null) {
            return;
        }
        if (!newStrictVersions.equals(existingOwnStrictVersions)) {
            for (EdgeState incomingEdge : this.incomingEdges) {
                if (!incomingEdge.getDependencyMetadata().isEndorsingStrictVersions()) continue;
                incomingEdge.getFrom().invalidateEndorsedStrictVersions();
                this.recomputeAncestorsStrictVersions();
            }
            for (EdgeState outgoingEdge : this.outgoingEdges) {
                for (NodeState targetNode : outgoingEdge.getTargetNodes()) {
                    targetNode.recomputeAncestorsStrictVersions();
                }
            }
        }
    }

    @VisibleForTesting
    void recomputeAncestorsStrictVersions() {
        this.updateAncestorsStrictVersions(this.collectAncestorsStrictVersions());
    }

    private void updateAncestorsStrictVersions(StrictVersionConstraints newAncestorsStrictVersions) {
        if (newAncestorsStrictVersions.equals(this.ancestorsStrictVersions)) {
            return;
        }
        this.ancestorsStrictVersions = newAncestorsStrictVersions;
        for (EdgeState outgoingEdge : this.outgoingEdges) {
            for (NodeState targetNode : outgoingEdge.getTargetNodes()) {
                targetNode.recomputeAncestorsStrictVersions();
            }
        }
    }

    private StrictVersionConstraints collectAncestorsStrictVersions() {
        if (this.incomingEdges.isEmpty()) {
            return StrictVersionConstraints.EMPTY;
        }
        if (this.incomingEdges.size() == 1) {
            EdgeState dependencyEdge = this.incomingEdges.get(0);
            if (dependencyEdge.getFrom().isSelected()) {
                return this.getStrictVersionsForEdge(dependencyEdge);
            }
            return StrictVersionConstraints.EMPTY;
        }
        StrictVersionConstraints ancestorsStrictVersions = null;
        for (EdgeState dependencyEdge : this.incomingEdges) {
            if (!dependencyEdge.getFrom().isSelected()) continue;
            StrictVersionConstraints allEdgeStrictVersions = this.getStrictVersionsForEdge(dependencyEdge);
            if ((ancestorsStrictVersions = ancestorsStrictVersions == null ? allEdgeStrictVersions : ancestorsStrictVersions.intersect(allEdgeStrictVersions)) != StrictVersionConstraints.EMPTY) continue;
            break;
        }
        return ancestorsStrictVersions != null ? ancestorsStrictVersions : StrictVersionConstraints.EMPTY;
    }

    private StrictVersionConstraints getStrictVersionsForEdge(EdgeState dependencyEdge) {
        NodeState from = dependencyEdge.getFrom();
        StrictVersionConstraints parentStrongStrictVersions = from.getStrongStrictVersions();
        StrictVersionConstraints parentEndorsedStrictVersions = from.getEndorsedStrictVersions();
        StrictVersionConstraints filteredEndorsedStrictVersions = dependencyEdge.getDependencyMetadata().isEndorsingStrictVersions() ? parentEndorsedStrictVersions.minus(this.ownStrictVersions) : parentEndorsedStrictVersions;
        return parentStrongStrictVersions.union(filteredEndorsedStrictVersions);
    }

    private StrictVersionConstraints getStrongStrictVersions() {
        assert (this.ownStrictVersions != null);
        return this.ownStrictVersions.union(this.ancestorsStrictVersions);
    }

    private void invalidateEndorsedStrictVersions() {
        this.cachedEndorsedStrictVersions = null;
        for (EdgeState outgoingEdge : this.outgoingEdges) {
            for (NodeState targetNode : outgoingEdge.getTargetNodes()) {
                targetNode.recomputeAncestorsStrictVersions();
            }
        }
    }

    private StrictVersionConstraints getEndorsedStrictVersions() {
        if (this.cachedEndorsedStrictVersions == null) {
            this.cachedEndorsedStrictVersions = this.computeEndorsedStrictVersions();
        }
        return this.cachedEndorsedStrictVersions;
    }

    private StrictVersionConstraints computeEndorsedStrictVersions() {
        StrictVersionConstraints endorsedStrictVersions = StrictVersionConstraints.EMPTY;
        for (EdgeState edgeState : this.outgoingEdges) {
            if (!edgeState.getDependencyState().getDependency().isEndorsingStrictVersions()) continue;
            for (NodeState endorsedNode : edgeState.getTargetNodes()) {
                if (endorsedNode.ownStrictVersions == null) {
                    endorsedNode.collectOwnStrictVersions(endorsedNode.computeModuleResolutionFilter(endorsedNode.incomingEdges));
                }
                endorsedStrictVersions = endorsedStrictVersions.union(endorsedNode.ownStrictVersions);
            }
        }
        return endorsedStrictVersions;
    }

    private boolean sameIncomingEdgesAsPreviousPass(int incomingEdgeCount) {
        return this.cachedModuleResolutionFilter != null && this.previousIncomingHash == this.incomingHash && this.previousIncomingEdgeCount == incomingEdgeCount;
    }

    boolean isDisconnected() {
        return this.previousTraversalExclusions == null && !this.visitedDependencies;
    }

    public void removeOutgoingEdges() {
        if (this.previousTraversalExclusions == null) {
            return;
        }
        if (!this.outgoingEdges.isEmpty()) {
            for (EdgeState outgoingEdge : this.outgoingEdges) {
                this.disconnectOutgoingEdge(outgoingEdge);
            }
            this.outgoingEdges.clear();
        }
        if (this.virtualEdges != null) {
            for (EdgeState virtualEdge : this.virtualEdges) {
                this.disconnectOutgoingEdge(virtualEdge);
            }
            this.virtualEdges = null;
        }
        this.cleanupConstraints();
        this.previousTraversalExclusions = null;
        this.previousAncestorsStrictVersions = null;
        this.visitedDependencies = false;
        this.cachedFilteredDependencyStates = null;
        this.edgesToRecompute = null;
        this.virtualPlatformNeedsRefresh = false;
    }

    private void disconnectOutgoingEdge(EdgeState outgoingEdge) {
        outgoingEdge.detachFromTargetNodes();
        outgoingEdge.getSelector().getTargetModule().disconnectIncomingEdge(this, outgoingEdge);
    }

    public void restart(ComponentState selected) {
        if (this.component == selected && !this.evicted) {
            this.resolveState.onMoreSelected(this);
            return;
        }
        if (!this.incomingEdges.isEmpty()) {
            this.restartIncomingEdges();
        }
    }

    private void restartIncomingEdges() {
        if (this.incomingEdges.size() == 1) {
            EdgeState singleEdge = this.incomingEdges.get(0);
            singleEdge.retarget();
        } else {
            for (EdgeState edge : new ArrayList<EdgeState>(this.incomingEdges)) {
                edge.retarget();
            }
        }
        this.clearIncomingEdges();
    }

    private void clearIncomingEdges() {
        this.incomingEdges.clear();
        this.incomingHash = 0L;
        this.transitiveEdgeCount = 0;
        this.cachedModuleResolutionFilter = null;
        this.recomputeAncestorsStrictVersions();
    }

    public void deselect() {
        this.removeOutgoingEdges();
    }

    void prepareForConstraintNoLongerPending(ModuleIdentifier moduleIdentifier) {
        if (this.upcomingNoLongerPendingConstraints == null) {
            this.upcomingNoLongerPendingConstraints = new LinkedHashSet<ModuleIdentifier>();
        }
        this.upcomingNoLongerPendingConstraints.add(moduleIdentifier);
        this.resolveState.onFewerSelected(this);
    }

    void markForVirtualPlatformRefresh() {
        assert (this.component.getModule().isVirtualPlatform());
        this.virtualPlatformNeedsRefresh = true;
        this.resolveState.onFewerSelected(this);
    }

    public void clearIncomingConstraints(PendingDependencies pendingDependencies, NodeState backToPendingSource) {
        if (this.incomingEdges.isEmpty()) {
            return;
        }
        ImmutableList remainingIncomingEdges = ImmutableList.copyOf(this.incomingEdges);
        this.clearIncomingEdges();
        for (EdgeState incomingEdge : remainingIncomingEdges) {
            assert (incomingEdge.isConstraint());
            NodeState from = incomingEdge.getFrom();
            if (from != backToPendingSource) {
                from.removeOutgoingEdge(incomingEdge);
            }
            pendingDependencies.registerConstraintProvider(from);
        }
    }

    void removeOutgoingEdge(EdgeState edge) {
        this.outgoingEdges.remove(edge);
        edge.clearSelector();
    }

    @Nullable
    public ImmutableCapability findCapability(String group, String name) {
        ImmutableCapabilities capabilities = this.metadata.getCapabilities();
        if (capabilities.isEmpty()) {
            if (this.component.getId().getGroup().equals(group) && this.component.getId().getName().equals(name)) {
                return this.component.getImplicitCapability();
            }
        } else {
            for (ImmutableCapability capability : capabilities) {
                if (!capability.getGroup().equals(group) || !capability.getName().equals(name)) continue;
                return capability;
            }
        }
        return null;
    }

    public boolean isAttachedToVirtualPlatform() {
        for (EdgeState incomingEdge : this.incomingEdges) {
            if (!(incomingEdge.getDependencyMetadata() instanceof LenientPlatformDependencyMetadata)) continue;
            return true;
        }
        return false;
    }

    boolean hasShadowedCapability() {
        for (Capability capability : this.metadata.getCapabilities().asSet()) {
            if (!(capability instanceof ShadowedCapability)) continue;
            return true;
        }
        return false;
    }

    boolean isSelectedByVariantAwareResolution() {
        return this.selectedByVariantAwareResolution && this.isSelected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ResolvedGraphVariant getExternalVariant() {
        if (this.canIgnoreExternalVariant()) {
            return null;
        }
        if (this.findingExternalVariants) {
            LOGGER.warn("Detecting cycle in external variants for :\n" + this.computePathToRoot());
            this.findingExternalVariants = false;
            return null;
        }
        this.findingExternalVariants = true;
        assert (this.outgoingEdges.size() <= 1);
        try {
            Iterator<EdgeState> iterator = this.outgoingEdges.iterator();
            if (iterator.hasNext()) {
                EdgeState outgoingEdge = iterator.next();
                NodeState nodeState = outgoingEdge.getSelectedNode();
                return nodeState;
            }
            iterator = null;
            return iterator;
        }
        finally {
            this.findingExternalVariants = false;
        }
    }

    private String computePathToRoot() {
        TreeFormatter formatter = new TreeFormatter();
        formatter.node(this.getDisplayName());
        NodeState from = this;
        int depth = 0;
        do {
            if ((from = this.getFromNode(from)) == null) continue;
            formatter.startChildren();
            formatter.node(this.getDisplayName());
            ++depth;
        } while (from != null && !(from instanceof RootNode));
        for (int i = 0; i < depth; ++i) {
            formatter.endChildren();
        }
        formatter.node("Dependency resolution has ignored the cycle to produce a result. It is recommended to resolve the cycle by upgrading one or more dependencies.");
        return formatter.toString();
    }

    @Nullable
    private NodeState getFromNode(NodeState from) {
        Collection incomingEdges = from.getIncomingEdges();
        if (incomingEdges.isEmpty()) {
            return null;
        }
        return ((EdgeState)incomingEdges.get(0)).getFrom();
    }

    public Set<NodeState> getReachableNodes() {
        HashSet<NodeState> visited = new HashSet<NodeState>();
        this.dependsTransitivelyOn(visited);
        return visited;
    }

    private void dependsTransitivelyOn(Set<NodeState> visited) {
        for (EdgeState outgoingEdge : this.getOutgoingEdges()) {
            if (outgoingEdge.getTargetComponent() == null) continue;
            for (NodeState nodeState : outgoingEdge.getTargetComponent().getNodes()) {
                if (!visited.add(nodeState)) continue;
                nodeState.dependsTransitivelyOn(visited);
            }
        }
    }

    private static class NonTransitiveVariantDependencyMetadata
    extends DelegatingDependencyMetadata {
        private final DependencyMetadata dependencyMetadata;

        public NonTransitiveVariantDependencyMetadata(DependencyMetadata dependencyMetadata) {
            super(dependencyMetadata);
            this.dependencyMetadata = dependencyMetadata;
        }

        @Override
        public DependencyMetadata withTarget(ComponentSelector target) {
            return NodeState.makeNonTransitive(this.dependencyMetadata.withTarget(target));
        }

        @Override
        public DependencyMetadata withTargetAndArtifacts(ComponentSelector target, List<IvyArtifactName> artifacts) {
            return NodeState.makeNonTransitive(this.dependencyMetadata.withTargetAndArtifacts(target, artifacts));
        }

        @Override
        public boolean isTransitive() {
            return false;
        }

        @Override
        public DependencyMetadata withReason(String reason) {
            return NodeState.makeNonTransitive(this.dependencyMetadata.withReason(reason));
        }

        public String toString() {
            return "Non transitive dependency for external variant " + this.dependencyMetadata;
        }
    }
}

