/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.EdgeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.NodeState;

abstract class MessageBuilderHelper {
    MessageBuilderHelper() {
    }

    public static List<String> formattedPathsTo(EdgeState edge) {
        return MessageBuilderHelper.findPathsTo(edge).stream().map(path -> {
            String header = ((EdgeState)Iterables.getLast((Iterable)path)).getSelector().getDependencyMetadata().isConstraint() ? "Constraint" : "Dependency";
            String formattedPath = path.stream().map(EdgeState::getFrom).map(NodeState::getDisplayName).collect(Collectors.joining(" --> "));
            return header + " path: " + formattedPath;
        }).collect(Collectors.toList());
    }

    private static List<List<EdgeState>> findPathsTo(EdgeState edge) {
        ArrayList<List<EdgeState>> acc = new ArrayList<List<EdgeState>>(1);
        MessageBuilderHelper.pathTo(edge, new ArrayList<EdgeState>(), acc, new HashSet<NodeState>());
        return acc;
    }

    private static void pathTo(EdgeState edge, List<EdgeState> currentPath, List<List<EdgeState>> accumulator, Set<NodeState> alreadySeen) {
        NodeState from = edge.getFrom();
        if (alreadySeen.add(from)) {
            currentPath.add(edge);
            Collection incomingEdges = from.getIncomingEdges();
            if (!incomingEdges.isEmpty()) {
                for (EdgeState dependent : incomingEdges) {
                    ArrayList<EdgeState> otherPath = new ArrayList<EdgeState>(currentPath);
                    MessageBuilderHelper.pathTo(dependent, otherPath, accumulator, alreadySeen);
                }
            } else {
                accumulator.add(Lists.reverse(currentPath));
            }
        }
    }
}

