/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExclusions;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ExcludeSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphEdge;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ComponentState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.DependencyState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.LenientPlatformDependencyMetadata;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ModuleResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ModuleSelectors;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.NodeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.SelectorState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.strict.StrictVersionConstraints;
import org.gradle.api.internal.attributes.AttributeMergingException;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Factory;
import org.gradle.internal.component.local.model.DslOriginDependencyMetadata;
import org.gradle.internal.component.model.ComponentGraphResolveState;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.GraphVariantSelectionResult;
import org.gradle.internal.component.model.VariantGraphResolveState;
import org.gradle.internal.resolve.ModuleVersionResolveException;

class EdgeState
implements DependencyGraphEdge {
    private final DependencyState dependencyState;
    private final DependencyMetadata dependencyMetadata;
    private final NodeState from;
    private final ResolveState resolveState;
    private final List<NodeState> targetNodes = new LinkedList<NodeState>();
    private final boolean isTransitive;
    private final boolean isConstraint;
    @Nullable
    private SelectorState selector;
    private ModuleVersionResolveException targetNodeSelectionFailure;
    private ImmutableAttributes cachedAttributes;
    @Nullable
    private ExcludeSpec transitiveExclusions;
    private ExcludeSpec cachedEdgeExclusions;
    private ExcludeSpec cachedExclusions;
    @Nullable
    private NodeState resolvedVariant;
    private boolean unattached;

    EdgeState(NodeState from, DependencyState dependencyState, ResolveState resolveState) {
        this.from = from;
        this.dependencyState = dependencyState;
        this.dependencyMetadata = dependencyState.getDependency();
        this.resolveState = resolveState;
        this.isTransitive = from.isTransitive() && this.dependencyMetadata.isTransitive();
        this.isConstraint = this.dependencyMetadata.isConstraint();
    }

    boolean computeSelector(StrictVersionConstraints ancestorsStrictVersions, boolean deferSelection) {
        boolean ignoreVersion = !this.dependencyState.isForced() && ancestorsStrictVersions.contains(this.dependencyState.getModuleIdentifier(this.resolveState.getComponentSelectorConverter()));
        SelectorState newSelector = this.resolveState.computeSelectorFor(this.dependencyState, ignoreVersion);
        if (this.selector != newSelector) {
            this.clearSelector();
            newSelector.use(deferSelection);
            this.selector = newSelector;
            return true;
        }
        return false;
    }

    public void clearSelector() {
        if (this.selector != null) {
            this.selector.release();
            this.selector = null;
        }
    }

    public String toString() {
        return String.format("%s -> %s", this.from.toString(), this.dependencyMetadata);
    }

    @Override
    public NodeState getFrom() {
        return this.from;
    }

    @Override
    public DependencyMetadata getDependencyMetadata() {
        return this.dependencyMetadata;
    }

    @Nullable
    ComponentState getTargetComponent() {
        if (this.selector == null || !this.selector.isResolved() || this.selector.getFailure() != null) {
            return null;
        }
        return this.getSelectedComponent();
    }

    @Override
    public SelectorState getSelector() {
        assert (this.selector != null) : "No selector for " + this;
        return this.selector;
    }

    @Override
    public boolean isTransitive() {
        return this.isTransitive;
    }

    void attachToTargetNodes() {
        ComponentState targetComponent = this.getTargetComponent();
        if (targetComponent == null || !this.isUsed()) {
            return;
        }
        assert (!targetComponent.getModule().isPending());
        this.calculateTargetNodes(targetComponent);
        for (NodeState targetNode : this.targetNodes) {
            targetNode.addIncomingEdge(this);
        }
        if (!this.targetNodes.isEmpty()) {
            this.selector.getTargetModule().removeUnattachedEdge(this);
        }
    }

    void detachFromTargetNodes() {
        if (!this.targetNodes.isEmpty()) {
            for (NodeState targetNode : this.targetNodes) {
                targetNode.removeIncomingEdge(this);
            }
            this.targetNodes.clear();
        }
        this.targetNodeSelectionFailure = null;
    }

    void failWith(Throwable err) {
        this.targetNodeSelectionFailure = new ModuleVersionResolveException(this.selector.getSelector(), err);
    }

    public void retarget() {
        this.detachFromTargetNodes();
        if (this.isUsed()) {
            this.attachToTargetNodes();
            if (this.targetNodes.isEmpty()) {
                this.selector.getTargetModule().addUnattachedEdge(this);
            }
        }
    }

    @Override
    public ImmutableAttributes getAttributes() {
        assert (this.cachedAttributes != null);
        return this.cachedAttributes;
    }

    private ImmutableAttributes safeGetAttributes() throws AttributeMergingException {
        ModuleResolveState module = this.selector.getTargetModule();
        this.cachedAttributes = module.mergedConstraintsAttributes(this.dependencyState.getDependency().getSelector().getAttributes());
        return this.cachedAttributes;
    }

    private void calculateTargetNodes(ComponentState targetComponent) {
        GraphVariantSelectionResult targetVariants;
        ComponentGraphResolveState targetComponentState = targetComponent.getResolveStateOrNull();
        this.targetNodes.clear();
        this.targetNodeSelectionFailure = null;
        if (targetComponentState == null) {
            targetComponent.getModule().getPlatformState().addOrphanEdge(this);
            return;
        }
        if (this.isConstraint && !this.isVirtualDependency()) {
            List<NodeState> nodes = targetComponent.getNodes();
            for (NodeState nodeState : nodes) {
                if (!nodeState.isSelected() || nodeState.isRoot()) continue;
                this.targetNodes.add(nodeState);
            }
            if (this.targetNodes.isEmpty()) {
                List<EdgeState> unattachedEdges = targetComponent.getModule().getUnattachedEdges();
                if (!unattachedEdges.isEmpty()) {
                    for (EdgeState otherEdge : unattachedEdges) {
                        if (otherEdge.isConstraint()) continue;
                        otherEdge.attachToTargetNodes();
                        if (otherEdge.targetNodeSelectionFailure == null) break;
                        this.targetNodeSelectionFailure = otherEdge.targetNodeSelectionFailure;
                        return;
                    }
                }
                for (NodeState node : nodes) {
                    if (!node.isSelected() || node.isRoot()) continue;
                    this.targetNodes.add(node);
                }
            }
            return;
        }
        try {
            ImmutableAttributes attributes = this.resolveState.getRoot().getMetadata().getAttributes();
            attributes = this.resolveState.getAttributesFactory().concat(attributes, this.safeGetAttributes());
            targetVariants = this.dependencyMetadata.selectVariants(this.resolveState.getVariantSelector(), attributes, targetComponentState, this.resolveState.getConsumerSchema(), this.dependencyState.getDependency().getSelector().getCapabilitySelectors());
        }
        catch (AttributeMergingException mergeError) {
            this.targetNodeSelectionFailure = new ModuleVersionResolveException(this.dependencyState.getRequested(), (Factory<String>)((Factory)() -> {
                Attribute attribute = mergeError.getAttribute();
                Object constraintValue = mergeError.getLeftValue();
                Object dependencyValue = mergeError.getRightValue();
                return "Inconsistency between attributes of a constraint and a dependency, on attribute '" + attribute + "' : dependency requires '" + dependencyValue + "' while constraint required '" + constraintValue + "'";
            }));
            return;
        }
        catch (Exception t) {
            this.targetNodeSelectionFailure = new ModuleVersionResolveException(this.dependencyState.getRequested(), (Throwable)t);
            return;
        }
        for (VariantGraphResolveState variantGraphResolveState : targetVariants.getVariants()) {
            NodeState targetNodeState = this.resolveState.getNode(targetComponent, variantGraphResolveState, targetVariants.isSelectedByVariantAwareResolution());
            this.targetNodes.add(targetNodeState);
        }
    }

    private boolean isVirtualDependency() {
        return this.selector.getDependencyMetadata() instanceof LenientPlatformDependencyMetadata;
    }

    @Override
    public ExcludeSpec getExclusions() {
        if (this.cachedExclusions == null) {
            this.computeExclusions();
        }
        return this.cachedExclusions;
    }

    private void computeExclusions() {
        List<ExcludeMetadata> excludes = this.dependencyMetadata.getExcludes();
        if (excludes.isEmpty()) {
            this.cachedExclusions = this.transitiveExclusions;
        } else {
            this.computeExclusionsWhenExcludesPresent(excludes);
        }
    }

    private void computeExclusionsWhenExcludesPresent(List<ExcludeMetadata> excludes) {
        ModuleExclusions moduleExclusions = this.resolveState.getModuleExclusions();
        ExcludeSpec edgeExclusions = moduleExclusions.excludeAny(excludes);
        this.cachedExclusions = moduleExclusions.excludeAny(edgeExclusions, this.transitiveExclusions);
    }

    ExcludeSpec getEdgeExclusions() {
        if (this.cachedEdgeExclusions == null) {
            List<ExcludeMetadata> excludes = this.dependencyMetadata.getExcludes();
            ModuleExclusions moduleExclusions = this.resolveState.getModuleExclusions();
            if (excludes.isEmpty()) {
                return moduleExclusions.nothing();
            }
            this.cachedEdgeExclusions = moduleExclusions.excludeAny(excludes);
        }
        return this.cachedEdgeExclusions;
    }

    @Override
    public boolean contributesArtifacts() {
        return !this.isConstraint;
    }

    @Override
    public ComponentSelector getRequested() {
        return this.resolveState.desugarSelector(this.dependencyState.getRequested());
    }

    @Override
    public ModuleVersionResolveException getFailure() {
        if (this.targetNodeSelectionFailure != null) {
            return this.targetNodeSelectionFailure;
        }
        ModuleVersionResolveException selectorFailure = this.selector.getFailure();
        if (selectorFailure != null) {
            return selectorFailure;
        }
        ComponentState selectedComponent = this.getSelectedComponent();
        if (selectedComponent == null) {
            ModuleSelectors<SelectorState> selectors = this.selector.getTargetModule().getSelectors();
            for (SelectorState state : selectors) {
                selectorFailure = state.getFailure();
                if (selectorFailure == null) continue;
                return selectorFailure;
            }
            throw new IllegalStateException("Expected to find a selector with a failure but none was found");
        }
        return selectedComponent.getMetadataResolveFailure();
    }

    @Override
    public Long getSelected() {
        return this.getSelectedComponent().getResultId();
    }

    @Override
    public boolean isTargetVirtualPlatform() {
        ComponentState selectedComponent = this.getSelectedComponent();
        return selectedComponent != null && selectedComponent.getModule().isVirtualPlatform();
    }

    @Override
    @Nullable
    public Long getSelectedVariant() {
        NodeState node = this.getSelectedNode();
        if (node == null) {
            return null;
        }
        assert (node.getComponent() == this.getSelectedComponent());
        return node.getNodeId();
    }

    public Collection<NodeState> getTargetNodes() {
        return this.targetNodes;
    }

    @Nullable
    public NodeState getSelectedNode() {
        ComponentState targetComponent;
        if (this.resolvedVariant != null) {
            return this.resolvedVariant;
        }
        List<NodeState> targetNodes = this.targetNodes;
        if (targetNodes.isEmpty() && (targetComponent = this.getTargetComponent()) != null) {
            targetNodes = targetComponent.getNodes();
        }
        assert (!targetNodes.isEmpty());
        for (NodeState targetNode : targetNodes) {
            if (!targetNode.isSelected()) continue;
            this.resolvedVariant = targetNode;
            return this.resolvedVariant;
        }
        return null;
    }

    @Override
    public ComponentSelectionReason getReason() {
        return this.selector.getSelectionReason();
    }

    @Override
    public boolean isConstraint() {
        return this.isConstraint;
    }

    @Override
    public long getFromVariant() {
        return this.from.getNodeId();
    }

    @Nullable
    private ComponentState getSelectedComponent() {
        return this.selector.getTargetModule().getSelected();
    }

    @Override
    public Dependency getOriginalDependency() {
        if (this.dependencyMetadata instanceof DslOriginDependencyMetadata) {
            return ((DslOriginDependencyMetadata)this.dependencyMetadata).getSource();
        }
        return null;
    }

    DependencyState getDependencyState() {
        return this.dependencyState;
    }

    public void updateTransitiveExcludes(ExcludeSpec newResolutionFilter) {
        if (this.isConstraint) {
            return;
        }
        this.transitiveExclusions = newResolutionFilter;
        this.cachedExclusions = null;
    }

    public void updateTransitiveExcludesAndRequeueTargetNodes(ExcludeSpec newResolutionFilter) {
        this.updateTransitiveExcludes(newResolutionFilter);
        for (NodeState targetNode : this.targetNodes) {
            targetNode.clearTransitiveExclusionsAndEnqueue();
        }
    }

    void recomputeSelectorAndRequeueTargetNodes(StrictVersionConstraints ancestorsStrictVersions, Collection<EdgeState> discoveredEdges) {
        if (this.computeSelector(ancestorsStrictVersions, false)) {
            discoveredEdges.add(this);
        }
        for (NodeState targetNode : this.targetNodes) {
            this.resolveState.onMoreSelected(targetNode);
        }
    }

    @Nullable
    ExcludeSpec getTransitiveExclusions() {
        return this.transitiveExclusions;
    }

    public void markUnattached() {
        this.unattached = true;
    }

    public void markNotUnattached() {
        this.unattached = false;
    }

    public boolean isUnattached() {
        return this.unattached;
    }

    boolean isUsed() {
        return this.selector != null;
    }

    public boolean isArtifactOnlyEdge() {
        return !this.isTransitive && !this.dependencyMetadata.getArtifacts().isEmpty();
    }
}

