/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.artifacts.CapabilityResolutionDetails;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.dsl.CapabilityNotationParser;
import org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy.CapabilitiesResolutionInternal;
import org.gradle.api.provider.Provider;
import org.gradle.internal.component.external.model.DefaultImmutableCapability;

public class DefaultCapabilitiesResolution
implements CapabilitiesResolutionInternal {
    private final CapabilityNotationParser capabilityNotationParser;
    @Nullable
    private List<RegisteredAction> actions;

    public DefaultCapabilitiesResolution(CapabilityNotationParser capabilityNotationParser) {
        this.capabilityNotationParser = capabilityNotationParser;
    }

    public void all(Action<? super CapabilityResolutionDetails> action) {
        this.doAddAction(null, action);
    }

    public void withCapability(Capability capability, Action<? super CapabilityResolutionDetails> action) {
        this.doAddAction(() -> capability, action);
    }

    public void withCapability(String group, String name, Action<? super CapabilityResolutionDetails> action) {
        this.doAddAction(() -> new DefaultImmutableCapability(group, name, null), action);
    }

    public void withCapability(Object notation, Action<? super CapabilityResolutionDetails> action) {
        Supplier<Capability> capabilitySupplier = notation instanceof Provider ? () -> (Capability)((Provider)notation).map(arg_0 -> ((CapabilityNotationParser)this.capabilityNotationParser).parseNotation(arg_0)).get() : () -> (Capability)this.capabilityNotationParser.parseNotation(notation);
        this.doAddAction(capabilitySupplier, action);
    }

    void doAddAction(@Nullable Supplier<Capability> notation, Action<? super CapabilityResolutionDetails> action) {
        if (this.actions == null) {
            this.actions = new ArrayList<RegisteredAction>();
        }
        this.actions.add(new RegisteredAction(notation, action));
    }

    @Override
    public ImmutableList<CapabilitiesResolutionInternal.CapabilityResolutionRule> getRules() {
        if (this.actions == null || this.actions.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)this.actions.size());
        for (RegisteredAction registeredAction : this.actions) {
            builder.add((Object)registeredAction.asCapabilityResolutionAction());
        }
        return builder.build();
    }

    private static class RegisteredAction {
        @Nullable
        private final Supplier<Capability> notation;
        private final Action<? super CapabilityResolutionDetails> action;

        RegisteredAction(@Nullable Supplier<Capability> notation, Action<? super CapabilityResolutionDetails> action) {
            this.notation = notation;
            this.action = action;
        }

        public CapabilitiesResolutionInternal.CapabilityResolutionRule asCapabilityResolutionAction() {
            if (this.notation == null) {
                return new CapabilitiesResolutionInternal.CapabilityResolutionRule(null, this.action);
            }
            return new CapabilitiesResolutionInternal.CapabilityResolutionRule(DefaultImmutableCapability.of(this.notation.get()), this.action);
        }
    }
}

