/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.ArtifactSelectionDetails;
import org.gradle.api.artifacts.DependencyArtifactSelector;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.result.ComponentSelectionCause;
import org.gradle.api.artifacts.result.ComponentSelectionDescriptor;
import org.gradle.api.internal.artifacts.DependencySubstitutionInternal;
import org.gradle.api.internal.artifacts.dsl.ComponentSelectorParsers;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.ArtifactSelectionDetailsInternal;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DefaultArtifactSelectionDetails;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.UnversionedModuleComponentSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasons;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.typeconversion.NotationParser;

public class DefaultDependencySubstitution
implements DependencySubstitutionInternal {
    private static final NotationParser<Object, ComponentSelector> COMPONENT_SELECTOR_PARSER = ComponentSelectorParsers.parser();
    private final ComponentSelectionDescriptorFactory componentSelectionDescriptorFactory;
    private final ComponentSelector requestedSelector;
    private final ImmutableList<IvyArtifactName> requestedArtifacts;
    @Nullable
    private ComponentSelector target;
    @Nullable
    private List<ComponentSelectionDescriptorInternal> ruleDescriptors;
    @Nullable
    private ArtifactSelectionDetailsInternal artifactSelectionDetails;

    @Inject
    public DefaultDependencySubstitution(ComponentSelectionDescriptorFactory componentSelectionDescriptorFactory, ComponentSelector requestedSelector, ImmutableList<IvyArtifactName> requestedArtifacts) {
        this.componentSelectionDescriptorFactory = componentSelectionDescriptorFactory;
        this.requestedSelector = requestedSelector;
        this.requestedArtifacts = requestedArtifacts;
    }

    public ComponentSelector getRequested() {
        return this.requestedSelector;
    }

    public void useTarget(Object notation) {
        this.useTarget(notation, ComponentSelectionReasons.SELECTED_BY_RULE);
    }

    public void useTarget(Object notation, String reason) {
        this.useTarget(notation, this.componentSelectionDescriptorFactory.newDescriptor(ComponentSelectionCause.SELECTED_BY_RULE, reason));
    }

    public void artifactSelection(Action<? super ArtifactSelectionDetails> action) {
        if (this.artifactSelectionDetails == null) {
            this.artifactSelectionDetails = new DefaultArtifactSelectionDetails(this.requestedArtifacts);
        }
        action.execute((Object)this.artifactSelectionDetails);
    }

    @Override
    public void useTarget(Object notation, ComponentSelectionDescriptor ruleDescriptor) {
        this.target = (ComponentSelector)COMPONENT_SELECTOR_PARSER.parseNotation(notation);
        if (this.ruleDescriptors == null) {
            this.ruleDescriptors = new ArrayList<ComponentSelectionDescriptorInternal>();
        }
        this.ruleDescriptors.add((ComponentSelectionDescriptorInternal)ruleDescriptor);
        DefaultDependencySubstitution.validateTarget(this.target);
    }

    @Override
    @Nullable
    public ImmutableList<ComponentSelectionDescriptorInternal> getRuleDescriptors() {
        boolean hasConfiguredArtifactSelectors;
        boolean hasConfiguredTarget = this.getConfiguredTargetSelector() != null;
        boolean bl = hasConfiguredArtifactSelectors = this.getConfiguredArtifactSelectors() != null;
        if (!hasConfiguredTarget && !hasConfiguredArtifactSelectors) {
            return null;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        if (hasConfiguredTarget) {
            assert (this.ruleDescriptors != null);
            builder.addAll(this.ruleDescriptors);
        }
        if (hasConfiguredArtifactSelectors) {
            builder.add((Object)ComponentSelectionReasons.SELECTED_BY_RULE);
        }
        return builder.build();
    }

    @Override
    @Nullable
    public ComponentSelector getConfiguredTargetSelector() {
        return this.target;
    }

    @Override
    @Nullable
    public ImmutableList<DependencyArtifactSelector> getConfiguredArtifactSelectors() {
        return this.artifactSelectionDetails != null ? this.artifactSelectionDetails.getConfiguredSelectors() : null;
    }

    public static void validateTarget(ComponentSelector componentSelector) {
        if (componentSelector instanceof UnversionedModuleComponentSelector) {
            throw new InvalidUserDataException("Must specify version for target of dependency substitution");
        }
    }
}

