/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.buildinit.plugins.internal.AbstractBuildGenerator;
import org.gradle.buildinit.plugins.internal.BasicProjectGenerator;
import org.gradle.buildinit.plugins.internal.BuildContentGenerator;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilderFactory;
import org.gradle.buildinit.plugins.internal.InitSettings;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitDsl;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitTestFramework;
import org.gradle.buildinit.plugins.internal.modifiers.ComponentType;
import org.gradle.buildinit.plugins.internal.modifiers.Language;
import org.gradle.buildinit.plugins.internal.modifiers.ModularizationOption;

public class BasicBuildGenerator
extends AbstractBuildGenerator {
    private final DocumentationRegistry documentationRegistry;

    public BasicBuildGenerator(BuildScriptBuilderFactory scriptBuilderFactory, DocumentationRegistry documentationRegistry, List<? extends BuildContentGenerator> generators) {
        super(new BasicProjectGenerator(scriptBuilderFactory, documentationRegistry), generators);
        this.documentationRegistry = documentationRegistry;
    }

    @Override
    public String getId() {
        return "basic";
    }

    @Override
    public ComponentType getComponentType() {
        return ComponentType.BASIC;
    }

    @Override
    public boolean productionCodeUses(Language language) {
        return false;
    }

    @Override
    public List<String> getDefaultProjectNames() {
        return this.getComponentType().getDefaultProjectNames();
    }

    @Override
    public boolean supportsJavaTargets() {
        return false;
    }

    @Override
    public Set<ModularizationOption> getModularizationOptions() {
        return Collections.singleton(ModularizationOption.SINGLE_PROJECT);
    }

    @Override
    public boolean supportsPackage() {
        return false;
    }

    @Override
    public BuildInitDsl getDefaultDsl() {
        return BuildInitDsl.KOTLIN;
    }

    @Override
    public BuildInitTestFramework getDefaultTestFramework(ModularizationOption modularizationOption) {
        return BuildInitTestFramework.NONE;
    }

    @Override
    public Set<BuildInitTestFramework> getTestFrameworks(ModularizationOption modularizationOption) {
        return Collections.singleton(BuildInitTestFramework.NONE);
    }

    @Override
    public Optional<String> getFurtherReading(InitSettings settings) {
        return Optional.of(this.documentationRegistry.getSampleForMessage());
    }
}

