/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.clientmodule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.NonNullApi;
import org.gradle.api.artifacts.ClientModule;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.DependencyMetadataFactory;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.immutable.ImmutableAttributesSchema;
import org.gradle.internal.component.external.model.DefaultConfigurationMetadata;
import org.gradle.internal.component.external.model.ExternalComponentGraphResolveMetadata;
import org.gradle.internal.component.external.model.ExternalComponentResolveMetadata;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleComponentGraphResolveStateFactory;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.external.model.ModuleDependencyMetadataWrapper;
import org.gradle.internal.component.external.model.VariantMetadataRules;
import org.gradle.internal.component.external.model.VirtualComponentIdentifier;
import org.gradle.internal.component.local.model.DslOriginDependencyMetadata;
import org.gradle.internal.component.model.ComponentOverrideMetadata;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.LocalOriginDependencyMetadata;
import org.gradle.internal.component.model.ModuleConfigurationMetadata;
import org.gradle.internal.component.model.ModuleSources;
import org.gradle.internal.component.model.VariantGraphResolveMetadata;
import org.gradle.internal.resolve.resolver.ComponentMetaDataResolver;
import org.gradle.internal.resolve.result.BuildableComponentResolveResult;

@NonNullApi
public class ClientModuleResolver
implements ComponentMetaDataResolver {
    private final ComponentMetaDataResolver resolver;
    private final DependencyMetadataFactory dependencyMetadataFactory;
    private final ModuleComponentGraphResolveStateFactory resolveStateFactory;

    public ClientModuleResolver(ComponentMetaDataResolver resolver, DependencyMetadataFactory dependencyMetadataFactory, ModuleComponentGraphResolveStateFactory resolveStateFactory) {
        this.resolver = resolver;
        this.dependencyMetadataFactory = dependencyMetadataFactory;
        this.resolveStateFactory = resolveStateFactory;
    }

    @Override
    public void resolve(ComponentIdentifier identifier, ComponentOverrideMetadata componentOverrideMetadata, BuildableComponentResolveResult result) {
        this.resolver.resolve(identifier, componentOverrideMetadata, result);
        if (result.getFailure() != null) {
            return;
        }
        ClientModule clientModule = componentOverrideMetadata.getClientModule();
        if (clientModule != null) {
            ModuleComponentResolveMetadata originalMetadata = (ModuleComponentResolveMetadata)result.getState().getMetadata();
            List<ModuleDependencyMetadata> clientModuleDependencies = this.createClientModuleDependencies(clientModule);
            ModuleComponentArtifactMetadata clientModuleArtifact = this.createClientModuleArtifact(originalMetadata);
            ClientModuleComponentResolveMetadata clientModuleMetaData = new ClientModuleComponentResolveMetadata(originalMetadata, clientModuleArtifact, clientModuleDependencies);
            result.setResult(this.resolveStateFactory.stateFor(clientModuleMetaData, clientModuleMetaData));
        }
    }

    @Override
    public boolean isFetchingMetadataCheap(ComponentIdentifier identifier) {
        return this.resolver.isFetchingMetadataCheap(identifier);
    }

    private List<ModuleDependencyMetadata> createClientModuleDependencies(ClientModule clientModule) {
        ArrayList<ModuleDependencyMetadata> dependencies = new ArrayList<ModuleDependencyMetadata>();
        for (ModuleDependency moduleDependency : clientModule.getDependencies()) {
            ModuleDependencyMetadata dependencyMetadata = this.createDependencyMetadata(moduleDependency);
            dependencies.add(dependencyMetadata);
        }
        return dependencies;
    }

    private ModuleComponentArtifactMetadata createClientModuleArtifact(ModuleComponentResolveMetadata metadata) {
        return metadata.artifact("jar", "jar", null);
    }

    private ModuleDependencyMetadata createDependencyMetadata(ModuleDependency moduleDependency) {
        LocalOriginDependencyMetadata dependencyMetadata = this.dependencyMetadataFactory.createDependencyMetadata(moduleDependency);
        if (dependencyMetadata instanceof DslOriginDependencyMetadata) {
            return new ClientModuleDependencyMetadataWrapper((DslOriginDependencyMetadata)((Object)dependencyMetadata));
        }
        return new ModuleDependencyMetadataWrapper(dependencyMetadata);
    }

    private static class ClientModuleDependencyMetadataWrapper
    extends ModuleDependencyMetadataWrapper
    implements DslOriginDependencyMetadata {
        private final DslOriginDependencyMetadata delegate;

        private ClientModuleDependencyMetadataWrapper(DslOriginDependencyMetadata delegate) {
            super(delegate);
            this.delegate = delegate;
        }

        @Override
        public Dependency getSource() {
            return this.delegate.getSource();
        }
    }

    private static class ClientModuleConfigurationMetadata
    extends DefaultConfigurationMetadata {
        ClientModuleConfigurationMetadata(ModuleComponentIdentifier componentId, String name, ModuleComponentArtifactMetadata artifact, List<ModuleDependencyMetadata> dependencies) {
            super(componentId, name, true, true, (ImmutableSet<String>)ImmutableSet.of(), (ImmutableList<? extends ModuleComponentArtifactMetadata>)ImmutableList.of((Object)artifact), VariantMetadataRules.noOp(), (ImmutableList<ExcludeMetadata>)ImmutableList.of(), ImmutableAttributes.EMPTY, false);
            this.setDependencies(dependencies);
        }
    }

    private static class ClientModuleComponentResolveMetadata
    implements ExternalComponentResolveMetadata,
    ExternalComponentGraphResolveMetadata {
        private final ModuleComponentResolveMetadata delegate;
        private final ModuleComponentArtifactMetadata clientModuleArtifact;
        private final List<ModuleDependencyMetadata> clientModuleDependencies;

        private ClientModuleComponentResolveMetadata(ModuleComponentResolveMetadata delegate, ModuleComponentArtifactMetadata clientModuleArtifact, List<ModuleDependencyMetadata> clientModuleDependencies) {
            this.delegate = delegate;
            this.clientModuleArtifact = clientModuleArtifact;
            this.clientModuleDependencies = clientModuleDependencies;
        }

        public ModuleComponentIdentifier getId() {
            return this.delegate.getId();
        }

        @Override
        public ModuleVersionIdentifier getModuleVersionId() {
            return this.delegate.getModuleVersionId();
        }

        @Override
        public ModuleSources getSources() {
            return this.delegate.getSources();
        }

        @Override
        public ImmutableAttributesSchema getAttributesSchema() {
            return this.delegate.getAttributesSchema();
        }

        @Override
        public Set<String> getConfigurationNames() {
            return this.delegate.getConfigurationNames();
        }

        @Override
        @Nullable
        public ModuleConfigurationMetadata getConfiguration(String name) {
            return new ClientModuleConfigurationMetadata(this.delegate.getId(), name, this.clientModuleArtifact, this.clientModuleDependencies);
        }

        @Override
        public List<? extends VariantGraphResolveMetadata> getVariantsForGraphTraversal() {
            return Collections.emptyList();
        }

        @Override
        public boolean isMissing() {
            return this.delegate.isMissing();
        }

        @Override
        public boolean isChanging() {
            return this.delegate.isChanging();
        }

        @Override
        public String getStatus() {
            return this.delegate.getStatus();
        }

        @Override
        public List<String> getStatusScheme() {
            return this.delegate.getStatusScheme();
        }

        @Override
        public ImmutableList<? extends VirtualComponentIdentifier> getPlatformOwners() {
            return ImmutableList.of();
        }

        @Override
        public ImmutableAttributes getAttributes() {
            return this.delegate.getAttributes();
        }
    }
}

