/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.collections;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import org.gradle.api.Action;
import org.gradle.api.internal.DefaultMutationGuard;
import org.gradle.api.internal.MutationGuard;
import org.gradle.api.internal.collections.ElementSource;
import org.gradle.api.internal.collections.EventSubscriptionVerifier;
import org.gradle.api.internal.provider.ChangingValue;
import org.gradle.api.internal.provider.CollectionProviderInternal;
import org.gradle.api.internal.provider.Collector;
import org.gradle.api.internal.provider.Collectors;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.internal.Cast;

public class SortedSetElementSource<T>
implements ElementSource<T> {
    private final TreeSet<T> values;
    private Set<Collectors.TypedCollector<T>> pending = Collections.emptySet();
    private Action<T> addRealizedAction;
    private EventSubscriptionVerifier<T> subscriptionVerifier = type -> false;
    private final MutationGuard mutationGuard = new DefaultMutationGuard();

    public SortedSetElementSource(Comparator<T> comparator) {
        this.values = new TreeSet<T>(comparator);
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty() && this.pending.isEmpty();
    }

    @Override
    public boolean constantTimeIsEmpty() {
        return this.values.isEmpty() && this.pending.isEmpty();
    }

    @Override
    public int size() {
        int pendingSize = 0;
        for (Collectors.TypedCollector<T> collector : this.pending) {
            pendingSize += collector.size();
        }
        return this.values.size() + pendingSize;
    }

    @Override
    public int estimatedSize() {
        return this.size();
    }

    @Override
    public Iterator<T> iterator() {
        this.realizePending();
        return this.values.iterator();
    }

    @Override
    public Iterator<T> iteratorNoFlush() {
        return this.values.iterator();
    }

    @Override
    public boolean contains(Object element) {
        this.realizePending();
        return this.values.contains(element);
    }

    @Override
    public boolean containsAll(Collection<?> elements) {
        this.realizePending();
        return this.values.containsAll(elements);
    }

    @Override
    public boolean add(T element) {
        return this.values.add(element);
    }

    @Override
    public boolean remove(Object o) {
        return this.values.remove(o);
    }

    @Override
    public void clear() {
        this.pending = Collections.emptySet();
        this.values.clear();
    }

    @Override
    public void realizePending() {
        if (!this.pending.isEmpty()) {
            ArrayList copied = Lists.newArrayList(this.pending);
            this.realize(copied);
        }
    }

    @Override
    public void realizePending(Class<?> type) {
        if (!this.pending.isEmpty()) {
            ArrayList<Collectors.TypedCollector<T>> copied = new ArrayList<Collectors.TypedCollector<T>>();
            for (Collectors.TypedCollector<T> collector : this.pending) {
                if (collector.getType() != null && !type.isAssignableFrom(collector.getType())) continue;
                copied.add(collector);
            }
            this.realize(copied);
        }
    }

    private void realize(Iterable<Collectors.TypedCollector<T>> collectors) {
        for (Collectors.TypedCollector<T> collector : collectors) {
            this.pending.remove(collector);
            ImmutableList.Builder builder = ImmutableList.builder();
            collector.collectInto((ImmutableCollection.Builder)builder);
            ImmutableList realized = builder.build();
            for (Object element : realized) {
                this.doAddRealized(element);
            }
        }
    }

    private void doAddRealized(T value) {
        if (this.values.add(value) && this.addRealizedAction != null) {
            this.addRealizedAction.execute(value);
        }
    }

    @Override
    public boolean addPending(ProviderInternal<? extends T> provider) {
        this.ensurePendingIsMutable();
        if (provider instanceof ChangingValue) {
            ((ChangingValue)Cast.uncheckedNonnullCast(provider)).onValueChange(previousValue -> {
                this.values.remove(previousValue);
                this.pending.add(this.collectorFromProvider(provider));
            });
        }
        Collectors.TypedCollector<? extends T> collector = this.collectorFromProvider(provider);
        boolean added = this.pending.add(collector);
        if (this.subscriptionVerifier.isSubscribed(provider.getType())) {
            this.realize(Collections.singleton(collector));
            this.pending.add(collector);
        }
        return added;
    }

    private void ensurePendingIsMutable() {
        if (this.pending == Collections.EMPTY_SET) {
            this.pending = new LinkedHashSet<Collectors.TypedCollector<T>>();
        }
    }

    private Collectors.TypedCollector<T> collectorFromProvider(ProviderInternal<? extends T> provider) {
        return new Collectors.TypedCollector(provider.getType(), (Collector)new Collectors.ElementFromProvider(provider));
    }

    @Override
    public boolean removePending(ProviderInternal<? extends T> provider) {
        return this.removeByProvider(provider);
    }

    private boolean removeByProvider(ProviderInternal<?> provider) {
        Iterator<Collectors.TypedCollector<T>> iterator = this.pending.iterator();
        while (iterator.hasNext()) {
            Collectors.TypedCollector<T> collector = iterator.next();
            if (!collector.isProvidedBy(provider)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean addPendingCollection(CollectionProviderInternal<T, ? extends Iterable<T>> provider) {
        this.ensurePendingIsMutable();
        if (provider instanceof ChangingValue) {
            ((ChangingValue)Cast.uncheckedNonnullCast(provider)).onValueChange(previousValues -> {
                for (Object value : previousValues) {
                    this.values.remove(value);
                }
                this.pending.add(this.collectorFromCollectionProvider(provider));
            });
        }
        Collectors.TypedCollector<T> collector = this.collectorFromCollectionProvider(provider);
        boolean added = this.pending.add(collector);
        if (this.subscriptionVerifier.isSubscribed(provider.getElementType())) {
            this.realize(Collections.singleton(collector));
            this.pending.add(collector);
        }
        return added;
    }

    private Collectors.TypedCollector<T> collectorFromCollectionProvider(CollectionProviderInternal<T, ? extends Iterable<T>> provider) {
        return new Collectors.TypedCollector(provider.getElementType(), (Collector)new Collectors.ElementsFromCollectionProvider(provider));
    }

    @Override
    public boolean removePendingCollection(CollectionProviderInternal<T, ? extends Iterable<T>> provider) {
        return this.removeByProvider((ProviderInternal<?>)provider);
    }

    @Override
    public void onPendingAdded(Action<T> action) {
        this.addRealizedAction = action;
    }

    @Override
    public void setSubscriptionVerifier(EventSubscriptionVerifier<T> subscriptionVerifier) {
        this.subscriptionVerifier = subscriptionVerifier;
    }

    @Override
    public void realizeExternal(ProviderInternal<? extends T> provider) {
        this.removePending(provider);
    }

    @Override
    public MutationGuard getMutationGuard() {
        return this.mutationGuard;
    }
}

