/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath.intercept;

import javax.annotation.Nullable;
import org.gradle.internal.classpath.intercept.Invocation;
import org.gradle.internal.classpath.intercept.InvocationUtils;

public final class InvocationImpl<R>
implements Invocation {
    private final R receiver;
    private final Object[] args;
    private final ThrowingSupplier callOriginal;

    public InvocationImpl(R receiver, Object[] args, ThrowingSupplier callNext) {
        this.receiver = receiver;
        this.args = args;
        this.callOriginal = callNext;
    }

    public R getReceiver() {
        return this.receiver;
    }

    @Override
    public int getArgsCount() {
        return this.args.length;
    }

    @Override
    @Nullable
    public Object getArgument(int pos) {
        return InvocationUtils.unwrap(this.args[pos]);
    }

    @Override
    @Nullable
    public Object callNext() throws Throwable {
        return this.callOriginal.get();
    }

    @FunctionalInterface
    public static interface ThrowingSupplier {
        @Nullable
        public Object get() throws Throwable;
    }
}

