/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.function;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apiguardian.api.API;
import org.junit.platform.commons.JUnitException;

@API(status=API.Status.MAINTAINED, since="1.4")
public abstract class Try<V> {
    public static <V> Try<V> call(Callable<V> action) {
        Try.checkNotNull(action, "action");
        return Try.of(() -> Try.success(action.call()));
    }

    public static <V> Try<V> success(V value) {
        return new Success<V>(value);
    }

    public static <V> Try<V> failure(Exception cause) {
        return new Failure(Try.checkNotNull(cause, "cause"));
    }

    private static <T> T checkNotNull(T input, String title) {
        if (input == null) {
            throw new JUnitException(title + " must not be null");
        }
        return input;
    }

    private static <V> Try<V> of(Callable<Try<V>> action) {
        try {
            return action.call();
        }
        catch (Exception e) {
            return Try.failure(e);
        }
    }

    private Try() {
    }

    public abstract <U> Try<U> andThenTry(Transformer<V, U> var1);

    public abstract <U> Try<U> andThen(Function<V, Try<U>> var1);

    public abstract Try<V> orElseTry(Callable<V> var1);

    public abstract Try<V> orElse(Supplier<Try<V>> var1);

    public abstract V get() throws Exception;

    public abstract <E extends Exception> V getOrThrow(Function<? super Exception, E> var1) throws E;

    public abstract Try<V> ifSuccess(Consumer<V> var1);

    public abstract Try<V> ifFailure(Consumer<Exception> var1);

    public abstract Optional<V> toOptional();

    private static class Success<V>
    extends Try<V> {
        private final V value;

        Success(V value) {
            this.value = value;
        }

        @Override
        public <U> Try<U> andThenTry(Transformer<V, U> transformer) {
            Try.checkNotNull(transformer, "transformer");
            return Try.call(() -> transformer.apply(this.value));
        }

        @Override
        public <U> Try<U> andThen(Function<V, Try<U>> function) {
            Try.checkNotNull(function, "function");
            return Try.of(() -> (Try)function.apply(this.value));
        }

        @Override
        public Try<V> orElseTry(Callable<V> action) {
            return this;
        }

        @Override
        public Try<V> orElse(Supplier<Try<V>> supplier) {
            return this;
        }

        @Override
        public V get() {
            return this.value;
        }

        @Override
        public <E extends Exception> V getOrThrow(Function<? super Exception, E> exceptionTransformer) {
            return this.value;
        }

        @Override
        public Try<V> ifSuccess(Consumer<V> valueConsumer) {
            Try.checkNotNull(valueConsumer, "valueConsumer");
            valueConsumer.accept(this.value);
            return this;
        }

        @Override
        public Try<V> ifFailure(Consumer<Exception> causeConsumer) {
            return this;
        }

        @Override
        public Optional<V> toOptional() {
            return Optional.ofNullable(this.value);
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (that == null || this.getClass() != that.getClass()) {
                return false;
            }
            return Objects.equals(this.value, ((Success)that).value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }

    private static class Failure<V>
    extends Try<V> {
        private final Exception cause;

        Failure(Exception cause) {
            this.cause = cause;
        }

        @Override
        public <U> Try<U> andThenTry(Transformer<V, U> transformer) {
            return this.uncheckedCast();
        }

        @Override
        public <U> Try<U> andThen(Function<V, Try<U>> function) {
            return this.uncheckedCast();
        }

        private <U> Try<U> uncheckedCast() {
            return this;
        }

        @Override
        public Try<V> orElseTry(Callable<V> action) {
            Try.checkNotNull(action, "action");
            return Try.call(action);
        }

        @Override
        public Try<V> orElse(Supplier<Try<V>> supplier) {
            Try.checkNotNull(supplier, "supplier");
            return Try.of(supplier::get);
        }

        @Override
        public V get() throws Exception {
            throw this.cause;
        }

        @Override
        public <E extends Exception> V getOrThrow(Function<? super Exception, E> exceptionTransformer) throws E {
            Try.checkNotNull(exceptionTransformer, "exceptionTransformer");
            throw (Exception)exceptionTransformer.apply(this.cause);
        }

        @Override
        public Try<V> ifSuccess(Consumer<V> valueConsumer) {
            return this;
        }

        @Override
        public Try<V> ifFailure(Consumer<Exception> causeConsumer) {
            Try.checkNotNull(causeConsumer, "causeConsumer");
            causeConsumer.accept(this.cause);
            return this;
        }

        @Override
        public Optional<V> toOptional() {
            return Optional.empty();
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (that == null || this.getClass() != that.getClass()) {
                return false;
            }
            return Objects.equals(this.cause, ((Failure)that).cause);
        }

        public int hashCode() {
            return Objects.hash(this.cause);
        }
    }

    @FunctionalInterface
    public static interface Transformer<S, T> {
        public T apply(S var1) throws Exception;
    }
}

