/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.resolver;

import com.google.common.annotations.VisibleForTesting;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ResolverResults;
import org.gradle.api.internal.artifacts.configurations.ArtifactCollectionInternal;
import org.gradle.api.internal.artifacts.configurations.DefaultArtifactCollection;
import org.gradle.api.internal.artifacts.configurations.ResolutionBackedFileCollection;
import org.gradle.api.internal.artifacts.configurations.ResolutionResultProvider;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSelectionSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.SelectedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.results.VisitedGraphResults;
import org.gradle.api.internal.artifacts.resolver.ResolutionAccess;
import org.gradle.api.internal.artifacts.resolver.ResolutionOutputsInternal;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.provider.DefaultProvider;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.internal.Actions;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.model.CalculatedValueFactory;
import org.gradle.internal.reflect.Instantiator;

public class DefaultResolutionOutputs
implements ResolutionOutputsInternal {
    private final ResolutionAccess resolutionAccess;
    private final TaskDependencyFactory taskDependencyFactory;
    private final CalculatedValueContainerFactory calculatedValueContainerFactory;
    private final ImmutableAttributesFactory attributesFactory;
    private final Instantiator instantiator;

    public DefaultResolutionOutputs(ResolutionAccess resolutionAccess, TaskDependencyFactory taskDependencyFactory, CalculatedValueContainerFactory calculatedValueContainerFactory, ImmutableAttributesFactory attributesFactory, Instantiator instantiator) {
        this.resolutionAccess = resolutionAccess;
        this.taskDependencyFactory = taskDependencyFactory;
        this.calculatedValueContainerFactory = calculatedValueContainerFactory;
        this.attributesFactory = attributesFactory;
        this.instantiator = instantiator;
    }

    @Override
    public ResolutionResultProvider<ResolverResults> getRawResults() {
        return this.resolutionAccess.getResults();
    }

    @Override
    public Provider<ResolvedComponentResult> getRootComponent() {
        return new DefaultProvider(() -> this.getVisitedGraphResults().getResolutionResult().getRootSource().get());
    }

    private VisitedGraphResults getVisitedGraphResults() {
        VisitedGraphResults graph = this.resolutionAccess.getResults().getValue().getVisitedGraph();
        graph.getResolutionFailure().ifPresent(ex -> {
            throw ex;
        });
        return graph;
    }

    @Override
    public FileCollectionInternal getFiles() {
        return this.doGetArtifactView((Action<? super ArtifactView.ViewConfiguration>)Actions.doNothing()).getFiles();
    }

    @Override
    public ArtifactCollectionInternal getArtifacts() {
        return this.doGetArtifactView((Action<? super ArtifactView.ViewConfiguration>)Actions.doNothing()).getArtifacts();
    }

    @Override
    public ArtifactView artifactView(Action<? super ArtifactView.ViewConfiguration> action) {
        return this.doGetArtifactView(action);
    }

    private DefaultArtifactView doGetArtifactView(Action<? super ArtifactView.ViewConfiguration> action) {
        DefaultArtifactViewConfiguration viewConfiguration = (DefaultArtifactViewConfiguration)this.instantiator.newInstance(DefaultArtifactViewConfiguration.class, new Object[]{this.attributesFactory});
        action.execute((Object)viewConfiguration);
        return new DefaultArtifactView(viewConfiguration.lenient, (Spec<? super ComponentIdentifier>)viewConfiguration.componentFilter, viewConfiguration.reselectVariants, viewConfiguration.viewAttributes.asImmutable(), this.resolutionAccess, this.taskDependencyFactory, this.calculatedValueContainerFactory, this.attributesFactory);
    }

    public static class DefaultArtifactViewConfiguration
    implements ArtifactView.ViewConfiguration {
        private final AttributeContainerInternal viewAttributes;
        private Spec<? super ComponentIdentifier> componentFilter = Specs.satisfyAll();
        private boolean lenient;
        private boolean reselectVariants;

        public DefaultArtifactViewConfiguration(ImmutableAttributesFactory attributesFactory) {
            this.viewAttributes = attributesFactory.mutable();
        }

        public AttributeContainer getAttributes() {
            return this.viewAttributes;
        }

        public ArtifactView.ViewConfiguration attributes(Action<? super AttributeContainer> action) {
            action.execute((Object)this.viewAttributes);
            return this;
        }

        public ArtifactView.ViewConfiguration componentFilter(Spec<? super ComponentIdentifier> componentFilter) {
            if (this.componentFilter != Specs.SATISFIES_ALL) {
                throw new IllegalStateException("The component filter can only be set once before the view was computed");
            }
            this.componentFilter = componentFilter;
            return this;
        }

        public boolean isLenient() {
            return this.lenient;
        }

        public void setLenient(boolean lenient) {
            this.lenient = lenient;
        }

        public ArtifactView.ViewConfiguration lenient(boolean lenient) {
            this.lenient = lenient;
            return this;
        }

        public ArtifactView.ViewConfiguration withVariantReselection() {
            this.reselectVariants = true;
            return this;
        }
    }

    @VisibleForTesting
    public static class DefaultArtifactView
    implements ArtifactView {
        private final boolean lenient;
        private final Spec<? super ComponentIdentifier> componentFilter;
        private final boolean reselectVariants;
        private final ImmutableAttributes viewAttributes;
        private final ResolutionAccess resolutionAccess;
        private final TaskDependencyFactory taskDependencyFactory;
        private final CalculatedValueContainerFactory calculatedValueContainerFactory;
        private final ImmutableAttributesFactory attributesFactory;

        public DefaultArtifactView(boolean lenient, Spec<? super ComponentIdentifier> componentFilter, boolean reselectVariants, ImmutableAttributes viewAttributes, ResolutionAccess resolutionAccess, TaskDependencyFactory taskDependencyFactory, CalculatedValueContainerFactory calculatedValueContainerFactory, ImmutableAttributesFactory attributesFactory) {
            this.lenient = lenient;
            this.componentFilter = componentFilter;
            this.reselectVariants = reselectVariants;
            this.viewAttributes = viewAttributes;
            this.resolutionAccess = resolutionAccess;
            this.taskDependencyFactory = taskDependencyFactory;
            this.calculatedValueContainerFactory = calculatedValueContainerFactory;
            this.attributesFactory = attributesFactory;
        }

        public ArtifactCollectionInternal getArtifacts() {
            return new DefaultArtifactCollection(this.getFiles(), this.lenient, this.resolutionAccess.getHost(), (CalculatedValueFactory)this.calculatedValueContainerFactory);
        }

        public ResolutionBackedFileCollection getFiles() {
            return new ResolutionBackedFileCollection(this.resolutionAccess.getResults().map(this::selectArtifacts), this.lenient, this.resolutionAccess.getHost(), this.taskDependencyFactory);
        }

        private SelectedArtifactSet selectArtifacts(ResolverResults results) {
            boolean allowNoMatchingVariants = !this.viewAttributes.isEmpty();
            return results.getVisitedArtifacts().select(new ArtifactSelectionSpec(this.getAttributes(), this.componentFilter, this.reselectVariants, allowNoMatchingVariants, this.resolutionAccess.getDefaultSortOrder()));
        }

        public ImmutableAttributes getAttributes() {
            ImmutableAttributes baseAttributes = this.resolutionAccess.getAttributes();
            if (this.viewAttributes.isEmpty()) {
                return baseAttributes;
            }
            if (this.reselectVariants) {
                return this.viewAttributes;
            }
            return this.attributesFactory.concat(baseAttributes, this.viewAttributes);
        }
    }
}

