/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.local;

import com.google.common.io.CountingInputStream;
import com.google.common.io.CountingOutputStream;
import com.google.common.io.Files;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.gradle.api.Action;
import org.gradle.api.resources.ResourceException;
import org.gradle.internal.file.FileMetadata;
import org.gradle.internal.file.FileType;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.resource.AbstractExternalResource;
import org.gradle.internal.resource.ExternalResource;
import org.gradle.internal.resource.ExternalResourceReadResult;
import org.gradle.internal.resource.ExternalResourceWriteResult;
import org.gradle.internal.resource.LocalBinaryResource;
import org.gradle.internal.resource.ReadableContent;
import org.gradle.internal.resource.ResourceExceptions;
import org.gradle.internal.resource.local.LocallyAvailableExternalResource;
import org.gradle.internal.resource.metadata.DefaultExternalResourceMetaData;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;

public class LocalFileStandInExternalResource
extends AbstractExternalResource
implements LocallyAvailableExternalResource,
LocalBinaryResource {
    private final File localFile;
    private final FileSystem fileSystem;

    public LocalFileStandInExternalResource(File localFile, FileSystem fileSystem) {
        this.localFile = localFile;
        this.fileSystem = fileSystem;
    }

    @Override
    public URI getURI() {
        return this.localFile.toURI();
    }

    @Override
    public File getFile() {
        return this.localFile;
    }

    @Override
    public String getBaseName() {
        return this.localFile.getName();
    }

    @Override
    public File getContainingFile() {
        return this.localFile;
    }

    @Override
    public long getContentLength() {
        return this.localFile.length();
    }

    @Override
    public String getDisplayName() {
        return this.localFile.getPath();
    }

    @Override
    @Nullable
    public ExternalResourceMetaData getMetaData() {
        FileMetadata fileMetadata = this.fileSystem.stat(this.localFile);
        if (fileMetadata.getType() == FileType.Missing) {
            return null;
        }
        return new DefaultExternalResourceMetaData(this.localFile.toURI(), fileMetadata.getLastModified(), fileMetadata.getLength());
    }

    @Override
    public ExternalResourceReadResult<Void> writeTo(OutputStream output) {
        if (!this.localFile.exists()) {
            throw ResourceExceptions.getMissing(this.getURI());
        }
        try {
            try (CountingInputStream input = new CountingInputStream((InputStream)new FileInputStream(this.localFile));){
                IOUtils.copyLarge((InputStream)input, (OutputStream)output);
            }
            return ExternalResourceReadResult.of(input.getCount());
        }
        catch (IOException e) {
            throw ResourceExceptions.getFailed(this.getURI(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ExternalResourceReadResult<Void> writeToIfPresent(File destination) {
        if (!this.localFile.exists()) {
            return null;
        }
        try {
            try (CountingInputStream input = new CountingInputStream((InputStream)new FileInputStream(this.localFile));
                 FileOutputStream output = new FileOutputStream(destination);){
                IOUtils.copyLarge((InputStream)input, (OutputStream)output);
            }
            return ExternalResourceReadResult.of(input.getCount());
        }
        catch (IOException e) {
            throw ResourceExceptions.getFailed(this.getURI(), e);
        }
    }

    @Override
    public ExternalResourceReadResult<Void> withContent(Action<? super InputStream> readAction) {
        if (!this.localFile.exists()) {
            throw ResourceExceptions.getMissing(this.getURI());
        }
        try {
            try (CountingInputStream input = new CountingInputStream((InputStream)new BufferedInputStream(new FileInputStream(this.localFile)));){
                readAction.execute((Object)input);
            }
            return ExternalResourceReadResult.of(input.getCount());
        }
        catch (IOException e) {
            throw ResourceExceptions.getFailed(this.getURI(), e);
        }
    }

    @Override
    @Nullable
    public <T> ExternalResourceReadResult<T> withContentIfPresent(ExternalResource.ContentAndMetadataAction<? extends T> readAction) throws ResourceException {
        ExternalResourceReadResult<T> externalResourceReadResult;
        if (!this.localFile.exists()) {
            return null;
        }
        CountingInputStream input = new CountingInputStream((InputStream)new BufferedInputStream(new FileInputStream(this.localFile)));
        try {
            T resourceReadResult = readAction.execute((InputStream)input, this.getMetaData());
            externalResourceReadResult = ExternalResourceReadResult.of(input.getCount(), resourceReadResult);
        }
        catch (Throwable throwable) {
            try {
                try {
                    input.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw ResourceExceptions.getFailed(this.getURI(), e);
            }
        }
        input.close();
        return externalResourceReadResult;
    }

    @Override
    @Nullable
    public <T> ExternalResourceReadResult<T> withContentIfPresent(ExternalResource.ContentAction<? extends T> readAction) throws ResourceException {
        ExternalResourceReadResult<T> externalResourceReadResult;
        if (!this.localFile.exists()) {
            return null;
        }
        CountingInputStream input = new CountingInputStream((InputStream)new BufferedInputStream(new FileInputStream(this.localFile)));
        try {
            T resourceReadResult = readAction.execute((InputStream)input);
            externalResourceReadResult = ExternalResourceReadResult.of(input.getCount(), resourceReadResult);
        }
        catch (Throwable throwable) {
            try {
                try {
                    input.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw ResourceExceptions.getFailed(this.getURI(), e);
            }
        }
        input.close();
        return externalResourceReadResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExternalResourceWriteResult put(ReadableContent location) {
        ExternalResourceWriteResult externalResourceWriteResult;
        block13: {
            if (!this.localFile.canWrite()) {
                this.localFile.delete();
            }
            Files.createParentDirs((File)this.localFile);
            InputStream input = location.open();
            try {
                try (CountingOutputStream output = new CountingOutputStream((OutputStream)new FileOutputStream(this.localFile));){
                    IOUtils.copyLarge((InputStream)input, (OutputStream)output);
                }
                externalResourceWriteResult = new ExternalResourceWriteResult(output.getCount());
                if (input == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw ResourceExceptions.putFailed(this.getURI(), e);
                }
            }
            input.close();
        }
        return externalResourceWriteResult;
    }

    @Override
    public InputStream open() throws ResourceException {
        if (this.localFile.isDirectory()) {
            throw ResourceExceptions.readFolder(this.localFile);
        }
        try {
            return new FileInputStream(this.localFile);
        }
        catch (FileNotFoundException e) {
            throw ResourceExceptions.readMissing(this.localFile, e);
        }
    }

    @Override
    @Nullable
    public List<String> list() throws ResourceException {
        if (this.localFile.isDirectory()) {
            String[] names = this.localFile.list();
            return Arrays.asList(names);
        }
        return null;
    }
}

