/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.properties.bean;

import java.util.Queue;
import org.gradle.api.internal.tasks.TaskDependencyContainer;
import org.gradle.internal.properties.PropertyValue;
import org.gradle.internal.properties.PropertyVisitor;
import org.gradle.internal.properties.annotations.TypeMetadata;
import org.gradle.internal.properties.bean.AbstractNestedRuntimeBeanNode;
import org.gradle.internal.properties.bean.RuntimeBeanNode;
import org.gradle.internal.properties.bean.RuntimeBeanNodeFactory;
import org.gradle.internal.reflect.validation.TypeValidationContext;
import org.gradle.internal.snapshot.impl.ImplementationValue;

class NestedRuntimeBeanNode
extends AbstractNestedRuntimeBeanNode {
    private final ImplementationValue implementation;

    public NestedRuntimeBeanNode(RuntimeBeanNode<Object> parentNode, String propertyName, Object bean, ImplementationValue implementation, TypeMetadata typeMetadata) {
        super(parentNode, propertyName, bean, typeMetadata);
        this.implementation = implementation;
    }

    @Override
    public void visitNode(PropertyVisitor visitor, Queue<RuntimeBeanNode<?>> queue, RuntimeBeanNodeFactory nodeFactory, TypeValidationContext validationContext) {
        this.visitImplementation(visitor);
        this.visitProperties(visitor, queue, nodeFactory, validationContext);
    }

    private void visitImplementation(PropertyVisitor visitor) {
        visitor.visitInputProperty(this.getPropertyName(), new ImplementationPropertyValue(this.implementation), false);
    }

    private static class ImplementationPropertyValue
    implements PropertyValue {
        private final ImplementationValue implementationValue;

        public ImplementationPropertyValue(ImplementationValue implementationValue) {
            this.implementationValue = implementationValue;
        }

        @Override
        public Object call() {
            return this.implementationValue;
        }

        @Override
        public TaskDependencyContainer getTaskDependencies() {
            return TaskDependencyContainer.EMPTY;
        }

        @Override
        public void maybeFinalizeValue() {
        }

        public String toString() {
            return "Implementation: " + this.implementationValue;
        }
    }
}

