/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.filestore;

import java.io.File;
import javax.inject.Inject;
import org.gradle.api.Namer;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactCacheMetadata;
import org.gradle.api.internal.file.temp.TemporaryFileProvider;
import org.gradle.api.internal.filestore.ArtifactIdentifierFileStore;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;
import org.gradle.internal.file.FileAccessTimeJournal;
import org.gradle.internal.hash.ChecksumService;
import org.gradle.internal.resource.local.GroupedAndNamedUniqueFileStore;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;

public class DefaultArtifactIdentifierFileStore
extends GroupedAndNamedUniqueFileStore<ModuleComponentArtifactIdentifier>
implements ArtifactIdentifierFileStore {
    private static final int NUMBER_OF_GROUPING_DIRS = 3;
    public static final int FILE_TREE_DEPTH_TO_TRACK_AND_CLEANUP = 4;
    private static final GroupedAndNamedUniqueFileStore.Grouper<ModuleComponentArtifactIdentifier> GROUPER = new GroupedAndNamedUniqueFileStore.Grouper<ModuleComponentArtifactIdentifier>(){

        public String determineGroup(ModuleComponentArtifactIdentifier artifactId) {
            return artifactId.getComponentIdentifier().getGroup() + '/' + artifactId.getComponentIdentifier().getModule() + '/' + artifactId.getComponentIdentifier().getVersion();
        }

        public int getNumberOfGroupingDirs() {
            return 3;
        }
    };
    private static final Namer<ModuleComponentArtifactIdentifier> NAMER = ModuleComponentArtifactIdentifier::getFileName;

    private DefaultArtifactIdentifierFileStore(File baseDir, TemporaryFileProvider temporaryFileProvider, FileAccessTimeJournal fileAccessTimeJournal, ChecksumService checksumService) {
        super(baseDir, temporaryFileProvider, fileAccessTimeJournal, GROUPER, NAMER, checksumService);
    }

    @ServiceScope(value=Scopes.Build.class)
    public static class Factory {
        private final TemporaryFileProvider temporaryFileProvider;
        private final FileAccessTimeJournal fileAccessTimeJournal;
        private final ChecksumService checksumService;

        @Inject
        public Factory(TemporaryFileProvider temporaryFileProvider, FileAccessTimeJournal fileAccessTimeJournal, ChecksumService checksumService) {
            this.temporaryFileProvider = temporaryFileProvider;
            this.fileAccessTimeJournal = fileAccessTimeJournal;
            this.checksumService = checksumService;
        }

        public DefaultArtifactIdentifierFileStore create(ArtifactCacheMetadata artifactCacheMetadata) {
            return new DefaultArtifactIdentifierFileStore(artifactCacheMetadata.getFileStoreDirectory(), this.temporaryFileProvider, this.fileAccessTimeJournal, this.checksumService);
        }
    }
}

