/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.build;

import java.io.Closeable;
import java.io.IOException;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.initialization.IncludedBuildSpec;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.build.BuildLifecycleController;
import org.gradle.internal.build.BuildModelControllerServices;
import org.gradle.internal.build.BuildProjectRegistry;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.BuildToolingModelController;
import org.gradle.internal.build.BuildWorkGraphController;
import org.gradle.internal.buildtree.BuildTreeState;
import org.gradle.internal.lazy.Lazy;
import org.gradle.internal.service.scopes.BuildScopeServices;

public abstract class AbstractBuildState
implements BuildState,
Closeable {
    private final BuildScopeServices buildServices;
    private final Lazy<BuildLifecycleController> buildLifecycleController;
    private final Lazy<ProjectStateRegistry> projectStateRegistry;
    private final Lazy<BuildWorkGraphController> workGraphController;

    public AbstractBuildState(BuildTreeState buildTree, BuildDefinition buildDefinition, @Nullable BuildState parent) {
        BuildModelControllerServices buildModelControllerServices = (BuildModelControllerServices)buildTree.getServices().get(BuildModelControllerServices.class);
        BuildModelControllerServices.Supplier supplier = buildModelControllerServices.servicesForBuild(buildDefinition, this, parent);
        this.buildServices = this.prepareServices(buildTree, buildDefinition, supplier);
        this.buildLifecycleController = Lazy.locking().of(() -> (BuildLifecycleController)this.buildServices.get(BuildLifecycleController.class));
        this.projectStateRegistry = Lazy.locking().of(() -> (ProjectStateRegistry)this.buildServices.get(ProjectStateRegistry.class));
        this.workGraphController = Lazy.locking().of(() -> (BuildWorkGraphController)this.buildServices.get(BuildWorkGraphController.class));
    }

    protected BuildScopeServices prepareServices(BuildTreeState buildTree, BuildDefinition buildDefinition, BuildModelControllerServices.Supplier supplier) {
        return new BuildScopeServices(buildTree.getServices(), supplier);
    }

    protected BuildScopeServices getBuildServices() {
        return this.buildServices;
    }

    @Override
    public void close() throws IOException {
        this.buildServices.close();
    }

    @Override
    public DisplayName getDisplayName() {
        return Describables.of((Object)this.getBuildIdentifier());
    }

    public String toString() {
        return this.getDisplayName().getDisplayName();
    }

    @Override
    public void assertCanAdd(IncludedBuildSpec includedBuildSpec) {
        throw new UnsupportedOperationException("Cannot include build '" + includedBuildSpec.rootDir.getName() + "' in " + this.getBuildIdentifier() + ". This is not supported yet.");
    }

    @Override
    public boolean isImportableBuild() {
        return true;
    }

    protected ProjectStateRegistry getProjectStateRegistry() {
        return (ProjectStateRegistry)this.projectStateRegistry.get();
    }

    @Override
    public BuildProjectRegistry getProjects() {
        return this.getProjectStateRegistry().projectsFor(this.getBuildIdentifier());
    }

    protected BuildLifecycleController getBuildController() {
        return (BuildLifecycleController)this.buildLifecycleController.get();
    }

    @Override
    public void ensureProjectsLoaded() {
        this.getBuildController().loadSettings();
    }

    @Override
    public boolean isProjectsLoaded() {
        return this.getProjectStateRegistry().findProjectsFor(this.getBuildIdentifier()) != null;
    }

    @Override
    public void ensureProjectsConfigured() {
        this.getBuildController().configureProjects();
    }

    @Override
    public GradleInternal getMutableModel() {
        return this.getBuildController().getGradle();
    }

    @Override
    public BuildWorkGraphController getWorkGraph() {
        return (BuildWorkGraphController)this.workGraphController.get();
    }

    @Override
    public <T> T withToolingModels(Function<? super BuildToolingModelController, T> action) {
        return this.getBuildController().withToolingModels(action);
    }
}

