/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.codehaus.groovy.runtime.ProcessGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.gradle.api.file.FileCollection;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.classpath.AccessTrackingEnvMap;
import org.gradle.internal.classpath.AccessTrackingProperties;
import org.gradle.internal.classpath.intercept.CallInterceptor;
import org.gradle.internal.classpath.intercept.CallInterceptorsSet;
import org.gradle.internal.classpath.intercept.ClassBoundCallInterceptor;
import org.gradle.internal.classpath.intercept.InterceptScope;
import org.gradle.internal.classpath.intercept.Invocation;

public class Instrumented {
    private static final Listener NO_OP = new Listener(){

        @Override
        public void systemPropertyQueried(String key, @Nullable Object value, String consumer) {
        }

        @Override
        public void systemPropertyChanged(Object key, @Nullable Object value, String consumer) {
        }

        @Override
        public void systemPropertyRemoved(Object key, String consumer) {
        }

        @Override
        public void systemPropertiesCleared(String consumer) {
        }

        @Override
        public void envVariableQueried(String key, @Nullable String value, String consumer) {
        }

        @Override
        public void externalProcessStarted(String command, String consumer) {
        }

        @Override
        public void fileOpened(File file, String consumer) {
        }

        @Override
        public void fileObserved(File file, String consumer) {
        }

        @Override
        public void fileCollectionObserved(FileCollection fileCollection, String consumer) {
        }
    };
    private static final AtomicReference<Listener> LISTENER = new AtomicReference<Listener>(NO_OP);
    private static final CallInterceptorsSet CALL_INTERCEPTORS = new CallInterceptorsSet(new SystemGetPropertyInterceptor(), new SystemSetPropertyInterceptor(), new SystemGetPropertiesInterceptor(), new SystemSetPropertiesInterceptor(), new SystemClearPropertyInterceptor(), new IntegerGetIntegerInterceptor(), new LongGetLongInterceptor(), new BooleanGetBooleanInterceptor(), new SystemGetenvInterceptor(), new RuntimeExecInterceptor(), new ProcessGroovyMethodsExecuteInterceptor(), new ProcessBuilderStartInterceptor(), new ProcessBuilderStartPipelineInterceptor(), new FileInputStreamConstructorInterceptor());

    public static void setListener(Listener listener) {
        LISTENER.set(listener);
    }

    public static void discardListener() {
        Instrumented.setListener(NO_OP);
    }

    public static void groovyCallSites(CallSiteArray array) {
        for (org.codehaus.groovy.runtime.callsite.CallSite callSite : array.array) {
            array.array[callSite.getIndex()] = CALL_INTERCEPTORS.maybeDecorateGroovyCallSite(callSite);
        }
    }

    public static CallSite bootstrap(MethodHandles.Lookup caller, String callType, MethodType type, String name, int flags) {
        return CALL_INTERCEPTORS.maybeDecorateIndyCallSite(IndyInterface.bootstrap((MethodHandles.Lookup)caller, (String)callType, (MethodType)type, (String)name, (int)flags), caller, callType, name, flags);
    }

    public static String systemProperty(String key, String consumer) {
        return Instrumented.systemProperty(key, null, consumer);
    }

    public static String systemProperty(String key, @Nullable String defaultValue, String consumer) {
        String value = System.getProperty(key);
        Instrumented.systemPropertyQueried(key, value, consumer);
        return value == null ? defaultValue : value;
    }

    public static Properties systemProperties(final String consumer) {
        return new AccessTrackingProperties(System.getProperties(), new AccessTrackingProperties.Listener(){

            @Override
            public void onAccess(Object key, @Nullable Object value) {
                if (key instanceof String && (value == null || value instanceof String)) {
                    Instrumented.systemPropertyQueried(Instrumented.convertToString(key), Instrumented.convertToString(value), consumer);
                }
            }

            @Override
            public void onChange(Object key, Object newValue) {
                Instrumented.listener().systemPropertyChanged(key, newValue, consumer);
            }

            @Override
            public void onRemove(Object key) {
                Instrumented.listener().systemPropertyRemoved(key, consumer);
            }

            @Override
            public void onClear() {
                Instrumented.listener().systemPropertiesCleared(consumer);
            }
        });
    }

    public static String setSystemProperty(String key, String value, String consumer) {
        String oldValue = System.setProperty(key, value);
        Instrumented.systemPropertyQueried(key, oldValue, consumer);
        Instrumented.listener().systemPropertyChanged(key, value, consumer);
        return oldValue;
    }

    public static String clearSystemProperty(String key, String consumer) {
        String oldValue = System.clearProperty(key);
        Instrumented.systemPropertyQueried(key, oldValue, consumer);
        Instrumented.listener().systemPropertyRemoved(key, consumer);
        return oldValue;
    }

    public static void setSystemProperties(Properties properties, String consumer) {
        Instrumented.listener().systemPropertiesCleared(consumer);
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> Instrumented.listener().systemPropertyChanged(k, v, consumer)));
        System.setProperties(properties);
    }

    public static Integer getInteger(String key, String consumer) {
        Instrumented.systemPropertyQueried(key, consumer);
        return Integer.getInteger(key);
    }

    public static Integer getInteger(String key, int defaultValue, String consumer) {
        Instrumented.systemPropertyQueried(key, consumer);
        return Integer.getInteger(key, defaultValue);
    }

    public static Integer getInteger(String key, Integer defaultValue, String consumer) {
        Instrumented.systemPropertyQueried(key, consumer);
        return Integer.getInteger(key, defaultValue);
    }

    public static Long getLong(String key, String consumer) {
        Instrumented.systemPropertyQueried(key, consumer);
        return Long.getLong(key);
    }

    public static Long getLong(String key, long defaultValue, String consumer) {
        Instrumented.systemPropertyQueried(key, consumer);
        return Long.getLong(key, defaultValue);
    }

    public static Long getLong(String key, Long defaultValue, String consumer) {
        Instrumented.systemPropertyQueried(key, consumer);
        return Long.getLong(key, defaultValue);
    }

    public static boolean getBoolean(String key, String consumer) {
        Instrumented.systemPropertyQueried(key, consumer);
        return Boolean.getBoolean(key);
    }

    public static String getenv(String key, String consumer) {
        String value = System.getenv(key);
        Instrumented.envVariableQueried(key, value, consumer);
        return value;
    }

    public static Map<String, String> getenv(String consumer) {
        return new AccessTrackingEnvMap((key, value) -> Instrumented.envVariableQueried(Instrumented.convertToString(key), value, consumer));
    }

    public static Process exec(Runtime runtime, String command, String consumer) throws IOException {
        Instrumented.externalProcessStarted(command, consumer);
        return runtime.exec(command);
    }

    public static Process exec(Runtime runtime, String[] command, String consumer) throws IOException {
        Instrumented.externalProcessStarted(command, consumer);
        return runtime.exec(command);
    }

    public static Process exec(Runtime runtime, String command, String[] envp, String consumer) throws IOException {
        Instrumented.externalProcessStarted(command, consumer);
        return runtime.exec(command, envp);
    }

    public static Process exec(Runtime runtime, String[] command, String[] envp, String consumer) throws IOException {
        Instrumented.externalProcessStarted(command, consumer);
        return runtime.exec(command, envp);
    }

    public static Process exec(Runtime runtime, String command, String[] envp, File dir, String consumer) throws IOException {
        Instrumented.externalProcessStarted(command, consumer);
        return runtime.exec(command, envp, dir);
    }

    public static Process exec(Runtime runtime, String[] command, String[] envp, File dir, String consumer) throws IOException {
        Instrumented.externalProcessStarted(command, consumer);
        return runtime.exec(command, envp, dir);
    }

    public static Process execute(String command, String consumer) throws IOException {
        Instrumented.externalProcessStarted(command, consumer);
        return ProcessGroovyMethods.execute((String)command);
    }

    public static Process execute(String[] command, String consumer) throws IOException {
        Instrumented.externalProcessStarted(command, consumer);
        return ProcessGroovyMethods.execute((String[])command);
    }

    public static Process execute(List<?> command, String consumer) throws IOException {
        Instrumented.externalProcessStarted(command, consumer);
        return ProcessGroovyMethods.execute(command);
    }

    public static Process execute(String command, String[] envp, File dir, String consumer) throws IOException {
        Instrumented.externalProcessStarted(command, consumer);
        return ProcessGroovyMethods.execute((String)command, (String[])envp, (File)dir);
    }

    public static Process execute(String command, List<?> envp, File dir, String consumer) throws IOException {
        Instrumented.externalProcessStarted(command, consumer);
        return ProcessGroovyMethods.execute((String)command, envp, (File)dir);
    }

    public static Process execute(String[] command, String[] envp, File dir, String consumer) throws IOException {
        Instrumented.externalProcessStarted(command, consumer);
        return ProcessGroovyMethods.execute((String[])command, (String[])envp, (File)dir);
    }

    public static Process execute(String[] command, List<?> envp, File dir, String consumer) throws IOException {
        Instrumented.externalProcessStarted(command, consumer);
        return ProcessGroovyMethods.execute((String[])command, envp, (File)dir);
    }

    public static Process execute(List<?> command, String[] envp, File dir, String consumer) throws IOException {
        Instrumented.externalProcessStarted(command, consumer);
        return ProcessGroovyMethods.execute(command, (String[])envp, (File)dir);
    }

    public static Process execute(List<?> command, List<?> envp, File dir, String consumer) throws IOException {
        Instrumented.externalProcessStarted(command, consumer);
        return ProcessGroovyMethods.execute(command, envp, (File)dir);
    }

    public static Process start(ProcessBuilder builder, String consumer) throws IOException {
        Instrumented.externalProcessStarted(builder.command(), consumer);
        return builder.start();
    }

    public static List<Process> startPipeline(List<ProcessBuilder> pipeline, String consumer) throws IOException {
        try {
            for (ProcessBuilder builder : pipeline) {
                Instrumented.externalProcessStarted(builder.command(), consumer);
            }
            Object result = ProcessBuilder.class.getMethod("startPipeline", List.class).invoke(null, pipeline);
            return (List)result;
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new NoSuchMethodError("Cannot find method ProcessBuilder.startPipeline");
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new RuntimeException("Unexpected exception thrown by ProcessBuilder.startPipeline", e);
        }
    }

    public static void fileCollectionObserved(FileCollection fileCollection, String consumer) {
        Instrumented.listener().fileCollectionObserved(fileCollection, consumer);
    }

    public static void fileObserved(File file, String consumer) {
        Instrumented.listener().fileObserved(Instrumented.absoluteFileOf(file), consumer);
    }

    public static void fileOpened(File file, String consumer) {
        Instrumented.listener().fileOpened(Instrumented.absoluteFileOf(file), consumer);
    }

    private static File absoluteFileOf(File file) {
        return file.isAbsolute() ? file : new File(Instrumented.currentDir(), file.getPath());
    }

    private static File currentDir() {
        return SystemProperties.getInstance().getCurrentDir();
    }

    public static void fileOpened(String path, String consumer) {
        Instrumented.fileOpened(new File(path), consumer);
    }

    private static void envVariableQueried(String key, String value, String consumer) {
        Instrumented.listener().envVariableQueried(key, value, consumer);
    }

    private static void systemPropertyQueried(String key, String consumer) {
        Instrumented.systemPropertyQueried(key, System.getProperty(key), consumer);
    }

    private static void systemPropertyQueried(String key, @Nullable String value, String consumer) {
        Instrumented.listener().systemPropertyQueried(key, value, consumer);
    }

    private static void externalProcessStarted(String command, String consumer) {
        Instrumented.listener().externalProcessStarted(command, consumer);
    }

    private static void externalProcessStarted(String[] command, String consumer) {
        Instrumented.externalProcessStarted(Instrumented.joinCommand(command), consumer);
    }

    private static void externalProcessStarted(List<?> command, String consumer) {
        Instrumented.externalProcessStarted(Instrumented.joinCommand(command), consumer);
    }

    private static Listener listener() {
        return LISTENER.get();
    }

    private static String convertToString(Object arg) {
        if (arg instanceof CharSequence) {
            return ((CharSequence)arg).toString();
        }
        return (String)arg;
    }

    private static String joinCommand(String[] command) {
        return String.join((CharSequence)" ", command);
    }

    private static String joinCommand(List<?> command) {
        return command.stream().map(String::valueOf).collect(Collectors.joining(" "));
    }

    private static class FileInputStreamConstructorInterceptor
    extends CallInterceptor {
        public FileInputStreamConstructorInterceptor() {
            super(InterceptScope.constructorsOf(FileInputStream.class));
        }

        @Override
        protected Object doIntercept(Invocation invocation, String consumer) throws Throwable {
            if (invocation.getArgsCount() == 1) {
                Object argument = invocation.getArgument(0);
                if (argument instanceof CharSequence) {
                    String path = Instrumented.convertToString(argument);
                    Instrumented.fileOpened(path, consumer);
                    return new FileInputStream(path);
                }
                if (argument instanceof File) {
                    File file = (File)argument;
                    Instrumented.fileOpened(file, consumer);
                    return new FileInputStream(file);
                }
            }
            return invocation.callOriginal();
        }
    }

    private static class ProcessBuilderStartPipelineInterceptor
    extends ClassBoundCallInterceptor {
        public ProcessBuilderStartPipelineInterceptor() {
            super(ProcessBuilder.class, InterceptScope.methodsNamed("startPipeline"));
        }

        @Override
        protected Object doInterceptSafe(Invocation invocation, String consumer) throws Throwable {
            if (invocation.getArgsCount() == 1 && invocation.getArgument(0) instanceof List) {
                return Instrumented.startPipeline((List)invocation.getArgument(0), consumer);
            }
            return invocation.callOriginal();
        }
    }

    private static class ProcessBuilderStartInterceptor
    extends CallInterceptor {
        ProcessBuilderStartInterceptor() {
            super(InterceptScope.methodsNamed("start"));
        }

        @Override
        protected Object doIntercept(Invocation invocation, String consumer) throws Throwable {
            Object receiver = invocation.getReceiver();
            if (receiver instanceof ProcessBuilder) {
                return Instrumented.start((ProcessBuilder)receiver, consumer);
            }
            return invocation.callOriginal();
        }
    }

    private static class ProcessGroovyMethodsExecuteInterceptor
    extends CallInterceptor {
        protected ProcessGroovyMethodsExecuteInterceptor() {
            super(InterceptScope.methodsNamed("execute"));
        }

        @Override
        protected Object doIntercept(Invocation invocation, String consumer) throws Throwable {
            Object fileArg;
            Object envpArg;
            int nonCommandArgsOffset;
            boolean isStaticCall = invocation.getReceiver().equals(ProcessGroovyMethods.class);
            int argsCount = invocation.getArgsCount();
            int nonCommandArgsCount = argsCount - (nonCommandArgsOffset = isStaticCall ? 1 : 0);
            if (nonCommandArgsCount != 0 && nonCommandArgsCount != 2) {
                return invocation.callOriginal();
            }
            Object commandArg = isStaticCall ? invocation.getArgument(0) : invocation.getReceiver();
            Optional<Process> result = this.tryCallExecute(commandArg, envpArg = invocation.getOptionalArgument(nonCommandArgsOffset), fileArg = invocation.getOptionalArgument(nonCommandArgsOffset + 1), consumer);
            if (result.isPresent()) {
                return result.get();
            }
            return invocation.callOriginal();
        }

        private Optional<Process> tryCallExecute(Object commandArg, @Nullable Object envpArg, @Nullable Object fileArg, String consumer) throws Throwable {
            if (fileArg == null || fileArg instanceof File) {
                File file = (File)fileArg;
                if (commandArg instanceof CharSequence) {
                    String command = Instrumented.convertToString(commandArg);
                    if (envpArg == null || envpArg instanceof String[]) {
                        return Optional.of(Instrumented.execute(command, (String[])envpArg, file, consumer));
                    }
                    if (envpArg instanceof List) {
                        return Optional.of(Instrumented.execute(command, (List)envpArg, file, consumer));
                    }
                } else if (commandArg instanceof String[]) {
                    String[] command = (String[])commandArg;
                    if (envpArg == null || envpArg instanceof String[]) {
                        return Optional.of(Instrumented.execute(command, (String[])envpArg, file, consumer));
                    }
                    if (envpArg instanceof List) {
                        return Optional.of(Instrumented.execute(command, (List)envpArg, file, consumer));
                    }
                } else if (commandArg instanceof List) {
                    List command = (List)commandArg;
                    if (envpArg == null || envpArg instanceof String[]) {
                        return Optional.of(Instrumented.execute(command, (String[])envpArg, file, consumer));
                    }
                    if (envpArg instanceof List) {
                        return Optional.of(Instrumented.execute(command, (List)envpArg, file, consumer));
                    }
                }
            }
            return Optional.empty();
        }
    }

    private static class RuntimeExecInterceptor
    extends CallInterceptor {
        public RuntimeExecInterceptor() {
            super(InterceptScope.methodsNamed("exec"));
        }

        @Override
        protected Object doIntercept(Invocation invocation, String consumer) throws Throwable {
            Optional<Process> result;
            int argsCount = invocation.getArgsCount();
            if (1 <= argsCount && argsCount <= 3 && (result = this.tryCallExec(invocation.getReceiver(), invocation.getArgument(0), invocation.getOptionalArgument(1), invocation.getOptionalArgument(2), consumer)).isPresent()) {
                return result.get();
            }
            return invocation.callOriginal();
        }

        private Optional<Process> tryCallExec(Object runtimeArg, Object commandArg, @Nullable Object envpArg, @Nullable Object fileArg, String consumer) throws Throwable {
            if (runtimeArg instanceof Runtime) {
                Runtime runtime = (Runtime)runtimeArg;
                if (fileArg == null || fileArg instanceof File) {
                    File file = (File)fileArg;
                    if (envpArg == null || envpArg instanceof String[]) {
                        String[] envp = (String[])envpArg;
                        if (commandArg instanceof CharSequence) {
                            String command = Instrumented.convertToString(commandArg);
                            return Optional.of(Instrumented.exec(runtime, command, envp, file, consumer));
                        }
                        if (commandArg instanceof String[]) {
                            String[] command = (String[])commandArg;
                            return Optional.of(Instrumented.exec(runtime, command, envp, file, consumer));
                        }
                    }
                }
            }
            return Optional.empty();
        }
    }

    private static class SystemGetenvInterceptor
    extends ClassBoundCallInterceptor {
        public SystemGetenvInterceptor() {
            super(System.class, InterceptScope.methodsNamed("getenv"));
        }

        @Override
        protected Object doInterceptSafe(Invocation invocation, String consumer) throws Throwable {
            switch (invocation.getArgsCount()) {
                case 0: {
                    return Instrumented.getenv(consumer);
                }
                case 1: {
                    return Instrumented.getenv(Instrumented.convertToString(invocation.getArgument(0)), consumer);
                }
            }
            return invocation.callOriginal();
        }
    }

    private static class SystemClearPropertyInterceptor
    extends ClassBoundCallInterceptor {
        public SystemClearPropertyInterceptor() {
            super(System.class, InterceptScope.methodsNamed("clearProperty"));
        }

        @Override
        protected Object doInterceptSafe(Invocation invocation, String consumer) throws Throwable {
            if (invocation.getArgsCount() == 1) {
                return Instrumented.clearSystemProperty(Instrumented.convertToString(invocation.getArgument(0)), consumer);
            }
            return invocation.callOriginal();
        }
    }

    private static class SystemSetPropertiesInterceptor
    extends ClassBoundCallInterceptor {
        public SystemSetPropertiesInterceptor() {
            super(System.class, InterceptScope.methodsNamed("setProperties"));
        }

        @Override
        protected Object doInterceptSafe(Invocation invocation, String consumer) throws Throwable {
            if (invocation.getArgsCount() == 1) {
                Instrumented.setSystemProperties((Properties)invocation.getArgument(0), consumer);
                return null;
            }
            return invocation.callOriginal();
        }
    }

    private static class SystemGetPropertiesInterceptor
    extends ClassBoundCallInterceptor {
        public SystemGetPropertiesInterceptor() {
            super(System.class, InterceptScope.readsOfPropertiesNamed("properties"), InterceptScope.methodsNamed("getProperties"));
        }

        @Override
        protected Object doInterceptSafe(Invocation invocation, String consumer) throws Throwable {
            if (invocation.getArgsCount() == 0) {
                return Instrumented.systemProperties(consumer);
            }
            return invocation.callOriginal();
        }
    }

    private static class SystemSetPropertyInterceptor
    extends ClassBoundCallInterceptor {
        public SystemSetPropertyInterceptor() {
            super(System.class, InterceptScope.methodsNamed("setProperty"));
        }

        @Override
        protected Object doInterceptSafe(Invocation invocation, String consumer) throws Throwable {
            if (invocation.getArgsCount() == 2) {
                return Instrumented.setSystemProperty(Instrumented.convertToString(invocation.getArgument(0)), Instrumented.convertToString(invocation.getArgument(1)), consumer);
            }
            return invocation.callOriginal();
        }
    }

    private static class SystemGetPropertyInterceptor
    extends ClassBoundCallInterceptor {
        public SystemGetPropertyInterceptor() {
            super(System.class, InterceptScope.methodsNamed("getProperty"));
        }

        @Override
        protected Object doInterceptSafe(Invocation invocation, String consumer) throws Throwable {
            switch (invocation.getArgsCount()) {
                case 1: {
                    return Instrumented.systemProperty(invocation.getArgument(0).toString(), consumer);
                }
                case 2: {
                    return Instrumented.systemProperty(invocation.getArgument(0).toString(), Instrumented.convertToString(invocation.getArgument(1)), consumer);
                }
            }
            return invocation.callOriginal();
        }
    }

    private static class BooleanGetBooleanInterceptor
    extends ClassBoundCallInterceptor {
        public BooleanGetBooleanInterceptor() {
            super(Boolean.class, InterceptScope.methodsNamed("getBoolean"));
        }

        @Override
        protected Object doInterceptSafe(Invocation invocation, String consumer) throws Throwable {
            if (invocation.getArgsCount() == 1) {
                return Instrumented.getBoolean(invocation.getArgument(0).toString(), consumer);
            }
            return invocation.callOriginal();
        }
    }

    private static class LongGetLongInterceptor
    extends ClassBoundCallInterceptor {
        public LongGetLongInterceptor() {
            super(Long.class, InterceptScope.methodsNamed("getLong"));
        }

        @Override
        protected Object doInterceptSafe(Invocation invocation, String consumer) throws Throwable {
            switch (invocation.getArgsCount()) {
                case 1: {
                    return Instrumented.getLong(invocation.getArgument(0).toString(), consumer);
                }
                case 2: {
                    return Instrumented.getLong(invocation.getArgument(0).toString(), (Long)invocation.getArgument(1), consumer);
                }
            }
            return invocation.callOriginal();
        }
    }

    private static class IntegerGetIntegerInterceptor
    extends ClassBoundCallInterceptor {
        public IntegerGetIntegerInterceptor() {
            super(Integer.class, InterceptScope.methodsNamed("getInteger"));
        }

        @Override
        protected Object doInterceptSafe(Invocation invocation, String consumer) throws Throwable {
            switch (invocation.getArgsCount()) {
                case 1: {
                    return Instrumented.getInteger(invocation.getArgument(0).toString(), consumer);
                }
                case 2: {
                    return Instrumented.getInteger(invocation.getArgument(0).toString(), (Integer)invocation.getArgument(1), consumer);
                }
            }
            return invocation.callOriginal();
        }
    }

    public static interface Listener {
        public void systemPropertyQueried(String var1, @Nullable Object var2, String var3);

        public void systemPropertyChanged(Object var1, @Nullable Object var2, String var3);

        public void systemPropertyRemoved(Object var1, String var2);

        public void systemPropertiesCleared(String var1);

        public void envVariableQueried(String var1, @Nullable String var2, String var3);

        public void externalProcessStarted(String var1, String var2);

        public void fileOpened(File var1, String var2);

        public void fileObserved(File var1, String var2);

        public void fileCollectionObserved(FileCollection var1, String var2);
    }
}

