/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.moduleconverter;

import javax.inject.Inject;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.Module;
import org.gradle.api.internal.artifacts.component.ComponentIdentifierFactory;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.configurations.ConfigurationsProvider;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.artifacts.configurations.MutationValidator;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyLockingProvider;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.LocalComponentMetadataBuilder;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.RootComponentMetadataBuilder;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.EmptySchema;
import org.gradle.api.internal.initialization.RootScriptDomainObjectContext;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.internal.component.local.model.BuildableLocalConfigurationMetadata;
import org.gradle.internal.component.local.model.DefaultLocalComponentMetadata;
import org.gradle.internal.component.local.model.LocalComponentMetadata;
import org.gradle.internal.component.local.model.RootLocalComponentMetadata;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.model.ModelContainer;

public class DefaultRootComponentMetadataBuilder
implements RootComponentMetadataBuilder {
    private final DependencyMetaDataProvider metadataProvider;
    private final ComponentIdentifierFactory componentIdentifierFactory;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
    private final LocalComponentMetadataBuilder localComponentMetadataBuilder;
    private final ConfigurationsProvider configurationsProvider;
    private final MetadataHolder holder;
    private final ProjectStateRegistry projectStateRegistry;
    private final DependencyLockingProvider dependencyLockingProvider;
    private final CalculatedValueContainerFactory calculatedValueContainerFactory;
    private final Factory factory;

    private DefaultRootComponentMetadataBuilder(DependencyMetaDataProvider metadataProvider, ComponentIdentifierFactory componentIdentifierFactory, ImmutableModuleIdentifierFactory moduleIdentifierFactory, LocalComponentMetadataBuilder localComponentMetadataBuilder, ConfigurationsProvider configurationsProvider, ProjectStateRegistry projectStateRegistry, DependencyLockingProvider dependencyLockingProvider, CalculatedValueContainerFactory calculatedValueContainerFactory, Factory factory) {
        this.metadataProvider = metadataProvider;
        this.componentIdentifierFactory = componentIdentifierFactory;
        this.moduleIdentifierFactory = moduleIdentifierFactory;
        this.localComponentMetadataBuilder = localComponentMetadataBuilder;
        this.configurationsProvider = configurationsProvider;
        this.projectStateRegistry = projectStateRegistry;
        this.dependencyLockingProvider = dependencyLockingProvider;
        this.calculatedValueContainerFactory = calculatedValueContainerFactory;
        this.factory = factory;
        this.holder = new MetadataHolder(configurationsProvider);
    }

    @Override
    public LocalComponentMetadata toRootComponentMetaData() {
        Module module = this.metadataProvider.getModule();
        ComponentIdentifier componentIdentifier = this.componentIdentifierFactory.createComponentIdentifier(module);
        DefaultLocalComponentMetadata metadata = this.holder.tryCached(componentIdentifier);
        if (metadata == null) {
            metadata = this.buildRootComponentMetadata(module, componentIdentifier);
            this.holder.cachedValue = metadata;
        }
        return metadata;
    }

    private DefaultLocalComponentMetadata buildRootComponentMetadata(Module module, ComponentIdentifier componentIdentifier) {
        ModuleVersionIdentifier moduleVersionIdentifier = this.moduleIdentifierFactory.moduleWithVersion(module.getGroup(), module.getName(), module.getVersion());
        ProjectComponentIdentifier projectId = module.getProjectId();
        if (projectId != null) {
            ProjectState projectState = this.projectStateRegistry.stateFor(projectId);
            if (!projectState.hasMutableState()) {
                throw new IllegalStateException("Thread should hold project lock for " + projectId);
            }
            return (DefaultLocalComponentMetadata)projectState.fromMutableState(project -> {
                AttributesSchemaInternal schema = (AttributesSchemaInternal)project.getDependencies().getAttributesSchema();
                return this.getRootComponentMetadata(module, componentIdentifier, moduleVersionIdentifier, schema, this.dependencyLockingProvider, (ModelContainer<?>)projectState);
            });
        }
        return this.getRootComponentMetadata(module, componentIdentifier, moduleVersionIdentifier, EmptySchema.INSTANCE, this.dependencyLockingProvider, (ModelContainer<?>)RootScriptDomainObjectContext.INSTANCE);
    }

    private DefaultLocalComponentMetadata getRootComponentMetadata(Module module, ComponentIdentifier componentIdentifier, ModuleVersionIdentifier moduleVersionIdentifier, AttributesSchemaInternal schema, DependencyLockingProvider dependencyLockingHandler, ModelContainer<?> model) {
        RootLocalComponentMetadata metadata = new RootLocalComponentMetadata(moduleVersionIdentifier, componentIdentifier, module.getStatus(), schema, dependencyLockingHandler, model, this.calculatedValueContainerFactory);
        for (ConfigurationInternal configurationInternal : this.configurationsProvider.getAll()) {
            this.addConfiguration(metadata, configurationInternal);
        }
        return metadata;
    }

    private void addConfiguration(DefaultLocalComponentMetadata metadata, ConfigurationInternal configuration) {
        BuildableLocalConfigurationMetadata buildableLocalConfigurationMetadata = this.localComponentMetadataBuilder.addConfiguration(metadata, configuration);
        if (configuration.getResolutionStrategy().isDependencyLockingEnabled()) {
            buildableLocalConfigurationMetadata.enableLocking();
        }
    }

    @Override
    public RootComponentMetadataBuilder withConfigurationsProvider(ConfigurationsProvider alternateProvider) {
        return this.factory.create(alternateProvider);
    }

    public MutationValidator getValidator() {
        return this.holder;
    }

    public void discardAll() {
        this.holder.cachedValue = null;
    }

    public static class Factory {
        private final DependencyMetaDataProvider metaDataProvider;
        private final ComponentIdentifierFactory componentIdentifierFactory;
        private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
        private final LocalComponentMetadataBuilder localComponentMetadataBuilder;
        private final ProjectStateRegistry projectStateRegistry;
        private final DependencyLockingProvider dependencyLockingProvider;
        private final CalculatedValueContainerFactory calculatedValueContainerFactory;

        @Inject
        public Factory(DependencyMetaDataProvider metaDataProvider, ComponentIdentifierFactory componentIdentifierFactory, ImmutableModuleIdentifierFactory moduleIdentifierFactory, LocalComponentMetadataBuilder localComponentMetadataBuilder, ProjectStateRegistry projectStateRegistry, DependencyLockingProvider dependencyLockingProvider, CalculatedValueContainerFactory calculatedValueContainerFactory) {
            this.metaDataProvider = metaDataProvider;
            this.componentIdentifierFactory = componentIdentifierFactory;
            this.moduleIdentifierFactory = moduleIdentifierFactory;
            this.localComponentMetadataBuilder = localComponentMetadataBuilder;
            this.projectStateRegistry = projectStateRegistry;
            this.dependencyLockingProvider = dependencyLockingProvider;
            this.calculatedValueContainerFactory = calculatedValueContainerFactory;
        }

        public DefaultRootComponentMetadataBuilder create(ConfigurationsProvider configurationsProvider) {
            return new DefaultRootComponentMetadataBuilder(this.metaDataProvider, this.componentIdentifierFactory, this.moduleIdentifierFactory, this.localComponentMetadataBuilder, configurationsProvider, this.projectStateRegistry, this.dependencyLockingProvider, this.calculatedValueContainerFactory, this);
        }
    }

    private static class MetadataHolder
    implements MutationValidator {
        private DefaultLocalComponentMetadata cachedValue;
        private final ConfigurationsProvider configurationsProvider;

        private MetadataHolder(ConfigurationsProvider configurationsProvider) {
            this.configurationsProvider = configurationsProvider;
        }

        @Override
        public void validateMutation(MutationValidator.MutationType type) {
            if ((type == MutationValidator.MutationType.DEPENDENCIES || type == MutationValidator.MutationType.ARTIFACTS || type == MutationValidator.MutationType.DEPENDENCY_ATTRIBUTES) && this.cachedValue != null) {
                if (this.cachedValue.getConfigurationNames().size() != this.configurationsProvider.size()) {
                    this.cachedValue = null;
                } else {
                    this.cachedValue.reevaluate();
                }
            }
        }

        DefaultLocalComponentMetadata tryCached(ComponentIdentifier id) {
            if (this.cachedValue != null) {
                if (this.cachedValue.getId().equals(id)) {
                    return this.cachedValue;
                }
                this.cachedValue = null;
            }
            return null;
        }
    }
}

