/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.intrinsics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.interpreter.Instruction;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import org.jetbrains.kotlin.ir.interpreter.SimpleInstruction;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.IntrinsicBase;
import org.jetbrains.kotlin.ir.interpreter.state.Complex;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KTypeState;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/intrinsics/EnumValues;", "Lorg/jetbrains/kotlin/ir/interpreter/intrinsics/IntrinsicBase;", "()V", "canHandleFunctionWithName", "", "fqName", "", "origin", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "evaluate", "", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "environment", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "getEnumClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "unwind", "", "Lorg/jetbrains/kotlin/ir/interpreter/Instruction;", "ir.interpreter"})
public final class EnumValues
extends IntrinsicBase {
    @NotNull
    public static final EnumValues INSTANCE = new EnumValues();

    private EnumValues() {
        super(null);
    }

    @Override
    public boolean canHandleFunctionWithName(@NotNull String fqName2, @NotNull IrDeclarationOrigin origin) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        return Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.enumValues");
    }

    private final IrClass getEnumClass(IrFunction irFunction2, IrInterpreterEnvironment environment) {
        IrClass irClass2;
        String string2 = String.valueOf(IrUtilsKt.getFqNameWhenAvailable(irFunction2));
        if (Intrinsics.areEqual((Object)string2, (Object)"kotlin.enumValues")) {
            KTypeState kType = (KTypeState)environment.getCallStack().getState(((IrTypeParameter)CollectionsKt.first(irFunction2.getTypeParameters())).getSymbol());
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(kType.getIrType());
            Intrinsics.checkNotNull((Object)irClassSymbol);
            irClass2 = (IrClass)irClassSymbol.getOwner();
        } else {
            irClass2 = (IrClass)irFunction2.getParent();
        }
        return irClass2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Instruction> unwind(@NotNull IrFunction irFunction2, @NotNull IrInterpreterEnvironment environment) {
        Collection<SimpleInstruction> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        IrClass enumClass2 = this.getEnumClass(irFunction2, environment);
        Iterable $this$filterIsInstance$iv = enumClass2.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrEnumEntry)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List enumEntries = (List)destination$iv$iv;
        $this$filterIsInstance$iv = CollectionsKt.reversed((Iterable)enumEntries);
        Collection collection2 = super.unwind(irFunction2, environment);
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrEnumEntry irEnumEntry = (IrEnumEntry)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            SimpleInstruction simpleInstruction = new SimpleInstruction((IrElement)it);
            collection.add(simpleInstruction);
        }
        collection = (List)destination$iv$iv;
        return CollectionsKt.plus((Collection)collection2, (Iterable)collection);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void evaluate(@NotNull IrFunction irFunction2, @NotNull IrInterpreterEnvironment environment) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        IrClass enumClass2 = this.getEnumClass(irFunction2, environment);
        Iterable $this$filterIsInstance$iv = enumClass2.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrEnumEntry)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrEnumEntry irEnumEntry = (IrEnumEntry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Complex complex = environment.getMapOfEnums().get(it.getSymbol());
            collection.add(complex);
        }
        List enumEntries = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = enumEntries;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Complex[] complexArray = thisCollection$iv.toArray(new Complex[0]);
        if (complexArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        environment.getCallStack().pushState(UtilsKt.toState(complexArray, irFunction2.getReturnType()));
    }
}

