/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import java.util.List;
import java.util.Optional;
import org.gradle.api.execution.TaskActionListener;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskExecuterResult;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.TaskExecutionOutcome;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.internal.tasks.execution.EmptySourceTaskSkipper;
import org.gradle.api.internal.tasks.execution.TaskCacheabilityResolver;
import org.gradle.api.internal.tasks.execution.TaskExecution;
import org.gradle.api.tasks.TaskExecutionException;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.execution.ExecutionEngine;
import org.gradle.internal.execution.ExecutionOutcome;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.WorkValidationException;
import org.gradle.internal.execution.caching.CachingState;
import org.gradle.internal.execution.fingerprint.InputFingerprinter;
import org.gradle.internal.execution.history.ExecutionHistoryStore;
import org.gradle.internal.file.ReservedFileSystemLocationRegistry;
import org.gradle.internal.hash.ClassLoaderHierarchyHasher;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.work.AsyncWorkTracker;

public class ExecuteActionsTaskExecuter
implements TaskExecuter {
    private final BuildCacheState buildCacheState;
    private final ScanPluginState scanPluginState;
    private final ExecutionHistoryStore executionHistoryStore;
    private final BuildOperationExecutor buildOperationExecutor;
    private final AsyncWorkTracker asyncWorkTracker;
    private final TaskActionListener actionListener;
    private final TaskCacheabilityResolver taskCacheabilityResolver;
    private final ClassLoaderHierarchyHasher classLoaderHierarchyHasher;
    private final ExecutionEngine executionEngine;
    private final InputFingerprinter inputFingerprinter;
    private final ListenerManager listenerManager;
    private final ReservedFileSystemLocationRegistry reservedFileSystemLocationRegistry;
    private final EmptySourceTaskSkipper emptySourceTaskSkipper;
    private final FileCollectionFactory fileCollectionFactory;
    private final FileOperations fileOperations;

    public ExecuteActionsTaskExecuter(BuildCacheState buildCacheState, ScanPluginState scanPluginState, ExecutionHistoryStore executionHistoryStore, BuildOperationExecutor buildOperationExecutor, AsyncWorkTracker asyncWorkTracker, TaskActionListener actionListener, TaskCacheabilityResolver taskCacheabilityResolver, ClassLoaderHierarchyHasher classLoaderHierarchyHasher, ExecutionEngine executionEngine, InputFingerprinter inputFingerprinter, ListenerManager listenerManager, ReservedFileSystemLocationRegistry reservedFileSystemLocationRegistry, EmptySourceTaskSkipper emptySourceTaskSkipper, FileCollectionFactory fileCollectionFactory, FileOperations fileOperations) {
        this.buildCacheState = buildCacheState;
        this.scanPluginState = scanPluginState;
        this.executionHistoryStore = executionHistoryStore;
        this.buildOperationExecutor = buildOperationExecutor;
        this.asyncWorkTracker = asyncWorkTracker;
        this.actionListener = actionListener;
        this.taskCacheabilityResolver = taskCacheabilityResolver;
        this.classLoaderHierarchyHasher = classLoaderHierarchyHasher;
        this.executionEngine = executionEngine;
        this.inputFingerprinter = inputFingerprinter;
        this.listenerManager = listenerManager;
        this.reservedFileSystemLocationRegistry = reservedFileSystemLocationRegistry;
        this.emptySourceTaskSkipper = emptySourceTaskSkipper;
        this.fileCollectionFactory = fileCollectionFactory;
        this.fileOperations = fileOperations;
    }

    @Override
    public TaskExecuterResult execute(TaskInternal task, TaskStateInternal state, TaskExecutionContext context) {
        boolean emitLegacySnapshottingOperations = this.buildCacheState == BuildCacheState.ENABLED || this.scanPluginState == ScanPluginState.APPLIED;
        TaskExecution work = new TaskExecution(task, context, emitLegacySnapshottingOperations, this.actionListener, this.asyncWorkTracker, this.buildOperationExecutor, this.classLoaderHierarchyHasher, this.emptySourceTaskSkipper, this.executionHistoryStore, this.fileCollectionFactory, this.fileOperations, this.inputFingerprinter, this.listenerManager, this.reservedFileSystemLocationRegistry, this.taskCacheabilityResolver);
        try {
            return this.executeIfValid(task, state, context, work);
        }
        catch (WorkValidationException ex) {
            state.setOutcome((RuntimeException)((Object)ex));
            return TaskExecuterResult.WITHOUT_OUTPUTS;
        }
    }

    private TaskExecuterResult executeIfValid(TaskInternal task, TaskStateInternal state, TaskExecutionContext context, TaskExecution work) {
        ExecutionEngine.Request request = this.executionEngine.createRequest((UnitOfWork)work);
        context.getTaskExecutionMode().getRebuildReason().ifPresent(arg_0 -> ((ExecutionEngine.Request)request).forceNonIncremental(arg_0));
        request.withValidationContext(context.getValidationContext());
        final ExecutionEngine.Result result = request.execute();
        result.getExecutionResult().ifSuccessfulOrElse(executionResult -> state.setOutcome(TaskExecutionOutcome.valueOf(executionResult.getOutcome())), failure -> state.setOutcome((RuntimeException)((Object)new TaskExecutionException(task, (Throwable)failure))));
        return new TaskExecuterResult(){

            @Override
            public Optional<OriginMetadata> getReusedOutputOriginMetadata() {
                return result.getReusedOutputOriginMetadata();
            }

            @Override
            public boolean executedIncrementally() {
                return (Boolean)result.getExecutionResult().map(executionResult -> executionResult.getOutcome() == ExecutionOutcome.EXECUTED_INCREMENTALLY).getOrMapFailure(throwable -> false);
            }

            @Override
            public List<String> getExecutionReasons() {
                return result.getExecutionReasons();
            }

            @Override
            public CachingState getCachingState() {
                return result.getCachingState();
            }
        };
    }

    public static enum ScanPluginState {
        APPLIED,
        NOT_APPLIED;

    }

    public static enum BuildCacheState {
        ENABLED,
        DISABLED;

    }
}

