/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.caching.impl;

import java.util.Map;
import org.gradle.internal.execution.caching.CachingDisabledReason;
import org.gradle.internal.execution.caching.impl.DefaultCachingStateBuilder;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.snapshot.impl.ImplementationSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingCachingStateBuilder
extends DefaultCachingStateBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingCachingStateBuilder.class);

    @Override
    protected void processImplementation(ImplementationSnapshot implementation) {
        LOGGER.warn("Appending implementation to build cache key: {}", (Object)implementation);
        super.processImplementation(implementation);
    }

    @Override
    protected void processAdditionalImplementation(ImplementationSnapshot additionalImplementation) {
        LOGGER.warn("Appending additional implementation to build cache key: {}", (Object)additionalImplementation);
        super.processAdditionalImplementation(additionalImplementation);
    }

    @Override
    protected void recordInputValueFingerprint(String propertyName, HashCode fingerprint) {
        LOGGER.warn("Appending input value fingerprint for '{}' to build cache key: {}", (Object)propertyName, (Object)fingerprint);
        super.recordInputValueFingerprint(propertyName, fingerprint);
    }

    @Override
    public void withInputFilePropertyFingerprints(Map<String, CurrentFileCollectionFingerprint> fingerprints) {
        fingerprints.forEach((propertyName, fingerprint) -> LOGGER.warn("Appending input file fingerprints for '{}' to build cache key: {} - {}", new Object[]{propertyName, fingerprint.getHash(), fingerprint}));
        super.withInputFilePropertyFingerprints(fingerprints);
    }

    @Override
    public void withOutputPropertyNames(Iterable<String> propertyNames) {
        propertyNames.forEach(propertyName -> LOGGER.warn("Appending output property name to build cache key: {}", propertyName));
        super.withOutputPropertyNames(propertyNames);
    }

    @Override
    public void markNotCacheable(CachingDisabledReason reason) {
        LOGGER.warn("Non-cacheable because {} [{}]", (Object)reason.getMessage(), (Object)reason.getCategory());
        super.markNotCacheable(reason);
    }
}

