/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.gradle.BuildListener;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.invocation.Gradle;
import org.gradle.execution.ProjectConfigurer;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.internal.InternalBuildAdapter;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.buildtree.BuildActionRunner;
import org.gradle.internal.buildtree.BuildTreeLifecycleController;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.resources.ProjectLeaseRegistry;
import org.gradle.tooling.internal.protocol.InternalBuildAction;
import org.gradle.tooling.internal.protocol.InternalBuildActionFailureException;
import org.gradle.tooling.internal.protocol.InternalBuildActionVersion2;
import org.gradle.tooling.internal.protocol.InternalBuildController;
import org.gradle.tooling.internal.protocol.InternalBuildControllerVersion2;
import org.gradle.tooling.internal.protocol.PhasedActionResult;
import org.gradle.tooling.internal.provider.runner.DefaultBuildController;

public abstract class AbstractClientProvidedBuildActionRunner
implements BuildActionRunner {
    private final BuildCancellationToken buildCancellationToken;
    private final BuildOperationExecutor buildOperationExecutor;
    private final ProjectLeaseRegistry projectLeaseRegistry;

    public AbstractClientProvidedBuildActionRunner(BuildCancellationToken buildCancellationToken, BuildOperationExecutor buildOperationExecutor, ProjectLeaseRegistry projectLeaseRegistry) {
        this.buildCancellationToken = buildCancellationToken;
        this.buildOperationExecutor = buildOperationExecutor;
        this.projectLeaseRegistry = projectLeaseRegistry;
    }

    protected BuildActionRunner.Result runClientAction(ClientAction action, BuildTreeLifecycleController buildController) {
        GradleInternal gradle = buildController.getGradle();
        ActionRunningListener listener = new ActionRunningListener(action, this.buildCancellationToken, this.buildOperationExecutor, this.projectLeaseRegistry);
        try {
            gradle.addBuildListener((BuildListener)listener);
            buildController.fromBuildModel(action.isRunTasks(), (Function)listener);
            return BuildActionRunner.Result.of((Object)action.getResult());
        }
        catch (RuntimeException e) {
            RuntimeException clientFailure = e;
            if (listener.actionFailure != null) {
                clientFailure = new InternalBuildActionFailureException((Throwable)listener.actionFailure);
            }
            return BuildActionRunner.Result.failed((Throwable)e, (RuntimeException)clientFailure);
        }
    }

    private void forceFullConfiguration(GradleInternal gradle, Set<GradleInternal> alreadyConfigured) {
        ((ProjectConfigurer)gradle.getServices().get(ProjectConfigurer.class)).configureHierarchyFully(gradle.getRootProject());
        for (IncludedBuild includedBuild : gradle.getIncludedBuilds()) {
            GradleInternal build;
            if (!(includedBuild instanceof IncludedBuildState) || alreadyConfigured.contains(build = ((IncludedBuildState)includedBuild).getConfiguredBuild())) continue;
            alreadyConfigured.add(build);
            this.forceFullConfiguration(build, alreadyConfigured);
        }
    }

    private class ActionRunningListener
    extends InternalBuildAdapter
    implements Function<GradleInternal, Object> {
        private final ClientAction clientAction;
        private final BuildCancellationToken buildCancellationToken;
        private final BuildOperationExecutor buildOperationExecutor;
        private final ProjectLeaseRegistry projectLeaseRegistry;
        RuntimeException actionFailure;

        ActionRunningListener(ClientAction clientAction, BuildCancellationToken buildCancellationToken, BuildOperationExecutor buildOperationExecutor, ProjectLeaseRegistry projectLeaseRegistry) {
            this.clientAction = clientAction;
            this.buildCancellationToken = buildCancellationToken;
            this.buildOperationExecutor = buildOperationExecutor;
            this.projectLeaseRegistry = projectLeaseRegistry;
        }

        public void projectsEvaluated(Gradle gradle) {
            GradleInternal gradleInternal = (GradleInternal)gradle;
            AbstractClientProvidedBuildActionRunner.this.forceFullConfiguration(gradleInternal, new HashSet());
            this.runAction(gradleInternal, this.clientAction.getProjectsEvaluatedAction(), PhasedActionResult.Phase.PROJECTS_LOADED);
        }

        @Override
        public Object apply(GradleInternal gradle) {
            this.runAction(gradle, this.clientAction.getBuildFinishedAction(), PhasedActionResult.Phase.BUILD_FINISHED);
            return null;
        }

        private void runAction(GradleInternal gradle, @Nullable Object action, PhasedActionResult.Phase phase) {
            if (action == null || this.actionFailure != null) {
                return;
            }
            DefaultBuildController internalBuildController = new DefaultBuildController(gradle, this.buildCancellationToken, this.buildOperationExecutor, this.projectLeaseRegistry);
            try {
                Object result = action instanceof InternalBuildActionVersion2 ? ((InternalBuildActionVersion2)action).execute((InternalBuildControllerVersion2)internalBuildController) : ((InternalBuildAction)action).execute((InternalBuildController)internalBuildController);
                this.clientAction.collectActionResult(result, phase);
            }
            catch (RuntimeException e) {
                this.actionFailure = e;
                throw e;
            }
        }
    }

    protected static interface ClientAction {
        @Nullable
        public Object getProjectsEvaluatedAction();

        @Nullable
        public Object getBuildFinishedAction();

        public void collectActionResult(Object var1, PhasedActionResult.Phase var2);

        public boolean isRunTasks();

        public Object getResult();
    }
}

