/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resolve.caching;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.Transformer;
import org.gradle.api.internal.artifacts.configurations.dynamicversion.CachePolicy;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.PersistentIndexedCacheParameters;
import org.gradle.cache.internal.InMemoryCacheDecoratorFactory;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.internal.Cast;
import org.gradle.internal.action.ConfigurableRule;
import org.gradle.internal.action.ConfigurableRules;
import org.gradle.internal.action.InstantiatingAction;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.isolation.Isolatable;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.resolve.caching.CachingRuleExecutor;
import org.gradle.internal.resolve.caching.ImplicitInputRecord;
import org.gradle.internal.resolve.caching.ImplicitInputRecorder;
import org.gradle.internal.resolve.caching.ImplicitInputsCapturingInstantiator;
import org.gradle.internal.resolve.caching.ImplicitInputsProvidingService;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.BaseSerializerFactory;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.HashCodeSerializer;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.snapshot.ValueSnapshotter;
import org.gradle.util.internal.BuildCommencedTimeProvider;

public class CrossBuildCachingRuleExecutor<KEY, DETAILS, RESULT>
implements CachingRuleExecutor<KEY, DETAILS, RESULT>,
Closeable {
    private static final Logger LOGGER = Logging.getLogger(CrossBuildCachingRuleExecutor.class);
    private final ValueSnapshotter snapshotter;
    private final Transformer<?, KEY> keyToSnapshottable;
    private final PersistentCache cache;
    private final PersistentIndexedCache<HashCode, CachedEntry<RESULT>> store;
    private final BuildCommencedTimeProvider timeProvider;
    private final EntryValidator<RESULT> validator;

    public CrossBuildCachingRuleExecutor(String name, CacheRepository cacheRepository, InMemoryCacheDecoratorFactory cacheDecoratorFactory, ValueSnapshotter snapshotter, BuildCommencedTimeProvider timeProvider, EntryValidator<RESULT> validator, Transformer<?, KEY> keyToSnapshottable, Serializer<RESULT> resultSerializer) {
        this.snapshotter = snapshotter;
        this.validator = validator;
        this.keyToSnapshottable = keyToSnapshottable;
        this.timeProvider = timeProvider;
        this.cache = cacheRepository.cache(name).withLockOptions((LockOptions)LockOptionsBuilder.mode((FileLockManager.LockMode)FileLockManager.LockMode.OnDemand)).open();
        PersistentIndexedCacheParameters<HashCode, CachedEntry<RESULT>> cacheParams = this.createCacheConfiguration(name, resultSerializer, cacheDecoratorFactory);
        this.store = this.cache.createCache(cacheParams);
    }

    private PersistentIndexedCacheParameters<HashCode, CachedEntry<RESULT>> createCacheConfiguration(String name, Serializer<RESULT> resultSerializer, InMemoryCacheDecoratorFactory cacheDecoratorFactory) {
        return PersistentIndexedCacheParameters.of((String)name, (Serializer)new HashCodeSerializer(), this.createEntrySerializer(resultSerializer)).withCacheDecorator(cacheDecoratorFactory.decorator(2000, true));
    }

    private Serializer<CachedEntry<RESULT>> createEntrySerializer(Serializer<RESULT> resultSerializer) {
        return new CacheEntrySerializer<RESULT>(resultSerializer);
    }

    @Override
    public <D extends DETAILS> RESULT execute(KEY key, InstantiatingAction<DETAILS> action, Transformer<RESULT, D> detailsToResult, Transformer<D, KEY> onCacheMiss, CachePolicy cachePolicy) {
        if (action == null) {
            return null;
        }
        ConfigurableRules rules = action.getRules();
        if (rules.isCacheable()) {
            return this.tryFromCache(key, action, detailsToResult, onCacheMiss, cachePolicy, rules);
        }
        return this.executeRule(key, action, detailsToResult, onCacheMiss);
    }

    private <D extends DETAILS> RESULT tryFromCache(KEY key, InstantiatingAction<DETAILS> action, Transformer<RESULT, D> detailsToResult, Transformer<D, KEY> onCacheMiss, CachePolicy cachePolicy, ConfigurableRules<DETAILS> rules) {
        CachedEntry entry;
        HashCode keyHash = this.computeExplicitInputsSnapshot(key, rules);
        DefaultImplicitInputRegistrar registrar = new DefaultImplicitInputRegistrar();
        ImplicitInputsCapturingInstantiator instantiator = this.findInputCapturingInstantiator(action);
        if (instantiator != null) {
            action = action.withInstantiator(instantiator.capturing(registrar));
        }
        if ((entry = (CachedEntry)this.store.getIfPresent((Object)keyHash)) != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Found result for rule {} and key {} in cache", rules, key);
            }
            if (this.validator.isValid(cachePolicy, entry) && this.areImplicitInputsUpToDate(instantiator, key, rules, entry)) {
                return entry.getResult();
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Invalidating result for rule {} and key {} in cache", rules, key);
            }
        }
        RESULT result = this.executeRule(key, action, detailsToResult, onCacheMiss);
        this.store.put((Object)keyHash, new CachedEntry(this.timeProvider.getCurrentTime(), registrar.implicits, result));
        return result;
    }

    private HashCode computeExplicitInputsSnapshot(KEY key, ConfigurableRules<DETAILS> rules) {
        ArrayList toBeSnapshotted = Lists.newArrayListWithExpectedSize((int)(2 + 2 * rules.getConfigurableRules().size()));
        toBeSnapshotted.add(this.keyToSnapshottable.transform(key));
        for (ConfigurableRule rule : rules.getConfigurableRules()) {
            Class ruleClass = rule.getRuleClass();
            Isolatable ruleParams = rule.getRuleParams();
            toBeSnapshotted.add(ruleClass);
            toBeSnapshotted.add(ruleParams);
        }
        Hasher hasher = Hashing.newHasher();
        this.snapshotter.snapshot((Object)toBeSnapshotted).appendToHasher(hasher);
        return hasher.hash();
    }

    private ImplicitInputsCapturingInstantiator findInputCapturingInstantiator(InstantiatingAction<DETAILS> action) {
        Instantiator instantiator = action.getInstantiator();
        if (instantiator instanceof ImplicitInputsCapturingInstantiator) {
            return (ImplicitInputsCapturingInstantiator)instantiator;
        }
        return null;
    }

    private boolean areImplicitInputsUpToDate(ImplicitInputsCapturingInstantiator serviceRegistry, KEY key, ConfigurableRules<DETAILS> rules, CachedEntry<RESULT> entry) {
        for (Map.Entry implicitEntry : entry.getImplicits().asMap().entrySet()) {
            String serviceName = (String)implicitEntry.getKey();
            ImplicitInputsProvidingService provider = (ImplicitInputsProvidingService)Cast.uncheckedCast(serviceRegistry.findInputCapturingServiceByName(serviceName));
            for (ImplicitInputRecord list : (Collection)implicitEntry.getValue()) {
                if (provider.isUpToDate(list.getInput(), list.getOutput())) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Invalidating result for rule {} and key {} in cache because implicit input provided by service {} changed", new Object[]{rules, key, provider.getClass()});
                }
                return false;
            }
        }
        return true;
    }

    private <D extends DETAILS> RESULT executeRule(KEY key, InstantiatingAction<DETAILS> action, Transformer<RESULT, D> detailsToResult, Transformer<D, KEY> onCacheMiss) {
        Object details = onCacheMiss.transform(key);
        action.execute(details);
        return (RESULT)detailsToResult.transform(details);
    }

    @Override
    public void close() throws IOException {
        this.cache.close();
    }

    private static class AnySerializer
    implements Serializer<Object> {
        private static final BaseSerializerFactory SERIALIZER_FACTORY = new BaseSerializerFactory();
        private static final Class<?>[] USUAL_TYPES = new Class[]{String.class, Boolean.class, Long.class, File.class, byte[].class, HashCode.class, Throwable.class};

        private AnySerializer() {
        }

        public Object read(Decoder decoder) throws Exception {
            Class<?> clazz;
            int index = decoder.readSmallInt();
            if (index == -1) {
                return null;
            }
            if (index == -2) {
                String typeName = decoder.readString();
                clazz = Class.forName(typeName);
            } else {
                clazz = USUAL_TYPES[index];
            }
            return SERIALIZER_FACTORY.getSerializerFor(clazz).read(decoder);
        }

        public void write(Encoder encoder, Object value) throws Exception {
            if (value == null) {
                encoder.writeSmallInt(-1);
                return;
            }
            Class<?> anyType = value.getClass();
            Serializer serializer = (Serializer)Cast.uncheckedCast((Object)SERIALIZER_FACTORY.getSerializerFor(anyType));
            for (int i = 0; i < USUAL_TYPES.length; ++i) {
                if (!USUAL_TYPES[i].equals(anyType)) continue;
                encoder.writeSmallInt(i);
                serializer.write(encoder, value);
                return;
            }
            encoder.writeSmallInt(-2);
            encoder.writeString((CharSequence)anyType.getName());
            serializer.write(encoder, value);
        }
    }

    private static class DefaultImplicitInputRegistrar
    implements ImplicitInputRecorder {
        final Multimap<String, ImplicitInputRecord<?, ?>> implicits = HashMultimap.create();

        private DefaultImplicitInputRegistrar() {
        }

        @Override
        public <IN, OUT> void register(String serviceName, ImplicitInputRecord<IN, OUT> input) {
            this.implicits.put((Object)serviceName, input);
        }
    }

    private static class CacheEntrySerializer<RESULT>
    extends AbstractSerializer<CachedEntry<RESULT>> {
        private final Serializer<RESULT> resultSerializer;
        private final AnySerializer anySerializer = new AnySerializer();

        public CacheEntrySerializer(Serializer<RESULT> resultSerializer) {
            this.resultSerializer = resultSerializer;
        }

        public CachedEntry<RESULT> read(Decoder decoder) throws Exception {
            return new CachedEntry(decoder.readLong(), this.readImplicits(decoder), this.resultSerializer.read(decoder));
        }

        private Multimap<String, ImplicitInputRecord<?, ?>> readImplicits(Decoder decoder) throws Exception {
            int cpt = decoder.readSmallInt();
            HashMultimap result = HashMultimap.create();
            for (int i = 0; i < cpt; ++i) {
                String impl = decoder.readString();
                List<ImplicitInputRecord<?, ?>> implicitInputOutputs = this.readImplicitList(decoder);
                result.putAll((Object)impl, implicitInputOutputs);
            }
            return result;
        }

        List<ImplicitInputRecord<?, ?>> readImplicitList(Decoder decoder) throws Exception {
            int cpt = decoder.readSmallInt();
            ArrayList implicits = Lists.newArrayListWithCapacity((int)cpt);
            for (int i = 0; i < cpt; ++i) {
                final Object in = this.readAny(decoder);
                final Object out = this.readAny(decoder);
                implicits.add(new ImplicitInputRecord<Object, Object>(){

                    @Override
                    public Object getInput() {
                        return in;
                    }

                    @Override
                    @Nullable
                    public Object getOutput() {
                        return out;
                    }
                });
            }
            return implicits;
        }

        @Nullable
        private Object readAny(Decoder decoder) throws Exception {
            return this.anySerializer.read(decoder);
        }

        public void write(Encoder encoder, CachedEntry<RESULT> value) throws Exception {
            encoder.writeLong(((CachedEntry)value).timestamp);
            this.writeImplicits(encoder, ((CachedEntry)value).implicits);
            this.resultSerializer.write(encoder, ((CachedEntry)value).result);
        }

        private void writeImplicits(Encoder encoder, Multimap<String, ImplicitInputRecord<?, ?>> implicits) throws Exception {
            encoder.writeSmallInt(implicits.size());
            for (Map.Entry entry : implicits.asMap().entrySet()) {
                encoder.writeString((CharSequence)entry.getKey());
                this.writeImplicitList(encoder, (Collection)entry.getValue());
            }
        }

        private void writeImplicitList(Encoder encoder, Collection<ImplicitInputRecord<?, ?>> implicits) throws Exception {
            encoder.writeSmallInt(implicits.size());
            for (ImplicitInputRecord<?, ?> implicit : implicits) {
                this.writeAny(encoder, implicit.getInput());
                this.writeAny(encoder, implicit.getOutput());
            }
        }

        private void writeAny(Encoder encoder, Object any) throws Exception {
            this.anySerializer.write(encoder, any);
        }
    }

    public static interface EntryValidator<RESULT> {
        public boolean isValid(CachePolicy var1, CachedEntry<RESULT> var2);
    }

    public static class CachedEntry<RESULT> {
        private final long timestamp;
        private final Multimap<String, ImplicitInputRecord<?, ?>> implicits;
        private final RESULT result;

        private CachedEntry(long timestamp, Multimap<String, ImplicitInputRecord<?, ?>> implicits, RESULT result) {
            this.timestamp = timestamp;
            this.implicits = implicits;
            this.result = result;
        }

        public Multimap<String, ImplicitInputRecord<?, ?>> getImplicits() {
            return this.implicits;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public RESULT getResult() {
            return this.result;
        }
    }
}

