/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.transport;

import org.gradle.api.internal.artifacts.repositories.transport.NetworkingIssueVerifier;
import org.gradle.internal.UncheckedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkOperationBackOffAndRetry {
    private static final String MAX_ATTEMPTS = "org.gradle.internal.network.retry.max.attempts";
    private static final String INITIAL_BACKOFF_MS = "org.gradle.internal.network.retry.initial.backOff";
    private static final Logger LOGGER = LoggerFactory.getLogger(NetworkOperationBackOffAndRetry.class);
    private final int maxDeployAttempts;
    private final int initialBackOff;

    public NetworkOperationBackOffAndRetry() {
        this(Integer.getInteger(MAX_ATTEMPTS, 3), Integer.getInteger(INITIAL_BACKOFF_MS, 1000));
    }

    public NetworkOperationBackOffAndRetry(int maxDeployAttempts, int initialBackOff) {
        this.maxDeployAttempts = maxDeployAttempts;
        this.initialBackOff = initialBackOff;
        assert (maxDeployAttempts > 0);
        assert (initialBackOff > 0);
    }

    public void withBackoffAndRetry(Runnable operation) {
        int backoff = this.initialBackOff;
        int retries = 0;
        while (retries < this.maxDeployAttempts) {
            ++retries;
            try {
                operation.run();
                if (retries <= 1) break;
                LOGGER.info("Successfully ran '{}' after {} retries", (Object)operation, (Object)(retries - 1));
                break;
            }
            catch (Exception throwable) {
                Exception failure = throwable;
                if (!NetworkingIssueVerifier.isLikelyTransientNetworkingIssue(failure) || retries == this.maxDeployAttempts) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)failure);
                }
                LOGGER.info("Error in '{}'. Waiting {}ms before next retry, {} retries left", new Object[]{operation, backoff, this.maxDeployAttempts - retries});
                LOGGER.debug("Network operation failed", (Throwable)failure);
                try {
                    Thread.sleep(backoff);
                    backoff *= 2;
                }
                catch (InterruptedException e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            }
        }
    }
}

