/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.credentials.Credentials;
import org.gradle.api.file.FileContents;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.provider.BiProvider;
import org.gradle.api.internal.provider.CredentialsProviderFactory;
import org.gradle.api.internal.provider.DefaultProvider;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.internal.provider.ValueSourceProviderFactory;
import org.gradle.api.internal.provider.sources.AbstractPropertyValueSource;
import org.gradle.api.internal.provider.sources.EnvironmentVariableValueSource;
import org.gradle.api.internal.provider.sources.FileBytesValueSource;
import org.gradle.api.internal.provider.sources.FileContentValueSource;
import org.gradle.api.internal.provider.sources.FileTextValueSource;
import org.gradle.api.internal.provider.sources.GradlePropertyValueSource;
import org.gradle.api.internal.provider.sources.SystemPropertyValueSource;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.provider.ValueSource;
import org.gradle.api.provider.ValueSourceParameters;
import org.gradle.api.provider.ValueSourceSpec;
import org.gradle.internal.event.ListenerManager;

public class DefaultProviderFactory
implements ProviderFactory {
    private final CredentialsProviderFactory credentialsProviderFactory;
    @Nullable
    private final ValueSourceProviderFactory valueSourceProviderFactory;

    public DefaultProviderFactory() {
        this(null, null);
    }

    public DefaultProviderFactory(@Nullable ValueSourceProviderFactory valueSourceProviderFactory, @Nullable ListenerManager listenerManager) {
        this.valueSourceProviderFactory = valueSourceProviderFactory;
        this.credentialsProviderFactory = new CredentialsProviderFactory(this);
        if (listenerManager != null) {
            listenerManager.addListener((Object)this.credentialsProviderFactory);
        }
    }

    public <T> Provider<T> provider(Callable<? extends T> value) {
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null");
        }
        return new DefaultProvider<T>(value);
    }

    public Provider<String> environmentVariable(String variableName) {
        return this.environmentVariable(Providers.of(variableName));
    }

    public Provider<String> environmentVariable(Provider<String> variableName) {
        return this.of(EnvironmentVariableValueSource.class, spec -> ((EnvironmentVariableValueSource.Parameters)spec.getParameters()).getVariableName().set(variableName));
    }

    public Provider<String> systemProperty(String propertyName) {
        return this.systemProperty(Providers.of(propertyName));
    }

    public Provider<String> systemProperty(Provider<String> propertyName) {
        return this.of(SystemPropertyValueSource.class, spec -> ((AbstractPropertyValueSource.Parameters)spec.getParameters()).getPropertyName().set(propertyName));
    }

    public Provider<String> gradleProperty(String propertyName) {
        return this.gradleProperty(Providers.of(propertyName));
    }

    public Provider<String> gradleProperty(Provider<String> propertyName) {
        return this.of(GradlePropertyValueSource.class, spec -> ((AbstractPropertyValueSource.Parameters)spec.getParameters()).getPropertyName().set(propertyName));
    }

    public FileContents fileContents(RegularFile file) {
        return this.fileContents((Action<RegularFileProperty>)((Action)property -> property.set((Object)file)));
    }

    public FileContents fileContents(Provider<RegularFile> file) {
        return this.fileContents((Action<RegularFileProperty>)((Action)property -> property.set(file)));
    }

    private FileContents fileContents(final Action<RegularFileProperty> setFileProperty) {
        return new FileContents(){

            public Provider<String> getAsText() {
                return DefaultProviderFactory.this.of(FileTextValueSource.class, spec -> setFileProperty.execute((Object)((FileContentValueSource.Parameters)spec.getParameters()).getFile()));
            }

            public Provider<byte[]> getAsBytes() {
                return DefaultProviderFactory.this.of(FileBytesValueSource.class, spec -> setFileProperty.execute((Object)((FileContentValueSource.Parameters)spec.getParameters()).getFile()));
            }
        };
    }

    public <T, P extends ValueSourceParameters> Provider<T> of(Class<? extends ValueSource<T, P>> valueSourceType, Action<? super ValueSourceSpec<P>> configuration) {
        if (this.valueSourceProviderFactory == null) {
            throw new UnsupportedOperationException();
        }
        return this.valueSourceProviderFactory.createProviderOf(valueSourceType, configuration);
    }

    public <T extends Credentials> Provider<T> credentials(Class<T> credentialsType, String identity) {
        return this.credentialsProviderFactory.provide(credentialsType, identity);
    }

    public <T extends Credentials> Provider<T> credentials(Class<T> credentialsType, Provider<String> identity) {
        return this.credentialsProviderFactory.provide(credentialsType, identity);
    }

    public <A, B, R> Provider<R> zip(Provider<A> left, Provider<B> right, BiFunction<A, B, R> combiner) {
        return new BiProvider<R, A, B>(left, right, combiner);
    }
}

