/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configurationcache;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.api.logging.LogLevel;
import org.gradle.configurationcache.ConfigurationCacheBuild;
import org.gradle.configurationcache.ConfigurationCacheBuildOperationsKt;
import org.gradle.configurationcache.ConfigurationCacheClassLoaderScopeRegistryListener;
import org.gradle.configurationcache.ConfigurationCacheError;
import org.gradle.configurationcache.ConfigurationCacheIO;
import org.gradle.configurationcache.ConfigurationCacheIOKt;
import org.gradle.configurationcache.ConfigurationCacheKey;
import org.gradle.configurationcache.ConfigurationCacheRepository;
import org.gradle.configurationcache.ConfigurationCacheStateFile;
import org.gradle.configurationcache.DefaultConfigurationCache;
import org.gradle.configurationcache.DefaultConfigurationCacheKt;
import org.gradle.configurationcache.SystemPropertyAccessListener;
import org.gradle.configurationcache.VintageGradleBuild;
import org.gradle.configurationcache.fingerprint.ConfigurationCacheFingerprint;
import org.gradle.configurationcache.fingerprint.ConfigurationCacheFingerprintController;
import org.gradle.configurationcache.initialization.ConfigurationCacheBuildEnablement;
import org.gradle.configurationcache.initialization.ConfigurationCacheStartParameter;
import org.gradle.configurationcache.problems.ConfigurationCacheProblems;
import org.gradle.configurationcache.serialization.DefaultReadContext;
import org.gradle.configurationcache.serialization.DefaultWriteContext;
import org.gradle.configurationcache.serialization.IsolateOwner;
import org.gradle.configurationcache.serialization.MutableIsolateContext;
import org.gradle.configurationcache.serialization.codecs.Codecs;
import org.gradle.initialization.ConfigurationCache;
import org.gradle.initialization.GradlePropertiesController;
import org.gradle.internal.Factory;
import org.gradle.internal.classpath.Instrumented;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.vfs.FileSystemAccess;
import org.gradle.internal.watch.vfs.BuildLifecycleAwareVirtualFileSystem;
import org.gradle.util.IncubationLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001YBW\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0002J\b\u00101\u001a\u00020+H\u0016J\u0018\u00102\u001a\n\u0018\u000103j\u0004\u0018\u0001`42\u0006\u00105\u001a\u000206H\u0002J\b\u00107\u001a\u000208H\u0002J\u0018\u00107\u001a\n\u0018\u000103j\u0004\u0018\u0001`42\u0006\u00105\u001a\u000206H\u0002J\u0018\u00107\u001a\n\u0018\u000103j\u0004\u0018\u0001`42\u0006\u00109\u001a\u00020:H\u0002J\u0010\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>H\u0002J\b\u0010?\u001a\u00020<H\u0016J\b\u0010@\u001a\u00020<H\u0002J-\u0010A\u001a\u00020<2\u0006\u0010B\u001a\u0002032\u0016\u0010C\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010E0D\"\u0004\u0018\u00010EH\u0002\u00a2\u0006\u0002\u0010FJ-\u0010G\u001a\u00020<2\u0006\u0010B\u001a\u0002032\u0016\u0010C\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010E0D\"\u0004\u0018\u00010EH\u0002\u00a2\u0006\u0002\u0010FJ\b\u0010H\u001a\u00020<H\u0016J\u0016\u0010I\u001a\u00020<2\f\u0010J\u001a\b\u0012\u0004\u0012\u0002060KH\u0002J\b\u0010L\u001a\u00020<H\u0016J\u0016\u0010M\u001a\u0002HN\"\u0006\b\u0000\u0010N\u0018\u0001H\u0082\b\u00a2\u0006\u0002\u0010OJ\b\u0010P\u001a\u00020<H\u0002J\b\u0010Q\u001a\u00020<H\u0002J\u0010\u0010R\u001a\u00020<2\u0006\u0010=\u001a\u00020>H\u0002J\u0018\u0010S\u001a\u00020<2\u0006\u00105\u001a\u0002062\u0006\u0010T\u001a\u00020UH\u0002J\u0016\u0010V\u001a\b\u0012\u0004\u0012\u0002060K2\u0006\u0010W\u001a\u00020XH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u001b\u0010\u001b\u001a\u00020\u001c8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010!\u001a\u00020\"8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010 \u001a\u0004\b#\u0010$R\u0014\u0010&\u001a\u00020'8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\u00020+8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010,R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Z"}, d2={"Lorg/gradle/configurationcache/DefaultConfigurationCache;", "Lorg/gradle/initialization/ConfigurationCache;", "host", "Lorg/gradle/configurationcache/DefaultConfigurationCache$Host;", "startParameter", "Lorg/gradle/configurationcache/initialization/ConfigurationCacheStartParameter;", "buildEnablement", "Lorg/gradle/configurationcache/initialization/ConfigurationCacheBuildEnablement;", "cacheKey", "Lorg/gradle/configurationcache/ConfigurationCacheKey;", "problems", "Lorg/gradle/configurationcache/problems/ConfigurationCacheProblems;", "systemPropertyListener", "Lorg/gradle/configurationcache/SystemPropertyAccessListener;", "scopeRegistryListener", "Lorg/gradle/configurationcache/ConfigurationCacheClassLoaderScopeRegistryListener;", "cacheIO", "Lorg/gradle/configurationcache/ConfigurationCacheIO;", "gradlePropertiesController", "Lorg/gradle/initialization/GradlePropertiesController;", "fileSystemAccess", "Lorg/gradle/internal/vfs/FileSystemAccess;", "(Lorg/gradle/configurationcache/DefaultConfigurationCache$Host;Lorg/gradle/configurationcache/initialization/ConfigurationCacheStartParameter;Lorg/gradle/configurationcache/initialization/ConfigurationCacheBuildEnablement;Lorg/gradle/configurationcache/ConfigurationCacheKey;Lorg/gradle/configurationcache/problems/ConfigurationCacheProblems;Lorg/gradle/configurationcache/SystemPropertyAccessListener;Lorg/gradle/configurationcache/ConfigurationCacheClassLoaderScopeRegistryListener;Lorg/gradle/configurationcache/ConfigurationCacheIO;Lorg/gradle/initialization/GradlePropertiesController;Lorg/gradle/internal/vfs/FileSystemAccess;)V", "buildOperationExecutor", "Lorg/gradle/internal/operations/BuildOperationExecutor;", "getBuildOperationExecutor", "()Lorg/gradle/internal/operations/BuildOperationExecutor;", "cacheFingerprintController", "Lorg/gradle/configurationcache/fingerprint/ConfigurationCacheFingerprintController;", "getCacheFingerprintController", "()Lorg/gradle/configurationcache/fingerprint/ConfigurationCacheFingerprintController;", "cacheFingerprintController$delegate", "Lkotlin/Lazy;", "cacheRepository", "Lorg/gradle/configurationcache/ConfigurationCacheRepository;", "getCacheRepository", "()Lorg/gradle/configurationcache/ConfigurationCacheRepository;", "cacheRepository$delegate", "configurationCacheLogLevel", "Lorg/gradle/api/logging/LogLevel;", "getConfigurationCacheLogLevel", "()Lorg/gradle/api/logging/LogLevel;", "isConfigurationCacheEnabled", "", "()Z", "cacheFingerprintWriterContextFor", "Lorg/gradle/configurationcache/serialization/DefaultWriteContext;", "outputStream", "Ljava/io/OutputStream;", "canLoad", "checkConfigurationCacheFingerprintFile", "", "Lorg/gradle/configurationcache/fingerprint/InvalidationReason;", "fingerprintFile", "Ljava/io/File;", "checkFingerprint", "Lorg/gradle/configurationcache/ConfigurationCacheRepository$CheckedFingerprint;", "inputStream", "Ljava/io/FileInputStream;", "invalidateConfigurationCacheState", "", "layout", "Lorg/gradle/configurationcache/ConfigurationCacheRepository$Layout;", "load", "loadGradleProperties", "log", "message", "args", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)V", "logBootstrapSummary", "prepareForConfiguration", "registerWatchableBuildDirectories", "buildDirs", "", "save", "service", "T", "()Ljava/lang/Object;", "startCollectingCacheFingerprint", "stopCollectingCacheFingerprint", "writeConfigurationCacheFiles", "writeConfigurationCacheFingerprint", "header", "Lorg/gradle/configurationcache/fingerprint/ConfigurationCacheFingerprint$Header;", "writeConfigurationCacheState", "stateFile", "Lorg/gradle/configurationcache/ConfigurationCacheStateFile;", "Host", "configuration-cache"})
public final class DefaultConfigurationCache
implements ConfigurationCache {
    private final Lazy cacheFingerprintController$delegate;
    private final Lazy cacheRepository$delegate;
    private final Host host;
    private final ConfigurationCacheStartParameter startParameter;
    private final ConfigurationCacheBuildEnablement buildEnablement;
    private final ConfigurationCacheKey cacheKey;
    private final ConfigurationCacheProblems problems;
    private final SystemPropertyAccessListener systemPropertyListener;
    private final ConfigurationCacheClassLoaderScopeRegistryListener scopeRegistryListener;
    private final ConfigurationCacheIO cacheIO;
    private final GradlePropertiesController gradlePropertiesController;
    private final FileSystemAccess fileSystemAccess;

    public boolean canLoad() {
        boolean bl;
        if (!this.isConfigurationCacheEnabled()) {
            bl = false;
        } else if (this.startParameter.getRecreateCache()) {
            this.logBootstrapSummary("Recreating configuration cache", new Object[0]);
            bl = false;
        } else if (this.startParameter.isRefreshDependencies()) {
            this.logBootstrapSummary("Calculating task graph as configuration cache cannot be reused due to {}", "--refresh-dependencies");
            bl = false;
        } else if (this.startParameter.isWriteDependencyLocks()) {
            this.logBootstrapSummary("Calculating task graph as configuration cache cannot be reused due to {}", "--write-locks");
            bl = false;
        } else if (this.startParameter.isUpdateDependencyLocks()) {
            this.logBootstrapSummary("Calculating task graph as configuration cache cannot be reused due to {}", "--update-locks");
            bl = false;
        } else {
            ConfigurationCacheRepository.CheckedFingerprint checkedFingerprint = this.checkFingerprint();
            if (checkedFingerprint instanceof ConfigurationCacheRepository.CheckedFingerprint.NotFound) {
                this.logBootstrapSummary("Calculating task graph as no configuration cache is available for tasks: {}", CollectionsKt.joinToString$default((Iterable)this.startParameter.getRequestedTaskNames(), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
                bl = false;
            } else if (checkedFingerprint instanceof ConfigurationCacheRepository.CheckedFingerprint.Invalid) {
                this.logBootstrapSummary("Calculating task graph as configuration cache cannot be reused because {}.", ((ConfigurationCacheRepository.CheckedFingerprint.Invalid)checkedFingerprint).getReason());
                bl = false;
            } else if (checkedFingerprint instanceof ConfigurationCacheRepository.CheckedFingerprint.Valid) {
                this.logBootstrapSummary("Reusing configuration cache.", new Object[0]);
                bl = true;
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    private final ConfigurationCacheRepository.CheckedFingerprint checkFingerprint() {
        return this.getCacheRepository().useForFingerprintCheck(this.cacheKey.getString(), (Function1<? super File, String>)((Function1)new Function1<File, String>(this){

            @Nullable
            public final String invoke(@NotNull File p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return DefaultConfigurationCache.access$checkFingerprint((DefaultConfigurationCache)this.receiver, p1);
            }
        }));
    }

    public void prepareForConfiguration() {
        if (!this.isConfigurationCacheEnabled()) {
            return;
        }
        this.startCollectingCacheFingerprint();
        Instrumented.setListener((Instrumented.Listener)this.systemPropertyListener);
    }

    public void save() {
        if (!this.isConfigurationCacheEnabled()) {
            return;
        }
        Instrumented.discardListener();
        this.stopCollectingCacheFingerprint();
        ConfigurationCacheBuildOperationsKt.withStoreOperation(this.getBuildOperationExecutor(), (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ DefaultConfigurationCache this$0;

            public final void invoke() {
                DefaultConfigurationCache.access$getCacheRepository$p(this.this$0).useForStore(DefaultConfigurationCache.access$getCacheKey$p(this.this$0).getString(), (Function1<? super ConfigurationCacheRepository.Layout, Unit>)((Function1)new Function1<ConfigurationCacheRepository.Layout, Unit>(this){
                    final /* synthetic */ save.1 this$0;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final void invoke(@NotNull ConfigurationCacheRepository.Layout layout) {
                        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
                        DefaultConfigurationCache.access$getProblems$p(this.this$0.this$0).storing((Function0<Unit>)((Function0)new Function0<Unit>(this, layout){
                            final /* synthetic */ save.1 this$0;
                            final /* synthetic */ ConfigurationCacheRepository.Layout $layout;

                            public final void invoke() {
                                DefaultConfigurationCache.access$invalidateConfigurationCacheState(this.this$0.this$0.this$0, this.$layout);
                            }
                            {
                                this.this$0 = var1_1;
                                this.$layout = layout;
                                super(0);
                            }
                        }));
                        try {
                            DefaultConfigurationCache.access$writeConfigurationCacheFiles(this.this$0.this$0, layout);
                        }
                        catch (ConfigurationCacheError error) {
                            DefaultConfigurationCache.access$invalidateConfigurationCacheState(this.this$0.this$0, layout);
                            DefaultConfigurationCache.access$getProblems$p(this.this$0.this$0).failingBuildDueToSerializationError();
                            throw (Throwable)error;
                        }
                        finally {
                            DefaultConfigurationCache.access$getCacheFingerprintController$p(this.this$0.this$0).stop();
                            DefaultConfigurationCache.access$getScopeRegistryListener$p(this.this$0.this$0).dispose();
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }));
            }
            {
                this.this$0 = defaultConfigurationCache;
                super(0);
            }
        }));
    }

    public void load() {
        boolean bl = this.isConfigurationCacheEnabled();
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        this.problems.loading();
        this.scopeRegistryListener.dispose();
        ConfigurationCacheBuildOperationsKt.withLoadOperation(this.getBuildOperationExecutor(), (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ DefaultConfigurationCache this$0;

            public final void invoke() {
                DefaultConfigurationCache.access$getCacheRepository$p(this.this$0).useForStateLoad(DefaultConfigurationCache.access$getCacheKey$p(this.this$0).getString(), (Function1<? super ConfigurationCacheStateFile, Unit>)((Function1)new Function1<ConfigurationCacheStateFile, Unit>(this){
                    final /* synthetic */ load.1 this$0;

                    public final void invoke(@NotNull ConfigurationCacheStateFile stateFile) {
                        Intrinsics.checkNotNullParameter((Object)stateFile, (String)"stateFile");
                        DefaultConfigurationCache.access$getCacheIO$p(this.this$0.this$0).readRootBuildStateFrom$configuration_cache(stateFile);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }));
            }
            {
                this.this$0 = defaultConfigurationCache;
                super(0);
            }
        }));
    }

    private final void writeConfigurationCacheFiles(ConfigurationCacheRepository.Layout layout) {
        Set<File> includedBuildRootDirs = this.writeConfigurationCacheState(layout.getState());
        this.writeConfigurationCacheFingerprint(layout.getFingerprint(), new ConfigurationCacheFingerprint.Header(includedBuildRootDirs));
    }

    private final Set<File> writeConfigurationCacheState(ConfigurationCacheStateFile stateFile) {
        DefaultConfigurationCache this_$iv = this;
        boolean $i$f$service = false;
        Host $this$service$iv$iv = this_$iv.host;
        boolean $i$f$service2 = false;
        Object object = $this$service$iv$iv.service(ProjectStateRegistry.class).withMutableStateOfAllProjects((Factory)new Factory<Set<? extends File>>(this, stateFile){
            final /* synthetic */ DefaultConfigurationCache this$0;
            final /* synthetic */ ConfigurationCacheStateFile $stateFile;

            @Nullable
            public final Set<File> create() {
                return DefaultConfigurationCache.access$getCacheIO$p(this.this$0).writeRootBuildStateTo$configuration_cache(this.$stateFile);
            }
            {
                this.this$0 = defaultConfigurationCache;
                this.$stateFile = configurationCacheStateFile;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"service<ProjectStateRegi\u2026To(stateFile) }\n        )");
        return (Set)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeConfigurationCacheFingerprint(File fingerprintFile, ConfigurationCacheFingerprint.Header header) {
        Object object = fingerprintFile;
        boolean bl = false;
        object = new FileOutputStream((File)object);
        bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            FileOutputStream outputStream = (FileOutputStream)object;
            boolean bl3 = false;
            ConfigurationCacheIOKt.writeConfigurationCacheFingerprintHeaderTo(outputStream, header);
            this.getCacheFingerprintController().commitFingerprintTo(outputStream);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    private final void startCollectingCacheFingerprint() {
        this.getCacheFingerprintController().startCollectingFingerprint((Function1<? super OutputStream, DefaultWriteContext>)((Function1)new Function1<OutputStream, DefaultWriteContext>(this){
            final /* synthetic */ DefaultConfigurationCache this$0;

            @NotNull
            public final DefaultWriteContext invoke(@NotNull OutputStream it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return DefaultConfigurationCache.access$cacheFingerprintWriterContextFor(this.this$0, it);
            }
            {
                this.this$0 = defaultConfigurationCache;
                super(1);
            }
        }));
    }

    private final void stopCollectingCacheFingerprint() {
        this.getCacheFingerprintController().stopCollectingFingerprint();
    }

    /*
     * WARNING - void declaration
     */
    private final DefaultWriteContext cacheFingerprintWriterContextFor(OutputStream outputStream) {
        void context;
        Pair<DefaultWriteContext, Codecs> pair = this.cacheIO.writerContextFor$configuration_cache(outputStream, "fingerprint");
        DefaultWriteContext defaultWriteContext = (DefaultWriteContext)pair.component1();
        Codecs codecs = (Codecs)pair.component2();
        pair = context;
        boolean bl = false;
        boolean bl2 = false;
        Pair<DefaultWriteContext, Codecs> $this$apply = pair;
        boolean bl3 = false;
        $this$apply.push(new IsolateOwner.OwnerHost(this.host), codecs.getUserTypesCodec());
        return pair;
    }

    private final String checkFingerprint(File fingerprintFile) {
        this.loadGradleProperties();
        return this.checkConfigurationCacheFingerprintFile(fingerprintFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String checkConfigurationCacheFingerprintFile(File fingerprintFile) {
        String string2;
        Object object = fingerprintFile;
        boolean bl = false;
        object = new FileInputStream((File)object);
        bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            FileInputStream fingerprintInputStream = (FileInputStream)object;
            boolean bl3 = false;
            ConfigurationCacheFingerprint.Header header = ConfigurationCacheIOKt.readConfigurationCacheFingerprintHeaderFrom(fingerprintInputStream);
            if (header != null) {
                ConfigurationCacheFingerprint.Header header2 = header;
                boolean bl4 = false;
                boolean bl5 = false;
                ConfigurationCacheFingerprint.Header $this$run = header2;
                boolean bl6 = false;
                this.registerWatchableBuildDirectories($this$run.getIncludedBuildRootDirs());
            }
            string2 = this.checkFingerprint(fingerprintInputStream);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        return string2;
    }

    private final String checkFingerprint(FileInputStream inputStream) {
        return (String)this.cacheIO.withReadContextFor$configuration_cache(inputStream, (Function3)new Function3<DefaultReadContext, Codecs, Continuation<? super String>, Object>(this, null){
            private /* synthetic */ Object L$0;
            private /* synthetic */ Object L$1;
            int label;
            final /* synthetic */ DefaultConfigurationCache this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var16_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$withReadContextFor = (DefaultReadContext)this.L$0;
                        codecs = (Codecs)this.L$1;
                        var4_5 = $this$withReadContextFor;
                        var5_6 = new IsolateOwner.OwnerHost(DefaultConfigurationCache.access$getHost$p(this.this$0));
                        codec$iv = codecs.getUserTypesCodec();
                        $i$f$withIsolate = false;
                        $this$withIsolate$iv.push((IsolateOwner)owner$iv, codec$iv);
                        $this$withIsolate = (DefaultReadContext)$this$withIsolate$iv;
                        $i$a$-withIsolate-DefaultConfigurationCache$checkFingerprint$2$1 = false;
                        var10_13 = DefaultConfigurationCache.access$getCacheFingerprintController$p(this.this$0);
                        var11_14 = false;
                        var12_15 = false;
                        $this$run = var10_13;
                        $i$a$-run-DefaultConfigurationCache$checkFingerprint$2$1$1 = false;
                        this.L$0 = $this$withIsolate$iv;
                        this.label = 1;
                        v0 = $this$run.checkFingerprint($this$withIsolate, (Continuation<? super String>)this);
                        ** if (v0 != var16_2) goto lbl26
lbl25:
                        // 1 sources

                        return var16_2;
lbl26:
                        // 1 sources

                        ** GOTO lbl37
                    }
                    case 1: {
                        $i$f$withIsolate = false;
                        $i$a$-withIsolate-DefaultConfigurationCache$checkFingerprint$2$1 = false;
                        $i$a$-run-DefaultConfigurationCache$checkFingerprint$2$1$1 = false;
                        $this$withIsolate$iv = (MutableIsolateContext)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl37:
                            // 2 sources

                            var15_19 = (String)v0;
                        }
                        catch (Throwable var15_20) {
                            throw var15_20;
                        }
                        finally {
                            $this$withIsolate$iv.pop();
                        }
                        return var15_19;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = defaultConfigurationCache;
                super(3, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull DefaultReadContext $this$create, @NotNull Codecs codecs, @NotNull Continuation<? super String> continuation) {
                Intrinsics.checkNotNullParameter((Object)$this$create, (String)"$this$create");
                Intrinsics.checkNotNullParameter((Object)codecs, (String)"codecs");
                Intrinsics.checkNotNullParameter(continuation, (String)"continuation");
                Function3<DefaultReadContext, Codecs, Continuation<? super String>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                Object object = function3.L$0 = $this$create;
                Object object2 = function3.L$1 = codecs;
                return function3;
            }

            public final Object invoke(Object object, Object object2, Object object3) {
                return (this.create((DefaultReadContext)object, (Codecs)object2, (Continuation<? super String>)((Continuation)object3))).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    private final ConfigurationCacheFingerprintController getCacheFingerprintController() {
        Lazy lazy = this.cacheFingerprintController$delegate;
        DefaultConfigurationCache defaultConfigurationCache = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ConfigurationCacheFingerprintController)lazy.getValue();
    }

    private final ConfigurationCacheRepository getCacheRepository() {
        Lazy lazy = this.cacheRepository$delegate;
        DefaultConfigurationCache defaultConfigurationCache = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ConfigurationCacheRepository)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void registerWatchableBuildDirectories(Set<? extends File> buildDirs) {
        Iterable iterable = buildDirs;
        boolean bl = false;
        if (!iterable.isEmpty()) {
            void $this$forEach$iv;
            iterable = buildDirs;
            DefaultConfigurationCache this_$iv = this;
            boolean $i$f$service = false;
            Host $this$service$iv$iv = this_$iv.host;
            boolean $i$f$service2 = false;
            BuildLifecycleAwareVirtualFileSystem buildLifecycleAwareVirtualFileSystem = $this$service$iv$iv.service(BuildLifecycleAwareVirtualFileSystem.class);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File p1 = (File)element$iv;
                boolean bl2 = false;
                buildLifecycleAwareVirtualFileSystem.registerWatchableHierarchy(p1);
            }
        }
    }

    private final void loadGradleProperties() {
        this.gradlePropertiesController.loadGradlePropertiesFrom(this.startParameter.getSettingsDirectory());
    }

    private final void invalidateConfigurationCacheState(ConfigurationCacheRepository.Layout layout) {
        layout.getFingerprint().delete();
    }

    private final void logBootstrapSummary(String message2, Object ... args) {
        if (!this.startParameter.isQuiet()) {
            IncubationLogger.incubatingFeatureUsed((String)"Configuration cache");
        }
        this.log(message2, Arrays.copyOf(args, args.length));
    }

    private final void log(String message2, Object ... args) {
        DefaultConfigurationCacheKt.getLogger().log(this.getConfigurationCacheLogLevel(), message2, Arrays.copyOf(args, args.length));
    }

    private final BuildOperationExecutor getBuildOperationExecutor() {
        DefaultConfigurationCache this_$iv = this;
        boolean $i$f$service = false;
        Host $this$service$iv$iv = this_$iv.host;
        boolean $i$f$service2 = false;
        return $this$service$iv$iv.service(BuildOperationExecutor.class);
    }

    private final /* synthetic */ <T> T service() {
        int $i$f$service = 0;
        Host $this$service$iv = this.host;
        boolean $i$f$service2 = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return (T)$this$service$iv.service(Object.class);
    }

    private final boolean isConfigurationCacheEnabled() {
        return this.buildEnablement.isEnabledForCurrentBuild();
    }

    private final LogLevel getConfigurationCacheLogLevel() {
        boolean bl = this.startParameter.isQuiet();
        return bl ? LogLevel.INFO : LogLevel.LIFECYCLE;
    }

    public DefaultConfigurationCache(@NotNull Host host, @NotNull ConfigurationCacheStartParameter startParameter, @NotNull ConfigurationCacheBuildEnablement buildEnablement, @NotNull ConfigurationCacheKey cacheKey, @NotNull ConfigurationCacheProblems problems, @NotNull SystemPropertyAccessListener systemPropertyListener, @NotNull ConfigurationCacheClassLoaderScopeRegistryListener scopeRegistryListener, @NotNull ConfigurationCacheIO cacheIO, @NotNull GradlePropertiesController gradlePropertiesController, @NotNull FileSystemAccess fileSystemAccess) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)startParameter, (String)"startParameter");
        Intrinsics.checkNotNullParameter((Object)buildEnablement, (String)"buildEnablement");
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        Intrinsics.checkNotNullParameter((Object)problems, (String)"problems");
        Intrinsics.checkNotNullParameter((Object)systemPropertyListener, (String)"systemPropertyListener");
        Intrinsics.checkNotNullParameter((Object)scopeRegistryListener, (String)"scopeRegistryListener");
        Intrinsics.checkNotNullParameter((Object)cacheIO, (String)"cacheIO");
        Intrinsics.checkNotNullParameter((Object)gradlePropertiesController, (String)"gradlePropertiesController");
        Intrinsics.checkNotNullParameter((Object)fileSystemAccess, (String)"fileSystemAccess");
        this.host = host;
        this.startParameter = startParameter;
        this.buildEnablement = buildEnablement;
        this.cacheKey = cacheKey;
        this.problems = problems;
        this.systemPropertyListener = systemPropertyListener;
        this.scopeRegistryListener = scopeRegistryListener;
        this.cacheIO = cacheIO;
        this.gradlePropertiesController = gradlePropertiesController;
        this.fileSystemAccess = fileSystemAccess;
        this.cacheFingerprintController$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ConfigurationCacheFingerprintController>(this){
            final /* synthetic */ DefaultConfigurationCache this$0;

            @NotNull
            public final ConfigurationCacheFingerprintController invoke() {
                DefaultConfigurationCache this_$iv = this.this$0;
                boolean $i$f$service = false;
                Host $this$service$iv$iv = DefaultConfigurationCache.access$getHost$p(this_$iv);
                boolean $i$f$service2 = false;
                return $this$service$iv$iv.service(ConfigurationCacheFingerprintController.class);
            }
            {
                this.this$0 = defaultConfigurationCache;
                super(0);
            }
        }));
        this.cacheRepository$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ConfigurationCacheRepository>(this){
            final /* synthetic */ DefaultConfigurationCache this$0;

            @NotNull
            public final ConfigurationCacheRepository invoke() {
                DefaultConfigurationCache this_$iv = this.this$0;
                boolean $i$f$service = false;
                Host $this$service$iv$iv = DefaultConfigurationCache.access$getHost$p(this_$iv);
                boolean $i$f$service2 = false;
                return $this$service$iv$iv.service(ConfigurationCacheRepository.class);
            }
            {
                this.this$0 = defaultConfigurationCache;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ String access$checkFingerprint(DefaultConfigurationCache $this, File fingerprintFile) {
        return $this.checkFingerprint(fingerprintFile);
    }

    public static final /* synthetic */ ConfigurationCacheRepository access$getCacheRepository$p(DefaultConfigurationCache $this) {
        return $this.getCacheRepository();
    }

    public static final /* synthetic */ ConfigurationCacheKey access$getCacheKey$p(DefaultConfigurationCache $this) {
        return $this.cacheKey;
    }

    public static final /* synthetic */ ConfigurationCacheProblems access$getProblems$p(DefaultConfigurationCache $this) {
        return $this.problems;
    }

    public static final /* synthetic */ void access$invalidateConfigurationCacheState(DefaultConfigurationCache $this, ConfigurationCacheRepository.Layout layout) {
        $this.invalidateConfigurationCacheState(layout);
    }

    public static final /* synthetic */ void access$writeConfigurationCacheFiles(DefaultConfigurationCache $this, ConfigurationCacheRepository.Layout layout) {
        $this.writeConfigurationCacheFiles(layout);
    }

    public static final /* synthetic */ ConfigurationCacheFingerprintController access$getCacheFingerprintController$p(DefaultConfigurationCache $this) {
        return $this.getCacheFingerprintController();
    }

    public static final /* synthetic */ ConfigurationCacheClassLoaderScopeRegistryListener access$getScopeRegistryListener$p(DefaultConfigurationCache $this) {
        return $this.scopeRegistryListener;
    }

    public static final /* synthetic */ ConfigurationCacheIO access$getCacheIO$p(DefaultConfigurationCache $this) {
        return $this.cacheIO;
    }

    public static final /* synthetic */ DefaultWriteContext access$cacheFingerprintWriterContextFor(DefaultConfigurationCache $this, OutputStream outputStream) {
        return $this.cacheFingerprintWriterContextFor(outputStream);
    }

    public static final /* synthetic */ Object access$service(DefaultConfigurationCache $this) {
        return $this.service();
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&J\"\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\f0\u000b\"\u0004\b\u0000\u0010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\u000eH&J!\u0010\u000f\u001a\u0002H\f\"\u0004\b\u0000\u0010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\u000eH&\u00a2\u0006\u0002\u0010\u0010R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0011"}, d2={"Lorg/gradle/configurationcache/DefaultConfigurationCache$Host;", "", "currentBuild", "Lorg/gradle/configurationcache/VintageGradleBuild;", "getCurrentBuild", "()Lorg/gradle/configurationcache/VintageGradleBuild;", "createBuild", "Lorg/gradle/configurationcache/ConfigurationCacheBuild;", "rootProjectName", "", "factory", "Lorg/gradle/internal/Factory;", "T", "serviceType", "Ljava/lang/Class;", "service", "(Ljava/lang/Class;)Ljava/lang/Object;", "configuration-cache"})
    public static interface Host {
        @NotNull
        public VintageGradleBuild getCurrentBuild();

        @NotNull
        public ConfigurationCacheBuild createBuild(@NotNull String var1);

        public <T> T service(@NotNull Class<T> var1);

        @NotNull
        public <T> Factory<T> factory(@NotNull Class<T> var1);
    }
}

