/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.std;

import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public class IncludeExcludePredicate<T>
implements Predicate<T> {
    private final Set<T> includes;
    private final Set<T> excludes;

    public static <T> IncludeExcludePredicate<T> of(@Nullable Set<T> includes, @Nullable Set<T> excludes) {
        return new IncludeExcludePredicate<T>(includes, excludes);
    }

    public static <T> IncludeExcludePredicate<T> acceptAll() {
        return new IncludeExcludePredicate<T>(null, null);
    }

    private IncludeExcludePredicate(@Nullable Set<T> includes, @Nullable Set<T> excludes) {
        this.includes = includes;
        this.excludes = excludes;
    }

    @Override
    public boolean test(T value) {
        if (this.includes != null && !this.includes.contains(value)) {
            return false;
        }
        return this.excludes == null || !this.excludes.contains(value);
    }
}

