/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilder;
import org.gradle.buildinit.plugins.internal.InitSettings;
import org.gradle.buildinit.plugins.internal.LanguageLibraryProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.TemplateFactory;
import org.gradle.buildinit.plugins.internal.TemplateLibraryVersionProvider;
import org.gradle.buildinit.plugins.internal.model.Description;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitTestFramework;
import org.gradle.buildinit.plugins.internal.modifiers.Language;
import org.gradle.buildinit.plugins.internal.modifiers.ModularizationOption;

public abstract class JvmProjectInitDescriptor
extends LanguageLibraryProjectInitDescriptor {
    protected final Description description;
    protected final TemplateLibraryVersionProvider libraryVersionProvider;
    private final DocumentationRegistry documentationRegistry;

    public JvmProjectInitDescriptor(Description description, TemplateLibraryVersionProvider libraryVersionProvider, DocumentationRegistry documentationRegistry) {
        this.description = description;
        this.libraryVersionProvider = libraryVersionProvider;
        this.documentationRegistry = documentationRegistry;
    }

    protected boolean isSingleProject(InitSettings settings) {
        return settings.getModularizationOption() == ModularizationOption.SINGLE_PROJECT;
    }

    protected String applicationConventionPlugin(InitSettings settings) {
        return settings.getPackageName() + "." + this.getLanguage().getName() + "-application-conventions";
    }

    protected String libraryConventionPlugin(InitSettings settings) {
        return settings.getPackageName() + "." + this.getLanguage().getName() + "-library-conventions";
    }

    private String commonConventionPlugin(InitSettings settings) {
        return settings.getPackageName() + "." + this.getLanguage().getName() + "-common-conventions";
    }

    @Override
    public String getId() {
        return this.getLanguage().getName() + "-" + this.getComponentType().toString();
    }

    @Override
    public Language getLanguage() {
        return this.description.getLanguage();
    }

    @Override
    public boolean supportsPackage() {
        return true;
    }

    @Override
    public BuildInitTestFramework getDefaultTestFramework() {
        return this.description.getDefaultTestFramework();
    }

    @Override
    public Set<BuildInitTestFramework> getTestFrameworks() {
        return this.description.getSupportedTestFrameworks();
    }

    @Override
    public Optional<String> getFurtherReading(InitSettings settings) {
        String multi = this.isSingleProject(settings) ? "" : "_multi_project";
        return Optional.of(this.documentationRegistry.getSampleFor("building_" + this.getLanguage().getName() + "_" + this.getComponentType().pluralName() + multi));
    }

    @Override
    public void generateProjectBuildScript(String projectName, InitSettings settings, BuildScriptBuilder buildScriptBuilder) {
        if (this.isSingleProject(settings)) {
            this.addJcenter(buildScriptBuilder);
            String languagePlugin = this.description.getPluginName();
            if (languagePlugin != null) {
                String pluginVersionProperty = this.description.getPluginVersionProperty();
                String pluginVersion = pluginVersionProperty == null ? null : this.libraryVersionProvider.getVersion(pluginVersionProperty);
                buildScriptBuilder.plugin("Apply the " + languagePlugin + " Plugin to add support for " + this.getLanguage() + ".", languagePlugin, pluginVersion);
            }
            buildScriptBuilder.fileComment("This generated file contains a sample " + this.getLanguage() + " " + (Object)((Object)this.getComponentType()) + " project to get you started.");
            buildScriptBuilder.fileComment("For more details take a look at the 'Building Java & JVM projects' chapter in the Gradle").fileComment("User Manual available at " + this.documentationRegistry.getDocumentationFor("building_java_projects"));
            this.addStandardDependencies(buildScriptBuilder, false);
            this.addTestFramework(settings.getTestFramework(), buildScriptBuilder);
        }
    }

    @Override
    public void generateConventionPluginBuildScript(String conventionPluginName, InitSettings settings, BuildScriptBuilder buildScriptBuilder) {
        if ("common".equals(conventionPluginName)) {
            this.addJcenter(buildScriptBuilder);
            String languagePlugin = this.description.getPluginName() == null ? "java" : this.description.getPluginName();
            buildScriptBuilder.plugin("Apply the " + languagePlugin + " Plugin to add support for " + this.getLanguage() + ".", languagePlugin);
            this.addStandardDependencies(buildScriptBuilder, true);
            this.addDependencyConstraints(buildScriptBuilder);
            this.addTestFramework(settings.getTestFramework(), buildScriptBuilder);
        } else {
            buildScriptBuilder.plugin("Apply the common convention plugin for shared build configuration between library and application projects.", this.commonConventionPlugin(settings));
            if ("library".equals(conventionPluginName)) {
                this.applyLibraryPlugin(buildScriptBuilder);
            }
            if ("application".equals(conventionPluginName)) {
                this.applyApplicationPlugin(buildScriptBuilder);
            }
        }
    }

    @Override
    public void generateSources(InitSettings settings, TemplateFactory templateFactory) {
        for (String subproject : settings.getSubprojects()) {
            ArrayList<String> sourceTemplates = new ArrayList<String>();
            ArrayList<String> testSourceTemplates = new ArrayList<String>();
            this.sourceTemplates(subproject, settings, templateFactory, sourceTemplates);
            this.testSourceTemplates(subproject, settings, templateFactory, testSourceTemplates);
            templateFactory.whenNoSourcesAvailable(subproject, Stream.concat(sourceTemplates.stream().map(t -> templateFactory.fromSourceTemplate(this.templatePath((String)t), "main", subproject, this.templateLanguage((String)t))), testSourceTemplates.stream().map(t -> templateFactory.fromSourceTemplate(this.templatePath((String)t), "test", subproject, this.templateLanguage((String)t)))).collect(Collectors.toList())).generate();
        }
    }

    private String templatePath(String baseFileName) {
        return this.getLanguage().getName() + this.getComponentType().toString() + "/" + baseFileName + "." + this.templateLanguage(baseFileName).getExtension() + ".template";
    }

    private Language templateLanguage(String baseFileName) {
        if (baseFileName.startsWith("groovy/")) {
            return Language.GROOVY;
        }
        return this.getLanguage();
    }

    protected abstract void sourceTemplates(String var1, InitSettings var2, TemplateFactory var3, List<String> var4);

    protected abstract void testSourceTemplates(String var1, InitSettings var2, TemplateFactory var3, List<String> var4);

    protected void applyApplicationPlugin(BuildScriptBuilder buildScriptBuilder) {
        buildScriptBuilder.plugin("Apply the application plugin to add support for building a CLI application in Java.", "application");
    }

    protected void applyLibraryPlugin(BuildScriptBuilder buildScriptBuilder) {
        buildScriptBuilder.plugin("Apply the java-library plugin for API and implementation separation.", "java-library");
    }

    private void addJcenter(BuildScriptBuilder buildScriptBuilder) {
        buildScriptBuilder.repositories().jcenter("Use JCenter for resolving dependencies.");
    }

    private void addStandardDependencies(BuildScriptBuilder buildScriptBuilder, boolean constraintsDefined) {
        if (this.getLanguage() == Language.GROOVY) {
            String groovyVersion = this.libraryVersionProvider.getVersion("groovy");
            String groovyAllCoordinates = constraintsDefined ? "org.codehaus.groovy:groovy-all" : "org.codehaus.groovy:groovy-all:" + groovyVersion;
            buildScriptBuilder.implementationDependency("Use the latest Groovy version for building this library", groovyAllCoordinates);
        }
        if (this.getLanguage() == Language.KOTLIN) {
            buildScriptBuilder.dependencies().platformDependency("implementation", "Align versions of all Kotlin components", "org.jetbrains.kotlin:kotlin-bom");
            buildScriptBuilder.implementationDependency("Use the Kotlin JDK 8 standard library.", "org.jetbrains.kotlin:kotlin-stdlib-jdk8");
        }
        if (this.getLanguage() == Language.SCALA) {
            String scalaVersion = this.libraryVersionProvider.getVersion("scala");
            String scalaLibraryVersion = this.libraryVersionProvider.getVersion("scala-library");
            String scalaCoordinates = constraintsDefined ? "org.scala-lang:scala-library" : "org.scala-lang:scala-library:" + scalaLibraryVersion;
            buildScriptBuilder.implementationDependency("Use Scala " + scalaVersion + " in our library project", scalaCoordinates);
        }
    }

    private void addDependencyConstraints(BuildScriptBuilder buildScriptBuilder) {
        String commonsTextVersion = this.libraryVersionProvider.getVersion("commons-text");
        buildScriptBuilder.implementationDependencyConstraint("Define dependency versions as constraints", "org.apache.commons:commons-text:" + commonsTextVersion);
        if (this.getLanguage() == Language.GROOVY) {
            buildScriptBuilder.implementationDependencyConstraint(null, "org.codehaus.groovy:groovy-all:" + this.libraryVersionProvider.getVersion("groovy"));
        }
        if (this.getLanguage() == Language.KOTLIN) {
            buildScriptBuilder.dependencies().platformDependency("implementation", "Align versions of all Kotlin components", "org.jetbrains.kotlin:kotlin-bom");
            buildScriptBuilder.implementationDependencyConstraint(null, "org.jetbrains.kotlin:kotlin-stdlib-jdk8");
        }
        if (this.getLanguage() == Language.SCALA) {
            String scalaLibraryVersion = this.libraryVersionProvider.getVersion("scala-library");
            buildScriptBuilder.implementationDependencyConstraint(null, "org.scala-lang:scala-library:" + scalaLibraryVersion);
        }
    }

    private void addTestFramework(BuildInitTestFramework testFramework, BuildScriptBuilder buildScriptBuilder) {
        switch (testFramework) {
            case SPOCK: {
                if (this.getLanguage() != Language.GROOVY) {
                    buildScriptBuilder.plugin("Apply the groovy plugin to also add support for Groovy (needed for Spock)", "groovy").testImplementationDependency("Use the latest Groovy version for Spock testing", "org.codehaus.groovy:groovy-all:" + this.libraryVersionProvider.getVersion("groovy"));
                }
                buildScriptBuilder.testImplementationDependency("Use the awesome Spock testing and specification framework even with Java", "org.spockframework:spock-core:" + this.libraryVersionProvider.getVersion("spock"), "junit:junit:" + this.libraryVersionProvider.getVersion("junit"));
                break;
            }
            case TESTNG: {
                buildScriptBuilder.testImplementationDependency("Use TestNG framework, also requires calling test.useTestNG() below", "org.testng:testng:" + this.libraryVersionProvider.getVersion("testng")).taskMethodInvocation("Use TestNG for unit tests.", "test", "Test", "useTestNG", new Object[0]);
                break;
            }
            case JUNIT_JUPITER: {
                buildScriptBuilder.testImplementationDependency("Use JUnit Jupiter API for testing.", "org.junit.jupiter:junit-jupiter-api:" + this.libraryVersionProvider.getVersion("junit-jupiter")).testRuntimeOnlyDependency("Use JUnit Jupiter Engine for testing.", "org.junit.jupiter:junit-jupiter-engine").taskMethodInvocation("Use junit platform for unit tests.", "test", "Test", "useJUnitPlatform", new Object[0]);
                break;
            }
            case SCALATEST: {
                String scalaVersion = this.libraryVersionProvider.getVersion("scala");
                String scalaTestVersion = this.libraryVersionProvider.getVersion("scalatest");
                String scalaTestPlusJunitVersion = this.libraryVersionProvider.getVersion("scalatestplus-junit");
                String junitVersion = this.libraryVersionProvider.getVersion("scala-junit");
                String scalaXmlVersion = this.libraryVersionProvider.getVersion("scala-xml");
                buildScriptBuilder.testImplementationDependency("Use Scalatest for testing our library", "junit:junit:" + junitVersion, "org.scalatest:scalatest_" + scalaVersion + ":" + scalaTestVersion, "org.scalatestplus:junit-4-12_" + scalaVersion + ":" + scalaTestPlusJunitVersion).testRuntimeOnlyDependency("Need scala-xml at test runtime", "org.scala-lang.modules:scala-xml_" + scalaVersion + ":" + scalaXmlVersion);
                break;
            }
            case KOTLINTEST: {
                buildScriptBuilder.testImplementationDependency("Use the Kotlin test library.", "org.jetbrains.kotlin:kotlin-test").testImplementationDependency("Use the Kotlin JUnit integration.", "org.jetbrains.kotlin:kotlin-test-junit");
                break;
            }
            default: {
                buildScriptBuilder.testImplementationDependency("Use JUnit test framework.", "junit:junit:" + this.libraryVersionProvider.getVersion("junit"));
            }
        }
    }
}

