/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.archive.ZipEntry;
import org.gradle.api.internal.file.archive.ZipInput;
import org.gradle.api.internal.file.archive.impl.FileZipInput;
import org.gradle.internal.Pair;
import org.gradle.internal.classpath.CachedClasspathTransformer;
import org.gradle.internal.classpath.ClasspathBuilder;
import org.gradle.internal.classpath.ClasspathFileTransformer;
import org.gradle.internal.classpath.ClasspathWalker;
import org.gradle.internal.file.FileException;
import org.gradle.internal.file.FileType;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.util.GFileUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InstrumentingClasspathFileTransformer
implements ClasspathFileTransformer {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstrumentingClasspathFileTransformer.class);
    private final ClasspathWalker classpathWalker;
    private final ClasspathBuilder classpathBuilder;
    private final CachedClasspathTransformer.Transform transform;
    private final HashCode configHash;

    public InstrumentingClasspathFileTransformer(ClasspathWalker classpathWalker, ClasspathBuilder classpathBuilder, CachedClasspathTransformer.Transform transform) {
        this.classpathWalker = classpathWalker;
        this.classpathBuilder = classpathBuilder;
        this.transform = transform;
        Hasher hasher = Hashing.defaultFunction().newHasher();
        transform.applyConfigurationTo(hasher);
        this.configHash = hasher.hash();
    }

    @Override
    public File transform(File source, FileSystemLocationSnapshot sourceSnapshot, File cacheDir) {
        String name = sourceSnapshot.getType() == FileType.Directory ? source.getName() + ".jar" : source.getName();
        Hasher hasher = Hashing.defaultFunction().newHasher();
        hasher.putHash(this.configHash);
        hasher.putHash(sourceSnapshot.getHash());
        HashCode fileHash = hasher.hash();
        File transformed = new File(cacheDir, fileHash.toString() + '/' + name);
        if (!transformed.isFile()) {
            this.transform(source, transformed);
        }
        return transformed;
    }

    private void transform(File source, File dest) {
        if (this.isSignedJar(source)) {
            LOGGER.debug("Signed archive '{}'. Skipping instrumentation.", (Object)source.getName());
            GFileUtils.copyFile((File)source, (File)dest);
        } else {
            this.instrument(source, dest);
        }
    }

    private void instrument(File source, File dest) {
        this.classpathBuilder.jar(dest, builder -> {
            try {
                this.visitEntries(source, builder);
            }
            catch (FileException e) {
                LOGGER.debug("Malformed archive '{}'. Discarding contents.", (Object)source.getName(), (Object)e);
            }
        });
    }

    private void visitEntries(File source, ClasspathBuilder.EntryBuilder builder) throws IOException, FileException {
        this.classpathWalker.visit(source, entry -> {
            if (entry.getName().endsWith(".class")) {
                ClassReader reader = new ClassReader(entry.getContent());
                ClassWriter classWriter = new ClassWriter(1);
                Pair<RelativePath, ClassVisitor> chain = this.transform.apply(entry, (ClassVisitor)classWriter);
                reader.accept((ClassVisitor)chain.right, 0);
                byte[] bytes = classWriter.toByteArray();
                builder.put(((RelativePath)chain.left).getPathString(), bytes);
            } else {
                builder.put(entry.getName(), entry.getContent());
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isSignedJar(File source) {
        if (!source.isFile()) {
            return false;
        }
        try (ZipInput entries2 = FileZipInput.create((File)source);){
            ZipEntry entry;
            String entryName;
            Iterator iterator = entries2.iterator();
            do {
                if (!iterator.hasNext()) return false;
            } while (!(entryName = (entry = (ZipEntry)iterator.next()).getName()).startsWith("META-INF/") || !entryName.endsWith(".SF"));
            boolean bl = true;
            return bl;
        }
        catch (FileException entries2) {
            return false;
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }
}

