/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.ir.declarations.MetadataSource;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\bf\u0018\u00002\u00020\u0001:\u0005\u0006\u0007\b\t\nR\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/fir/backend/FirMetadataSource;", "Lorg/jetbrains/kotlin/ir/declarations/MetadataSource;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "Class", "File", "Function", "Property", "Variable", "fir2ir"})
public interface FirMetadataSource
extends MetadataSource {
    @NotNull
    public FirSession getSession();

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/backend/FirMetadataSource$File;", "Lorg/jetbrains/kotlin/ir/declarations/MetadataSource$File;", "Lorg/jetbrains/kotlin/fir/backend/FirMetadataSource;", "file", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/fir/declarations/FirFile;Lorg/jetbrains/kotlin/fir/FirSession;)V", "getFile", "()Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "fir2ir"})
    public static final class File
    extends MetadataSource.File
    implements FirMetadataSource {
        private final FirFile file;
        private final FirSession session;

        @NotNull
        public final FirFile getFile() {
            return this.file;
        }

        @Override
        @NotNull
        public FirSession getSession() {
            return this.session;
        }

        public File(@NotNull FirFile file2, @NotNull FirSession session2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            super(CollectionsKt.emptyList());
            this.file = file2;
            this.session = session2;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/backend/FirMetadataSource$Class;", "Lorg/jetbrains/kotlin/fir/backend/FirMetadataSource;", "klass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "(Lorg/jetbrains/kotlin/fir/declarations/FirClass;)V", "getKlass", "()Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "name", "Lorg/jetbrains/kotlin/name/Name;", "getName", "()Lorg/jetbrains/kotlin/name/Name;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "fir2ir"})
    public static final class Class
    implements FirMetadataSource {
        private final FirClass<?> klass;

        @Override
        @NotNull
        public FirSession getSession() {
            return this.klass.getSession();
        }

        @Override
        @Nullable
        public Name getName() {
            FirClass<?> firClass = this.klass;
            if (!(firClass instanceof FirRegularClass)) {
                firClass = null;
            }
            FirRegularClass firRegularClass = (FirRegularClass)firClass;
            return firRegularClass != null ? firRegularClass.getName() : null;
        }

        @NotNull
        public final FirClass<?> getKlass() {
            return this.klass;
        }

        public Class(@NotNull FirClass<?> klass) {
            Intrinsics.checkNotNullParameter(klass, (String)"klass");
            this.klass = klass;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/backend/FirMetadataSource$Function;", "Lorg/jetbrains/kotlin/fir/backend/FirMetadataSource;", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "(Lorg/jetbrains/kotlin/fir/declarations/FirFunction;)V", "getFunction", "()Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "name", "Lorg/jetbrains/kotlin/name/Name;", "getName", "()Lorg/jetbrains/kotlin/name/Name;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "fir2ir"})
    public static final class Function
    implements FirMetadataSource {
        private final FirFunction<?> function;

        @Override
        @NotNull
        public FirSession getSession() {
            return this.function.getSession();
        }

        @Override
        @Nullable
        public Name getName() {
            FirFunction<?> firFunction = this.function;
            return firFunction instanceof FirSimpleFunction ? ((FirSimpleFunction)this.function).getName() : (firFunction instanceof FirConstructor ? Name.special("<init>") : null);
        }

        @NotNull
        public final FirFunction<?> getFunction() {
            return this.function;
        }

        public Function(@NotNull FirFunction<?> function2) {
            Intrinsics.checkNotNullParameter(function2, (String)"function");
            this.function = function2;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/backend/FirMetadataSource$Property;", "Lorg/jetbrains/kotlin/fir/backend/FirMetadataSource;", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "(Lorg/jetbrains/kotlin/fir/declarations/FirProperty;)V", "name", "Lorg/jetbrains/kotlin/name/Name;", "getName", "()Lorg/jetbrains/kotlin/name/Name;", "getProperty", "()Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "fir2ir"})
    public static final class Property
    implements FirMetadataSource {
        private final FirProperty property;

        @Override
        @NotNull
        public FirSession getSession() {
            return this.property.getSession();
        }

        @Override
        @NotNull
        public Name getName() {
            return this.property.getName();
        }

        @NotNull
        public final FirProperty getProperty() {
            return this.property;
        }

        public Property(@NotNull FirProperty property2) {
            Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
            this.property = property2;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/backend/FirMetadataSource$Variable;", "Lorg/jetbrains/kotlin/fir/backend/FirMetadataSource;", "variable", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "(Lorg/jetbrains/kotlin/fir/declarations/FirVariable;)V", "name", "Lorg/jetbrains/kotlin/name/Name;", "getName", "()Lorg/jetbrains/kotlin/name/Name;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "getVariable", "()Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "fir2ir"})
    public static final class Variable
    implements FirMetadataSource {
        private final FirVariable<?> variable;

        @Override
        @NotNull
        public FirSession getSession() {
            return this.variable.getSession();
        }

        @Override
        @NotNull
        public Name getName() {
            return this.variable.getName();
        }

        @NotNull
        public final FirVariable<?> getVariable() {
            return this.variable;
        }

        public Variable(@NotNull FirVariable<?> variable2) {
            Intrinsics.checkNotNullParameter(variable2, (String)"variable");
            this.variable = variable2;
        }
    }
}

