/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilder;
import org.gradle.buildinit.plugins.internal.InitSettings;
import org.gradle.buildinit.plugins.internal.JvmProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.TemplateFactory;
import org.gradle.buildinit.plugins.internal.TemplateLibraryVersionProvider;
import org.gradle.buildinit.plugins.internal.TemplateOperation;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitTestFramework;
import org.gradle.buildinit.plugins.internal.modifiers.ComponentType;
import org.gradle.buildinit.plugins.internal.modifiers.Language;

public class ScalaLibraryProjectInitDescriptor
extends JvmProjectInitDescriptor {
    private final TemplateLibraryVersionProvider libraryVersionProvider;
    private final DocumentationRegistry documentationRegistry;

    public ScalaLibraryProjectInitDescriptor(TemplateLibraryVersionProvider libraryVersionProvider, DocumentationRegistry documentationRegistry) {
        this.libraryVersionProvider = libraryVersionProvider;
        this.documentationRegistry = documentationRegistry;
    }

    @Override
    public String getId() {
        return "scala-library";
    }

    @Override
    public ComponentType getComponentType() {
        return ComponentType.LIBRARY;
    }

    @Override
    public Language getLanguage() {
        return Language.SCALA;
    }

    @Override
    public void generate(InitSettings settings, BuildScriptBuilder buildScriptBuilder, TemplateFactory templateFactory) {
        super.generate(settings, buildScriptBuilder, templateFactory);
        String scalaVersion = this.libraryVersionProvider.getVersion("scala");
        String scalaLibraryVersion = this.libraryVersionProvider.getVersion("scala-library");
        String scalaTestVersion = this.libraryVersionProvider.getVersion("scalatest");
        String scalaTestPlusJunitVersion = this.libraryVersionProvider.getVersion("scalatestplus-junit");
        String junitVersion = this.libraryVersionProvider.getVersion("scala-junit");
        String scalaXmlVersion = this.libraryVersionProvider.getVersion("scala-xml");
        buildScriptBuilder.fileComment("This generated file contains a sample Scala library project to get you started.").fileComment("For more details take a look at the Scala plugin chapter in the Gradle").fileComment("User Manual available at " + this.documentationRegistry.getDocumentationFor("scala_plugin")).plugin("Apply the scala plugin to add support for Scala", "scala").plugin("Apply the java-library plugin for API and implementation separation.", "java-library").implementationDependency("Use Scala " + scalaVersion + " in our library project", "org.scala-lang:scala-library:" + scalaLibraryVersion).testImplementationDependency("Use Scalatest for testing our library", "junit:junit:" + junitVersion, "org.scalatest:scalatest_" + scalaVersion + ":" + scalaTestVersion, "org.scalatestplus:junit-4-12_" + scalaVersion + ":" + scalaTestPlusJunitVersion).testRuntimeOnlyDependency("Need scala-xml at test runtime", "org.scala-lang.modules:scala-xml_" + scalaVersion + ":" + scalaXmlVersion);
        TemplateOperation scalaLibTemplateOperation = templateFactory.fromSourceTemplate("scalalibrary/Library.scala.template", "main");
        TemplateOperation scalaTestTemplateOperation = templateFactory.fromSourceTemplate("scalalibrary/LibrarySuite.scala.template", "test");
        templateFactory.whenNoSourcesAvailable(scalaLibTemplateOperation, scalaTestTemplateOperation).generate();
    }

    @Override
    public Optional<String> getFurtherReading() {
        return Optional.of(this.documentationRegistry.getDocumentationFor("scala_plugin"));
    }

    @Override
    public BuildInitTestFramework getDefaultTestFramework() {
        return BuildInitTestFramework.SCALATEST;
    }

    @Override
    public Set<BuildInitTestFramework> getTestFrameworks() {
        return Collections.singleton(BuildInitTestFramework.SCALATEST);
    }
}

