/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.test.xctest.plugins;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.language.internal.NativeComponentFactory;
import org.gradle.language.nativeplatform.internal.Names;
import org.gradle.language.nativeplatform.internal.toolchains.ToolChainSelector;
import org.gradle.language.swift.ProductionSwiftComponent;
import org.gradle.language.swift.SwiftApplication;
import org.gradle.language.swift.SwiftBinary;
import org.gradle.language.swift.SwiftPlatform;
import org.gradle.language.swift.plugins.SwiftBasePlugin;
import org.gradle.language.swift.tasks.SwiftCompile;
import org.gradle.language.swift.tasks.UnexportMainSymbol;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.platform.internal.DefaultNativePlatform;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.tasks.AbstractLinkTask;
import org.gradle.nativeplatform.tasks.InstallExecutable;
import org.gradle.nativeplatform.tasks.LinkMachOBundle;
import org.gradle.nativeplatform.test.plugins.NativeTestingBasePlugin;
import org.gradle.nativeplatform.test.xctest.SwiftXCTestBinary;
import org.gradle.nativeplatform.test.xctest.SwiftXCTestBundle;
import org.gradle.nativeplatform.test.xctest.SwiftXCTestSuite;
import org.gradle.nativeplatform.test.xctest.internal.DefaultSwiftXCTestBinary;
import org.gradle.nativeplatform.test.xctest.internal.DefaultSwiftXCTestBundle;
import org.gradle.nativeplatform.test.xctest.internal.DefaultSwiftXCTestExecutable;
import org.gradle.nativeplatform.test.xctest.internal.DefaultSwiftXCTestSuite;
import org.gradle.nativeplatform.test.xctest.internal.MacOSSdkPlatformPathLocator;
import org.gradle.nativeplatform.test.xctest.tasks.InstallXCTestBundle;
import org.gradle.nativeplatform.test.xctest.tasks.XCTest;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainRegistryInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.platform.base.Platform;
import org.gradle.util.GUtil;

@Incubating
public class XCTestConventionPlugin
implements Plugin<ProjectInternal> {
    private final MacOSSdkPlatformPathLocator sdkPlatformPathLocator;
    private final ToolChainSelector toolChainSelector;
    private final NativeComponentFactory componentFactory;

    @Inject
    public XCTestConventionPlugin(MacOSSdkPlatformPathLocator sdkPlatformPathLocator, ToolChainSelector toolChainSelector, NativeComponentFactory componentFactory) {
        this.sdkPlatformPathLocator = sdkPlatformPathLocator;
        this.toolChainSelector = toolChainSelector;
        this.componentFactory = componentFactory;
    }

    public void apply(ProjectInternal project) {
        project.getPluginManager().apply(SwiftBasePlugin.class);
        project.getPluginManager().apply(NativeTestingBasePlugin.class);
        final DefaultSwiftXCTestSuite testSuite = this.createTestSuite((Project)project);
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                ToolChainSelector.Result result = XCTestConventionPlugin.this.toolChainSelector.select(SwiftPlatform.class);
                DefaultSwiftXCTestBinary binary = ((SwiftPlatform)result.getTargetPlatform()).getOperatingSystem().isMacOsX() ? (DefaultSwiftXCTestBinary)((Object)testSuite.addBundle("executable", (SwiftPlatform)result.getTargetPlatform(), result.getToolChain(), result.getPlatformToolProvider())) : (DefaultSwiftXCTestBinary)((Object)testSuite.addExecutable("executable", (SwiftPlatform)result.getTargetPlatform(), result.getToolChain(), result.getPlatformToolProvider()));
                testSuite.getTestBinary().set((Object)binary);
                XCTest testingTask = XCTestConventionPlugin.this.createTestingTask(project);
                binary.getRunTask().set((Object)testingTask);
                XCTestConventionPlugin.this.configureTestingTask(binary, testingTask);
                XCTestConventionPlugin.this.configureTestSuiteBuildingTasks((ProjectInternal)project, binary);
                XCTestConventionPlugin.this.configureTestSuiteWithTestedComponentWhenAvailable(project, testSuite);
                testSuite.getBinaries().realizeNow();
            }
        });
    }

    private void configureTestSuiteBuildingTasks(ProjectInternal project, final DefaultSwiftXCTestBinary binary) {
        if (binary instanceof SwiftXCTestBundle) {
            TaskContainerInternal tasks = project.getTasks();
            final Names names = binary.getNames();
            SwiftCompile compile = (SwiftCompile)binary.getCompileTask().get();
            DefaultNativePlatform currentPlatform = new DefaultNativePlatform("current");
            ModelRegistry modelRegistry = project.getModelRegistry();
            NativeToolChain toolChain = (NativeToolChain)((NativeToolChainRegistryInternal)modelRegistry.realize("toolChains", NativeToolChainRegistryInternal.class)).getForPlatform((Platform)currentPlatform);
            compile.getCompilerArgs().addAll(project.provider((Callable)new Callable<List<String>>(){

                @Override
                public List<String> call() {
                    File frameworkDir = new File(XCTestConventionPlugin.this.sdkPlatformPathLocator.find(), "Developer/Library/Frameworks");
                    return Arrays.asList("-parse-as-library", "-g", "-F" + frameworkDir.getAbsolutePath());
                }
            }));
            LinkMachOBundle link = (LinkMachOBundle)tasks.create(names.getTaskName("link"), LinkMachOBundle.class);
            link.getLinkerArgs().set(project.provider((Callable)new Callable<List<String>>(){

                @Override
                public List<String> call() {
                    File frameworkDir = new File(XCTestConventionPlugin.this.sdkPlatformPathLocator.find(), "Developer/Library/Frameworks");
                    return Lists.newArrayList((Object[])new String[]{"-F" + frameworkDir.getAbsolutePath(), "-framework", "XCTest", "-Xlinker", "-rpath", "-Xlinker", "@executable_path/../Frameworks", "-Xlinker", "-rpath", "-Xlinker", "@loader_path/../Frameworks"});
                }
            }));
            InstallXCTestBundle install = (InstallXCTestBundle)tasks.create(names.getTaskName("install"), InstallXCTestBundle.class);
            install.getBundleBinaryFile().set((Provider)link.getBinaryFile());
            install.getInstallDirectory().set(project.getLayout().getBuildDirectory().dir("install/" + names.getDirName()));
            binary.getInstallDirectory().set((Provider)install.getInstallDirectory());
            link.source((Object)binary.getObjects());
            link.lib((Object)binary.getLinkLibraries());
            final PlatformToolProvider toolProvider = ((NativeToolChainInternal)toolChain).select((NativePlatformInternal)currentPlatform);
            Provider exeLocation = project.getLayout().getBuildDirectory().file(project.getProviders().provider((Callable)new Callable<String>(){

                @Override
                public String call() {
                    return toolProvider.getExecutableName("exe/" + names.getDirName() + (String)binary.getBaseName().get());
                }
            }));
            link.setOutputFile(exeLocation);
            link.setTargetPlatform((NativePlatform)currentPlatform);
            link.setToolChain(toolChain);
            link.setDebuggable(binary.isDebuggable());
            binary.getExecutableFile().set((Provider)link.getBinaryFile());
            DefaultSwiftXCTestBundle bundle = (DefaultSwiftXCTestBundle)binary;
            bundle.getLinkTask().set((Object)link);
            bundle.getRunScriptFile().set(install.getRunScriptFile());
        } else {
            DefaultSwiftXCTestExecutable executable = (DefaultSwiftXCTestExecutable)binary;
            executable.getRunScriptFile().set(((InstallExecutable)executable.getInstallTask().get()).getRunScriptFile());
        }
    }

    private XCTest createTestingTask(Project project) {
        TaskContainer tasks = project.getTasks();
        XCTest testTask = (XCTest)tasks.create("xcTest", XCTest.class);
        testTask.setGroup("verification");
        testTask.setDescription("Executes XCTest suites");
        return testTask;
    }

    private void configureTestingTask(SwiftXCTestBinary binary, XCTest testTask) {
        testTask.getTestInstallDirectory().set(binary.getInstallDirectory());
        testTask.getRunScriptFile().set(binary.getRunScriptFile());
        testTask.getWorkingDirectory().set(binary.getInstallDirectory());
    }

    private DefaultSwiftXCTestSuite createTestSuite(Project project) {
        DefaultSwiftXCTestSuite testSuite = (DefaultSwiftXCTestSuite)this.componentFactory.newInstance(SwiftXCTestSuite.class, DefaultSwiftXCTestSuite.class, "test");
        project.getExtensions().add(SwiftXCTestSuite.class, "xctest", (Object)testSuite);
        project.getComponents().add((Object)testSuite);
        testSuite.getModule().set((Object)GUtil.toCamelCase((CharSequence)(project.getName() + "Test")));
        return testSuite;
    }

    private void configureTestSuiteWithTestedComponentWhenAvailable(Project project, DefaultSwiftXCTestSuite testSuite) {
        ProductionSwiftComponent testedComponent = (ProductionSwiftComponent)project.getComponents().withType(ProductionSwiftComponent.class).findByName("main");
        if (testedComponent != null) {
            XCTestConventionPlugin.configureTestSuiteWithTestedComponent(project, testSuite, testedComponent);
        }
    }

    private static void configureTestSuiteWithTestedComponent(final Project project, final DefaultSwiftXCTestSuite testSuite, final ProductionSwiftComponent testedComponent) {
        final TaskContainer tasks = project.getTasks();
        testSuite.getTestedComponent().set((Object)testedComponent);
        testSuite.getBinaries().configureEach((Action)new Action<SwiftBinary>(){

            public void execute(final SwiftBinary testExecutable) {
                if (testExecutable != testSuite.getTestBinary().get()) {
                    return;
                }
                testedComponent.getBinaries().whenElementFinalized((Action)new Action<SwiftBinary>(){

                    public void execute(SwiftBinary testedBinary) {
                        if (testedBinary != testedComponent.getDevelopmentBinary().get()) {
                            return;
                        }
                        testSuite.getImplementationDependencies().extendsFrom(new Configuration[]{testedComponent.getImplementationDependencies()});
                        project.getDependencies().add(((DefaultSwiftXCTestBinary)testSuite.getTestBinary().get()).getImportPathConfiguration().getName(), (Object)project);
                        AbstractLinkTask linkTest = (AbstractLinkTask)((SwiftXCTestBinary)testExecutable).getLinkTask().get();
                        if (testedComponent instanceof SwiftApplication) {
                            final UnexportMainSymbol unexportMainSymbol = (UnexportMainSymbol)tasks.create("relocateMainForTest", UnexportMainSymbol.class);
                            unexportMainSymbol.source(new Object[]{testedBinary.getObjects()});
                            linkTest.source((Object)testedBinary.getObjects().filter((Spec)new Spec<File>(){

                                public boolean isSatisfiedBy(File objectFile) {
                                    return !objectFile.equals(unexportMainSymbol.getMainObject());
                                }
                            }));
                            linkTest.source((Object)unexportMainSymbol.getObjects());
                        } else {
                            linkTest.source((Object)testedBinary.getObjects());
                        }
                    }
                });
            }
        });
    }
}

