/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.external.model.ComponentVariant;
import org.gradle.internal.component.external.model.DefaultModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.external.model.GradleDependencyMetadata;
import org.gradle.internal.component.external.model.VariantMetadataRules;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.VariantResolveMetadata;

class VariantBackedConfigurationMetadata
implements ConfigurationMetadata {
    private final ModuleComponentIdentifier componentId;
    private final ComponentVariant variant;
    private final ImmutableList<GradleDependencyMetadata> dependencies;
    private final VariantMetadataRules variantMetadataRules;
    private final ImmutableAttributes componentLevelAttributes;
    private List<GradleDependencyMetadata> calculatedDependencies;
    private ImmutableAttributesFactory attributesFactory;

    VariantBackedConfigurationMetadata(ModuleComponentIdentifier componentId, ComponentVariant variant, ImmutableAttributes componentLevelAttributes, ImmutableAttributesFactory attributesFactory, VariantMetadataRules variantMetadataRules) {
        this.componentId = componentId;
        this.variant = new RuleAwareVariant(variant);
        this.attributesFactory = attributesFactory;
        this.componentLevelAttributes = componentLevelAttributes;
        this.variantMetadataRules = variantMetadataRules;
        ArrayList<GradleDependencyMetadata> dependencies = new ArrayList<GradleDependencyMetadata>(variant.getDependencies().size());
        for (ComponentVariant.Dependency dependency : variant.getDependencies()) {
            ModuleComponentSelector selector = DefaultModuleComponentSelector.newSelector(dependency.getGroup(), dependency.getModule(), dependency.getVersionConstraint());
            ImmutableList<ExcludeMetadata> excludes = dependency.getExcludes();
            dependencies.add(new GradleDependencyMetadata(selector, (List<ExcludeMetadata>)excludes));
        }
        for (ComponentVariant.DependencyConstraint dependencyConstraint : variant.getDependencyConstraints()) {
            dependencies.add(new GradleDependencyMetadata(DefaultModuleComponentSelector.newSelector(dependencyConstraint.getGroup(), dependencyConstraint.getModule(), dependencyConstraint.getVersionConstraint()), true));
        }
        this.dependencies = ImmutableList.copyOf(dependencies);
    }

    @Override
    public String getName() {
        return this.variant.getName();
    }

    @Override
    public Collection<String> getHierarchy() {
        return ImmutableList.of((Object)this.variant.getName());
    }

    public String toString() {
        return this.asDescribable().getDisplayName();
    }

    @Override
    public DisplayName asDescribable() {
        return Describables.of((Object)this.componentId, (Object)"variant", (Object)this.variant.getName());
    }

    @Override
    public ImmutableAttributes getAttributes() {
        return this.variant.getAttributes().asImmutable();
    }

    @Override
    public Set<? extends VariantResolveMetadata> getVariants() {
        return ImmutableSet.of((Object)this.variant);
    }

    @Override
    public boolean isCanBeConsumed() {
        return true;
    }

    @Override
    public boolean isCanBeResolved() {
        return false;
    }

    @Override
    public boolean isTransitive() {
        return true;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public ImmutableList<ExcludeMetadata> getExcludes() {
        return ImmutableList.of();
    }

    @Override
    public ComponentArtifactMetadata artifact(IvyArtifactName artifact) {
        return new DefaultModuleComponentArtifactMetadata(this.componentId, artifact);
    }

    @Override
    public List<? extends ComponentArtifactMetadata> getArtifacts() {
        return ImmutableList.of();
    }

    @Override
    public List<? extends DependencyMetadata> getDependencies() {
        if (this.calculatedDependencies == null) {
            this.calculatedDependencies = this.variantMetadataRules.applyDependencyMetadataRules(this.variant, this.dependencies);
        }
        return this.calculatedDependencies;
    }

    private AttributeContainerInternal mergeComponentAndVariantAttributes(AttributeContainerInternal variantAttributes) {
        return this.attributesFactory.concat(this.componentLevelAttributes, variantAttributes.asImmutable());
    }

    private class RuleAwareVariant
    implements ComponentVariant {
        private final ComponentVariant delegate;
        private ImmutableAttributes computedAttributes;

        private RuleAwareVariant(ComponentVariant delegate) {
            this.delegate = delegate;
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public DisplayName asDescribable() {
            return this.delegate.asDescribable();
        }

        public ImmutableAttributes getAttributes() {
            if (this.computedAttributes == null) {
                this.computedAttributes = VariantBackedConfigurationMetadata.this.variantMetadataRules.applyVariantAttributeRules(this.delegate, VariantBackedConfigurationMetadata.this.mergeComponentAndVariantAttributes(this.delegate.getAttributes()));
            }
            return this.computedAttributes;
        }

        @Override
        public List<? extends ComponentArtifactMetadata> getArtifacts() {
            return this.delegate.getArtifacts();
        }

        @Override
        public ImmutableList<? extends ComponentVariant.Dependency> getDependencies() {
            return this.delegate.getDependencies();
        }

        @Override
        public ImmutableList<? extends ComponentVariant.DependencyConstraint> getDependencyConstraints() {
            return this.delegate.getDependencyConstraints();
        }

        @Override
        public ImmutableList<? extends ComponentVariant.File> getFiles() {
            return this.delegate.getFiles();
        }
    }
}

