/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.publisher;

import java.io.File;
import java.util.ArrayList;
import java.util.Set;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.PublishException;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ArtifactPublisher;
import org.gradle.api.internal.artifacts.Module;
import org.gradle.api.internal.artifacts.ModuleVersionPublisher;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.ConfigurationComponentMetaDataBuilder;
import org.gradle.api.internal.artifacts.ivyservice.publisher.IvyDependencyPublisher;
import org.gradle.api.internal.artifacts.ivyservice.publisher.IvyModuleDescriptorWriter;
import org.gradle.api.internal.artifacts.repositories.PublicationAwareRepository;
import org.gradle.internal.Cast;
import org.gradle.internal.component.external.ivypublish.BuildableIvyModulePublishMetadata;
import org.gradle.internal.component.external.ivypublish.DefaultIvyModulePublishMetadata;
import org.gradle.internal.component.external.ivypublish.IvyModuleArtifactPublishMetadata;
import org.gradle.internal.component.external.ivypublish.IvyModulePublishMetadata;
import org.gradle.internal.component.external.model.DefaultModuleComponentIdentifier;
import org.gradle.internal.component.model.DefaultIvyArtifactName;

public class IvyBackedArtifactPublisher
implements ArtifactPublisher {
    private final ConfigurationComponentMetaDataBuilder configurationComponentMetaDataBuilder;
    private final IvyDependencyPublisher dependencyPublisher;
    private final IvyModuleDescriptorWriter ivyModuleDescriptorWriter;

    public IvyBackedArtifactPublisher(ConfigurationComponentMetaDataBuilder configurationComponentMetaDataBuilder, IvyDependencyPublisher dependencyPublisher, IvyModuleDescriptorWriter ivyModuleDescriptorWriter) {
        this.configurationComponentMetaDataBuilder = configurationComponentMetaDataBuilder;
        this.dependencyPublisher = dependencyPublisher;
        this.ivyModuleDescriptorWriter = ivyModuleDescriptorWriter;
    }

    @Override
    public void publish(Iterable<? extends PublicationAwareRepository> repositories, Module module, Configuration configuration, File descriptor) throws PublishException {
        BuildableIvyModulePublishMetadata publishMetaData;
        Set allConfigurations = (Set)Cast.uncheckedCast((Object)configuration.getAll());
        Set configurationsToPublish = (Set)Cast.uncheckedCast((Object)configuration.getHierarchy());
        if (descriptor != null) {
            publishMetaData = this.toPublishMetaData(module, allConfigurations);
            this.validatePublishMetaData(publishMetaData);
            this.ivyModuleDescriptorWriter.write(publishMetaData, descriptor);
        }
        publishMetaData = this.toPublishMetaData(module, configurationsToPublish);
        if (descriptor != null) {
            DefaultIvyArtifactName artifact = new DefaultIvyArtifactName("ivy", "ivy", "xml");
            publishMetaData.addArtifact(artifact, descriptor);
        }
        ArrayList<ModuleVersionPublisher> publishResolvers = new ArrayList<ModuleVersionPublisher>();
        for (PublicationAwareRepository publicationAwareRepository : repositories) {
            ModuleVersionPublisher publisher = publicationAwareRepository.createPublisher();
            publishResolvers.add(publisher);
        }
        this.dependencyPublisher.publish(publishResolvers, publishMetaData);
    }

    private void validatePublishMetaData(IvyModulePublishMetadata publishMetaData) {
        for (IvyModuleArtifactPublishMetadata metadata : publishMetaData.getArtifacts()) {
            if (!metadata.getFile().isDirectory()) continue;
            throw new IllegalArgumentException("Cannot publish a directory (" + metadata.getFile() + ")");
        }
    }

    private BuildableIvyModulePublishMetadata toPublishMetaData(Module module, Set<? extends ConfigurationInternal> configurations) {
        ModuleComponentIdentifier id = DefaultModuleComponentIdentifier.newId(module.getGroup(), module.getName(), module.getVersion());
        DefaultIvyModulePublishMetadata publishMetaData = new DefaultIvyModulePublishMetadata(id, module.getStatus());
        this.configurationComponentMetaDataBuilder.addConfigurations(publishMetaData, configurations);
        return publishMetaData;
    }
}

