/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit;

import org.gradle.api.internal.tasks.testing.TestClassProcessor;
import org.gradle.api.internal.tasks.testing.TestClassRunInfo;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.junit.JUnitSpec;
import org.gradle.api.internal.tasks.testing.junit.JUnitTestClassExecuter;
import org.gradle.api.internal.tasks.testing.junit.JUnitTestEventAdapter;
import org.gradle.api.internal.tasks.testing.junit.TestClassExecutionEventGenerator;
import org.gradle.api.internal.tasks.testing.junit.TestClassExecutionListener;
import org.gradle.api.internal.tasks.testing.results.AttachParentTestResultProcessor;
import org.gradle.internal.actor.Actor;
import org.gradle.internal.actor.ActorFactory;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.time.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JUnitTestClassProcessor
implements TestClassProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(JUnitTestClassProcessor.class);
    private final IdGenerator<?> idGenerator;
    private final ActorFactory actorFactory;
    private final Clock clock;
    private final JUnitSpec spec;
    private JUnitTestClassExecuter executer;
    private Actor resultProcessorActor;

    public JUnitTestClassProcessor(JUnitSpec spec, IdGenerator<?> idGenerator, ActorFactory actorFactory, Clock clock) {
        this.idGenerator = idGenerator;
        this.spec = spec;
        this.actorFactory = actorFactory;
        this.clock = clock;
    }

    public void startProcessing(TestResultProcessor resultProcessor) {
        ClassLoader applicationClassLoader = Thread.currentThread().getContextClassLoader();
        AttachParentTestResultProcessor resultProcessorChain = new AttachParentTestResultProcessor(resultProcessor);
        TestClassExecutionEventGenerator eventGenerator = new TestClassExecutionEventGenerator((TestResultProcessor)resultProcessorChain, this.idGenerator, this.clock);
        this.resultProcessorActor = this.actorFactory.createBlockingActor((Object)eventGenerator);
        TestResultProcessor threadSafeResultProcessor = (TestResultProcessor)this.resultProcessorActor.getProxy(TestResultProcessor.class);
        TestClassExecutionListener threadSafeTestClassListener = (TestClassExecutionListener)this.resultProcessorActor.getProxy(TestClassExecutionListener.class);
        JUnitTestEventAdapter junitEventAdapter = new JUnitTestEventAdapter(threadSafeResultProcessor, this.clock, this.idGenerator);
        this.executer = new JUnitTestClassExecuter(applicationClassLoader, this.spec, junitEventAdapter, threadSafeTestClassListener);
    }

    public void processTestClass(TestClassRunInfo testClass) {
        LOGGER.debug("Executing test class {}", (Object)testClass.getTestClassName());
        this.executer.execute(testClass.getTestClassName());
    }

    public void stop() {
        this.resultProcessorActor.stop();
    }
}

