/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import java.io.FileFilter;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.gradle.cache.CleanupAction;
import org.gradle.cache.PersistentCache;
import org.gradle.util.GFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractCacheCleanup
implements CleanupAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCacheCleanup.class);

    AbstractCacheCleanup() {
    }

    @Override
    public void clean(PersistentCache persistentCache) {
        List<File> filesForDeletion;
        File[] filesEligibleForCleanup = this.findEligibleFiles(persistentCache);
        if (filesEligibleForCleanup.length > 0 && !(filesForDeletion = this.findFilesToDelete(persistentCache, filesEligibleForCleanup)).isEmpty()) {
            this.cleanupFiles(persistentCache, filesForDeletion);
        }
    }

    protected abstract List<File> findFilesToDelete(PersistentCache var1, File[] var2);

    File[] findEligibleFiles(final PersistentCache persistentCache) {
        return persistentCache.getBaseDir().listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !AbstractCacheCleanup.this.isReserved(persistentCache, file);
            }
        });
    }

    protected boolean isReserved(PersistentCache persistentCache, File file) {
        return persistentCache.getReservedCacheFiles().contains(file);
    }

    void cleanupFiles(PersistentCache persistentCache, List<File> filesForDeletion) {
        long removedSize = this.deleteFiles(filesForDeletion);
        LOGGER.info("{} removing {} cache entries ({} reclaimed).", new Object[]{persistentCache, filesForDeletion.size(), FileUtils.byteCountToDisplaySize((long)removedSize)});
    }

    private long deleteFiles(List<File> files) {
        long removedSize = 0L;
        for (File file : files) {
            try {
                long size = file.length();
                if (!GFileUtils.deleteQuietly((File)file)) continue;
                removedSize += size;
            }
            catch (Exception e) {
                LOGGER.debug("Could not clean up cache " + file, (Throwable)e);
            }
        }
        return removedSize;
    }
}

