/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties;

import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Sets;
import java.util.Set;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.CompositeFileCollection;
import org.gradle.api.internal.file.collections.FileCollectionResolveContext;
import org.gradle.api.internal.tasks.TaskInputFilePropertySpec;
import org.gradle.api.internal.tasks.properties.PropertyVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetInputFilesVisitor
extends PropertyVisitor.Adapter {
    private final String beanName;
    private ImmutableSortedSet.Builder<TaskInputFilePropertySpec> builder = ImmutableSortedSet.naturalOrder();
    private Set<String> names = Sets.newHashSet();
    private boolean hasSourceFiles;
    private ImmutableSortedSet<TaskInputFilePropertySpec> fileProperties;

    public GetInputFilesVisitor(String beanName) {
        this.beanName = beanName;
    }

    @Override
    public void visitInputFileProperty(TaskInputFilePropertySpec inputFileProperty) {
        String propertyName = inputFileProperty.getPropertyName();
        if (!this.names.add(propertyName)) {
            throw new IllegalArgumentException(String.format("Multiple %s file properties with name '%s'", "input", propertyName));
        }
        this.builder.add((Object)inputFileProperty);
        if (inputFileProperty.isSkipWhenEmpty()) {
            this.hasSourceFiles = true;
        }
    }

    public ImmutableSortedSet<TaskInputFilePropertySpec> getFileProperties() {
        if (this.fileProperties == null) {
            this.fileProperties = this.builder.build();
        }
        return this.fileProperties;
    }

    public FileCollection getFiles() {
        return new CompositeFileCollection(){

            public String getDisplayName() {
                return GetInputFilesVisitor.this.beanName + " input files";
            }

            public void visitContents(FileCollectionResolveContext context) {
                for (TaskInputFilePropertySpec filePropertySpec : GetInputFilesVisitor.this.getFileProperties()) {
                    context.add(filePropertySpec.getPropertyFiles());
                }
            }
        };
    }

    public FileCollection getSourceFiles() {
        return new CompositeFileCollection(){

            public String getDisplayName() {
                return GetInputFilesVisitor.this.beanName + " source files";
            }

            public void visitContents(FileCollectionResolveContext context) {
                for (TaskInputFilePropertySpec filePropertySpec : GetInputFilesVisitor.this.getFileProperties()) {
                    if (!filePropertySpec.isSkipWhenEmpty()) continue;
                    context.add(filePropertySpec.getPropertyFiles());
                }
            }
        };
    }

    public boolean hasSourceFiles() {
        return this.hasSourceFiles;
    }
}

