/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import groovy.lang.Closure;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.gradle.api.Describable;
import org.gradle.api.NonNullApi;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.OverlappingOutputs;
import org.gradle.api.internal.TaskExecutionHistory;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.TaskOutputCachingState;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.internal.file.CompositeFileCollection;
import org.gradle.api.internal.file.collections.FileCollectionResolveContext;
import org.gradle.api.internal.tasks.DeclaredTaskOutputFileProperty;
import org.gradle.api.internal.tasks.DefaultTaskOutputCachingState;
import org.gradle.api.internal.tasks.NonCacheableTaskOutputPropertySpec;
import org.gradle.api.internal.tasks.PropertySpecFactory;
import org.gradle.api.internal.tasks.StaticValue;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.internal.tasks.TaskFilePropertySpec;
import org.gradle.api.internal.tasks.TaskMutator;
import org.gradle.api.internal.tasks.TaskOutputCachingDisabledReasonCategory;
import org.gradle.api.internal.tasks.TaskOutputFilePropertySpec;
import org.gradle.api.internal.tasks.TaskPropertySpec;
import org.gradle.api.internal.tasks.TaskPropertyUtils;
import org.gradle.api.internal.tasks.execution.SelfDescribingSpec;
import org.gradle.api.internal.tasks.execution.TaskProperties;
import org.gradle.api.internal.tasks.properties.GetOutputFilesVisitor;
import org.gradle.api.internal.tasks.properties.PropertyVisitor;
import org.gradle.api.internal.tasks.properties.PropertyWalker;
import org.gradle.api.specs.AndSpec;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskOutputFilePropertyBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullApi
public class DefaultTaskOutputs
implements TaskOutputsInternal {
    private static final TaskOutputCachingState ENABLED = DefaultTaskOutputCachingState.enabled();
    public static final TaskOutputCachingState DISABLED = DefaultTaskOutputCachingState.disabled(TaskOutputCachingDisabledReasonCategory.BUILD_CACHE_DISABLED, "Task output caching is disabled");
    private static final TaskOutputCachingState CACHING_NOT_ENABLED = DefaultTaskOutputCachingState.disabled(TaskOutputCachingDisabledReasonCategory.NOT_ENABLED_FOR_TASK, "Caching has not been enabled for the task");
    private static final TaskOutputCachingState NO_OUTPUTS_DECLARED = DefaultTaskOutputCachingState.disabled(TaskOutputCachingDisabledReasonCategory.NO_OUTPUTS_DECLARED, "No outputs declared");
    private final FileCollection allOutputFiles;
    private final PropertyWalker propertyWalker;
    private final PropertySpecFactory specFactory;
    private AndSpec<TaskInternal> upToDateSpec = AndSpec.empty();
    private List<SelfDescribingSpec<TaskInternal>> cacheIfSpecs = new LinkedList<SelfDescribingSpec<TaskInternal>>();
    private List<SelfDescribingSpec<TaskInternal>> doNotCacheIfSpecs = new LinkedList<SelfDescribingSpec<TaskInternal>>();
    private TaskExecutionHistory history;
    private final List<DeclaredTaskOutputFileProperty> registeredFileProperties = Lists.newArrayList();
    private final TaskInternal task;
    private final TaskMutator taskMutator;

    public DefaultTaskOutputs(TaskInternal task, TaskMutator taskMutator, PropertyWalker propertyWalker, PropertySpecFactory specFactory) {
        this.task = task;
        this.taskMutator = taskMutator;
        this.allOutputFiles = new TaskOutputUnionFileCollection(task);
        this.propertyWalker = propertyWalker;
        this.specFactory = specFactory;
    }

    @Override
    public void visitRegisteredProperties(PropertyVisitor visitor) {
        TaskPropertyUtils.ensurePropertiesHaveNames(this.registeredFileProperties);
        for (DeclaredTaskOutputFileProperty fileProperty : this.registeredFileProperties) {
            visitor.visitOutputFileProperty(fileProperty);
        }
    }

    @Override
    public AndSpec<? super TaskInternal> getUpToDateSpec() {
        return this.upToDateSpec;
    }

    public void upToDateWhen(final Closure upToDateClosure) {
        this.taskMutator.mutate("TaskOutputs.upToDateWhen(Closure)", new Runnable(){

            public void run() {
                DefaultTaskOutputs.this.upToDateSpec = DefaultTaskOutputs.this.upToDateSpec.and(upToDateClosure);
            }
        });
    }

    public void upToDateWhen(final Spec<? super Task> spec) {
        this.taskMutator.mutate("TaskOutputs.upToDateWhen(Spec)", new Runnable(){

            public void run() {
                DefaultTaskOutputs.this.upToDateSpec = DefaultTaskOutputs.this.upToDateSpec.and(spec);
            }
        });
    }

    @Override
    public TaskOutputCachingState getCachingState(TaskProperties taskProperties) {
        if (this.cacheIfSpecs.isEmpty()) {
            return CACHING_NOT_ENABLED;
        }
        if (!taskProperties.hasDeclaredOutputs()) {
            return NO_OUTPUTS_DECLARED;
        }
        OverlappingOutputs overlappingOutputs = this.getOverlappingOutputs();
        if (overlappingOutputs != null) {
            String relativePath = this.task.getProject().relativePath((Object)overlappingOutputs.getOverlappedFilePath());
            return DefaultTaskOutputCachingState.disabled(TaskOutputCachingDisabledReasonCategory.OVERLAPPING_OUTPUTS, String.format("Gradle does not know how file '%s' was created (output property '%s'). Task output caching requires exclusive access to output paths to guarantee correctness.", relativePath, overlappingOutputs.getPropertyName()));
        }
        for (TaskPropertySpec spec : taskProperties.getOutputFileProperties()) {
            if (!(spec instanceof NonCacheableTaskOutputPropertySpec)) continue;
            return DefaultTaskOutputCachingState.disabled(TaskOutputCachingDisabledReasonCategory.PLURAL_OUTPUTS, "Declares multiple output files for the single output property '" + ((NonCacheableTaskOutputPropertySpec)spec).getOriginalPropertyName() + "' via `@OutputFiles`, `@OutputDirectories` or `TaskOutputs.files()`");
        }
        for (SelfDescribingSpec<TaskInternal> selfDescribingSpec : this.cacheIfSpecs) {
            if (selfDescribingSpec.isSatisfiedBy(this.task)) continue;
            return DefaultTaskOutputCachingState.disabled(TaskOutputCachingDisabledReasonCategory.CACHE_IF_SPEC_NOT_SATISFIED, "'" + selfDescribingSpec.getDisplayName() + "' not satisfied");
        }
        for (SelfDescribingSpec<TaskInternal> selfDescribingSpec : this.doNotCacheIfSpecs) {
            if (!selfDescribingSpec.isSatisfiedBy(this.task)) continue;
            return DefaultTaskOutputCachingState.disabled(TaskOutputCachingDisabledReasonCategory.DO_NOT_CACHE_IF_SPEC_SATISFIED, "'" + selfDescribingSpec.getDisplayName() + "' satisfied");
        }
        return ENABLED;
    }

    @Nullable
    private OverlappingOutputs getOverlappingOutputs() {
        return this.history != null ? this.history.getOverlappingOutputs() : null;
    }

    public void cacheIf(Spec<? super Task> spec) {
        this.cacheIf("Task outputs cacheable", spec);
    }

    public void cacheIf(final String cachingEnabledReason, final Spec<? super Task> spec) {
        this.taskMutator.mutate("TaskOutputs.cacheIf(Spec)", new Runnable(){

            public void run() {
                DefaultTaskOutputs.this.cacheIfSpecs.add(new SelfDescribingSpec(spec, cachingEnabledReason));
            }
        });
    }

    public void doNotCacheIf(final String cachingDisabledReason, final Spec<? super Task> spec) {
        this.taskMutator.mutate("TaskOutputs.doNotCacheIf(Spec)", new Runnable(){

            public void run() {
                DefaultTaskOutputs.this.doNotCacheIfSpecs.add(new SelfDescribingSpec(spec, cachingDisabledReason));
            }
        });
    }

    public boolean getHasOutput() {
        if (!this.upToDateSpec.isEmpty()) {
            return true;
        }
        HasDeclaredOutputsVisitor visitor = new HasDeclaredOutputsVisitor();
        TaskPropertyUtils.visitProperties(this.propertyWalker, this.task, visitor);
        return visitor.hasDeclaredOutputs();
    }

    public FileCollection getFiles() {
        return this.allOutputFiles;
    }

    public ImmutableSortedSet<TaskOutputFilePropertySpec> getFileProperties() {
        GetOutputFilesVisitor visitor = new GetOutputFilesVisitor();
        TaskPropertyUtils.visitProperties(this.propertyWalker, this.task, visitor);
        return visitor.getFileProperties();
    }

    public TaskOutputFilePropertyBuilder file(final Object path) {
        return this.taskMutator.mutate("TaskOutputs.file(Object)", new Callable<TaskOutputFilePropertyBuilder>(){

            @Override
            public TaskOutputFilePropertyBuilder call() {
                StaticValue value = new StaticValue(path);
                DeclaredTaskOutputFileProperty outputFileSpec = DefaultTaskOutputs.this.specFactory.createOutputFileSpec(value);
                DefaultTaskOutputs.this.registeredFileProperties.add(outputFileSpec);
                return outputFileSpec;
            }
        });
    }

    public TaskOutputFilePropertyBuilder dir(final Object path) {
        return this.taskMutator.mutate("TaskOutputs.dir(Object)", new Callable<TaskOutputFilePropertyBuilder>(){

            @Override
            public TaskOutputFilePropertyBuilder call() {
                StaticValue value = new StaticValue(path);
                DeclaredTaskOutputFileProperty outputDirSpec = DefaultTaskOutputs.this.specFactory.createOutputDirSpec(value);
                DefaultTaskOutputs.this.registeredFileProperties.add(outputDirSpec);
                return outputDirSpec;
            }
        });
    }

    public TaskOutputFilePropertyBuilder files(final Object ... paths) {
        return this.taskMutator.mutate("TaskOutputs.files(Object...)", new Callable<TaskOutputFilePropertyBuilder>(){

            @Override
            public TaskOutputFilePropertyBuilder call() {
                StaticValue value = new StaticValue(DefaultTaskOutputs.resolveSingleArray(paths));
                DeclaredTaskOutputFileProperty outputFilesSpec = DefaultTaskOutputs.this.specFactory.createOutputFilesSpec(value);
                DefaultTaskOutputs.this.registeredFileProperties.add(outputFilesSpec);
                return outputFilesSpec;
            }
        });
    }

    public TaskOutputFilePropertyBuilder dirs(final Object ... paths) {
        return this.taskMutator.mutate("TaskOutputs.dirs(Object...)", new Callable<TaskOutputFilePropertyBuilder>(){

            @Override
            public TaskOutputFilePropertyBuilder call() {
                StaticValue value = new StaticValue(DefaultTaskOutputs.resolveSingleArray(paths));
                DeclaredTaskOutputFileProperty outputDirsSpec = DefaultTaskOutputs.this.specFactory.createOutputDirsSpec(value);
                DefaultTaskOutputs.this.registeredFileProperties.add(outputDirsSpec);
                return outputDirsSpec;
            }
        });
    }

    @Nullable
    private static Object resolveSingleArray(@Nullable Object[] paths) {
        return paths != null && paths.length == 1 ? paths[0] : paths;
    }

    @Override
    public Set<File> getPreviousOutputFiles() {
        if (this.history == null) {
            throw new IllegalStateException("Task history is currently not available for this task.");
        }
        return this.history.getOutputFiles();
    }

    @Override
    public void setHistory(@Nullable TaskExecutionHistory history) {
        this.history = history;
    }

    private class TaskOutputUnionFileCollection
    extends CompositeFileCollection
    implements Describable {
        private final TaskInternal buildDependencies;

        public TaskOutputUnionFileCollection(TaskInternal buildDependencies) {
            this.buildDependencies = buildDependencies;
        }

        public String getDisplayName() {
            return "task '" + DefaultTaskOutputs.this.task.getName() + "' output files";
        }

        public void visitContents(FileCollectionResolveContext context) {
            for (TaskFilePropertySpec propertySpec : DefaultTaskOutputs.this.getFileProperties()) {
                context.add(propertySpec.getPropertyFiles());
            }
        }

        public void visitDependencies(TaskDependencyResolveContext context) {
            context.add(this.buildDependencies);
            super.visitDependencies(context);
        }
    }

    private static class HasDeclaredOutputsVisitor
    extends PropertyVisitor.Adapter {
        boolean hasDeclaredOutputs;

        private HasDeclaredOutputsVisitor() {
        }

        public void visitOutputFileProperty(TaskOutputFilePropertySpec outputFileProperty) {
            this.hasDeclaredOutputs = true;
        }

        public boolean hasDeclaredOutputs() {
            return this.hasDeclaredOutputs;
        }
    }
}

