/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.swift;

import org.gradle.api.Incubating;
import org.gradle.util.VersionNumber;

@Incubating
public enum SwiftLanguageVersion {
    SWIFT2,
    SWIFT3,
    SWIFT4;


    public static SwiftLanguageVersion of(VersionNumber swiftCompilerVersion) {
        if (swiftCompilerVersion.getMajor() == 2) {
            return SWIFT2;
        }
        if (swiftCompilerVersion.getMajor() == 3) {
            return SWIFT3;
        }
        if (swiftCompilerVersion.getMajor() == 4) {
            return SWIFT4;
        }
        throw new IllegalArgumentException(String.format("Swift language version is unknown for the specified swift compiler version (%s)", swiftCompilerVersion.toString()));
    }
}

