/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.cpp.internal;

import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.language.cpp.CppApplication;
import org.gradle.language.cpp.CppExecutable;
import org.gradle.language.cpp.CppPlatform;
import org.gradle.language.cpp.internal.DefaultCppComponent;
import org.gradle.language.cpp.internal.DefaultCppExecutable;
import org.gradle.language.cpp.internal.MainExecutableVariant;
import org.gradle.language.internal.DefaultBinaryCollection;
import org.gradle.language.nativeplatform.internal.PublicationAwareComponent;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;

public class DefaultCppApplication
extends DefaultCppComponent
implements CppApplication,
PublicationAwareComponent {
    private final ObjectFactory objectFactory;
    private final Property<CppExecutable> developmentBinary;
    private final MainExecutableVariant mainVariant = new MainExecutableVariant();

    @Inject
    public DefaultCppApplication(String name, ObjectFactory objectFactory, FileOperations fileOperations, ConfigurationContainer configurations) {
        super(name, fileOperations, objectFactory, configurations);
        this.objectFactory = objectFactory;
        this.developmentBinary = objectFactory.property(CppExecutable.class);
    }

    public DefaultCppExecutable addExecutable(String nameSuffix, boolean debuggable, boolean optimized, CppPlatform targetPlatform, NativeToolChainInternal toolChain, PlatformToolProvider platformToolProvider) {
        DefaultCppExecutable result = (DefaultCppExecutable)this.objectFactory.newInstance(DefaultCppExecutable.class, new Object[]{this.getName() + StringUtils.capitalize((String)nameSuffix), this.getBaseName(), debuggable, optimized, this.getCppSource(), this.getPrivateHeaderDirs(), this.getImplementationDependencies(), targetPlatform, toolChain, platformToolProvider});
        ((DefaultBinaryCollection)this.getBinaries()).add(result);
        return result;
    }

    @Override
    public MainExecutableVariant getMainPublication() {
        return this.mainVariant;
    }

    public Property<CppExecutable> getDevelopmentBinary() {
        return this.developmentBinary;
    }
}

