/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Set;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.Usage;
import org.gradle.api.internal.attributes.DisambiguationRule;
import org.gradle.api.internal.attributes.EmptySchema;
import org.gradle.api.internal.attributes.MultipleCandidatesResult;
import org.gradle.internal.Cast;

class PreferJavaRuntimeVariant
extends EmptySchema {
    private static final Set<String> DEFAULT_JAVA_USAGES = ImmutableSet.of((Object)"java-api", (Object)"java-runtime");
    private static final Set<Attribute<?>> SUPPORTED_ATTRIBUTES = Collections.singleton(Attribute.of((String)Usage.USAGE_ATTRIBUTE.getName(), String.class));
    private static final PreferJavaRuntimeVariant SCHEMA_DEFAULT_JAVA_VARIANTS = new PreferJavaRuntimeVariant();

    static PreferJavaRuntimeVariant schema() {
        return SCHEMA_DEFAULT_JAVA_VARIANTS;
    }

    private PreferJavaRuntimeVariant() {
    }

    @Override
    public Set<Attribute<?>> getAttributes() {
        return SUPPORTED_ATTRIBUTES;
    }

    @Override
    public DisambiguationRule<Object> disambiguationRules(Attribute<?> attribute) {
        if (Usage.USAGE_ATTRIBUTE.getName().equals(attribute.getName())) {
            return (DisambiguationRule)Cast.uncheckedCast((Object)new DisambiguationRule<String>(){

                @Override
                public boolean doesSomething() {
                    return true;
                }

                public void execute(MultipleCandidatesResult<String> details) {
                    if (details.getConsumerValue() == null && details.getCandidateValues().equals(DEFAULT_JAVA_USAGES)) {
                        details.closestMatch("java-runtime");
                    }
                }
            });
        }
        return super.disambiguationRules(attribute);
    }
}

