/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.DependencyState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.NodeState;

public interface PendingDependenciesHandler {
    public static final PendingDependenciesHandler IGNORE = new IgnorePendingDependenciesHandler();

    public Visitor start(boolean var1);

    public static class IgnorePendingDependenciesHandler
    implements PendingDependenciesHandler {
        @Override
        public Visitor start(boolean isOptionalConfiguration) {
            return new IgnorePendingDependenciesVisitor(isOptionalConfiguration);
        }

        static class IgnorePendingDependenciesVisitor
        implements Visitor {
            private final boolean isOptionalConfiguration;

            IgnorePendingDependenciesVisitor(boolean isOptionalConfiguration) {
                this.isOptionalConfiguration = isOptionalConfiguration;
            }

            @Override
            public boolean maybeAddAsPendingDependency(NodeState node, DependencyState dependencyState) {
                return !this.isOptionalConfiguration && dependencyState.getDependencyMetadata().isPending();
            }

            @Override
            public void complete() {
            }
        }
    }

    public static interface Visitor {
        public boolean maybeAddAsPendingDependency(NodeState var1, DependencyState var2);

        public void complete();
    }
}

