/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.ExperimentalFeatures;
import org.gradle.api.internal.artifacts.ComponentSelectorConverter;
import org.gradle.api.internal.artifacts.ResolveContext;
import org.gradle.api.internal.artifacts.ResolvedVersionConstraint;
import org.gradle.api.internal.artifacts.dsl.ModuleReplacementsData;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DependencySubstitutionApplicator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExclusions;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ComponentState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.DefaultPendingDependenciesHandler;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.DirectDependencyForcingResolver;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.DownloadMetadataOperation;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.EdgeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ModuleResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.NodeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.PendingDependenciesHandler;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.SelectorState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.ConflictHandler;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.PotentialConflict;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.VersionSelectionReasons;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.specs.Spec;
import org.gradle.internal.component.external.model.DefaultModuleComponentIdentifier;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.id.LongIdGenerator;
import org.gradle.internal.operations.BuildOperation;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.resolve.resolver.ComponentMetaDataResolver;
import org.gradle.internal.resolve.resolver.DependencyToComponentIdResolver;
import org.gradle.internal.resolve.resolver.ResolveContextToComponentResolver;
import org.gradle.internal.resolve.result.DefaultBuildableComponentResolveResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependencyGraphBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DependencyGraphBuilder.class);
    private static final Predicate<SelectorState> ALL_SELECTORS = Predicates.alwaysTrue();
    private final ConflictHandler conflictHandler;
    private final Spec<? super DependencyMetadata> edgeFilter;
    private final ResolveContextToComponentResolver moduleResolver;
    private final DependencyToComponentIdResolver idResolver;
    private final ComponentMetaDataResolver metaDataResolver;
    private final AttributesSchemaInternal attributesSchema;
    private final ModuleExclusions moduleExclusions;
    private final BuildOperationExecutor buildOperationExecutor;
    private final ModuleReplacementsData moduleReplacementsData;
    private final ComponentSelectorConverter componentSelectorConverter;
    private final DependencySubstitutionApplicator dependencySubstitutionApplicator;
    private final ExperimentalFeatures experimentalFeatures;
    private final ImmutableAttributesFactory attributesFactory;

    public DependencyGraphBuilder(DependencyToComponentIdResolver componentIdResolver, ComponentMetaDataResolver componentMetaDataResolver, ResolveContextToComponentResolver resolveContextToComponentResolver, ConflictHandler conflictHandler, Spec<? super DependencyMetadata> edgeFilter, AttributesSchemaInternal attributesSchema, ModuleExclusions moduleExclusions, BuildOperationExecutor buildOperationExecutor, ModuleReplacementsData moduleReplacementsData, DependencySubstitutionApplicator dependencySubstitutionApplicator, ComponentSelectorConverter componentSelectorConverter, ExperimentalFeatures experimentalFeatures, ImmutableAttributesFactory attributesFactory) {
        this.idResolver = componentIdResolver;
        this.metaDataResolver = componentMetaDataResolver;
        this.moduleResolver = resolveContextToComponentResolver;
        this.conflictHandler = conflictHandler;
        this.edgeFilter = edgeFilter;
        this.attributesSchema = attributesSchema;
        this.moduleExclusions = moduleExclusions;
        this.buildOperationExecutor = buildOperationExecutor;
        this.moduleReplacementsData = moduleReplacementsData;
        this.dependencySubstitutionApplicator = dependencySubstitutionApplicator;
        this.componentSelectorConverter = componentSelectorConverter;
        this.experimentalFeatures = experimentalFeatures;
        this.attributesFactory = attributesFactory;
    }

    public void resolve(ResolveContext resolveContext, DependencyGraphVisitor modelVisitor) {
        LongIdGenerator idGenerator = new LongIdGenerator();
        DefaultBuildableComponentResolveResult rootModule = new DefaultBuildableComponentResolveResult();
        this.moduleResolver.resolve(resolveContext, rootModule);
        ResolveState resolveState = new ResolveState((IdGenerator<Long>)idGenerator, rootModule, resolveContext.getName(), this.idResolver, this.metaDataResolver, this.edgeFilter, this.attributesSchema, this.moduleExclusions, this.moduleReplacementsData, this.componentSelectorConverter, this.attributesFactory);
        this.conflictHandler.registerResolver(new DirectDependencyForcingResolver(resolveState.getRoot().getComponent()));
        this.traverseGraph(resolveState);
        resolveState.getRoot().getComponent().setSelectionReason(VersionSelectionReasons.ROOT);
        this.assembleResult(resolveState, modelVisitor);
    }

    private void traverseGraph(ResolveState resolveState) {
        resolveState.onMoreSelected(resolveState.getRoot());
        ArrayList dependencies = Lists.newArrayList();
        ArrayList dependenciesMissingLocalMetadata = Lists.newArrayList();
        HashMap componentIdentifierCache = Maps.newHashMap();
        PendingDependenciesHandler pendingDependenciesHandler = this.experimentalFeatures.isEnabled() ? new DefaultPendingDependenciesHandler(this.componentSelectorConverter, this.dependencySubstitutionApplicator) : PendingDependenciesHandler.IGNORE;
        while (resolveState.peek() != null || this.conflictHandler.hasConflicts()) {
            if (resolveState.peek() != null) {
                NodeState node = resolveState.pop();
                LOGGER.debug("Visiting configuration {}.", (Object)node);
                dependencies.clear();
                dependenciesMissingLocalMetadata.clear();
                node.visitOutgoingDependencies(dependencies, pendingDependenciesHandler);
                this.resolveEdges(node, dependencies, dependenciesMissingLocalMetadata, resolveState, componentIdentifierCache);
                continue;
            }
            this.conflictHandler.resolveNextConflict(resolveState.getReplaceSelectionWithConflictResultAction());
        }
    }

    private void performSelection(ResolveState resolveState, ComponentState moduleRevision) {
        ModuleIdentifier moduleId = moduleRevision.getId().getModule();
        String version = moduleRevision.getId().getVersion();
        ModuleResolveState module = resolveState.getModule(moduleId);
        if (moduleRevision.isSelectable()) {
            if (DependencyGraphBuilder.tryCompatibleSelection(resolveState, moduleRevision, moduleId, version, module)) {
                return;
            }
            PotentialConflict c = this.conflictHandler.registerModule(module);
            if (!c.conflictExists()) {
                LOGGER.debug("Selecting new module version {}", (Object)moduleRevision);
                module.select(moduleRevision);
            } else {
                LOGGER.debug("Found new conflicting module version {}", (Object)moduleRevision);
                c.withParticipatingModules(resolveState.getDeselectVersionAction());
            }
        }
    }

    private static boolean tryCompatibleSelection(ResolveState resolveState, ComponentState moduleRevision, ModuleIdentifier moduleId, String version, ModuleResolveState module) {
        ComponentState selected = module.getSelected();
        List<SelectorState> moduleSelectors = module.getSelectors();
        if (selected == null && !resolveState.getModuleReplacementsData().participatesInReplacements(moduleId) && DependencyGraphBuilder.allSelectorsAgreeWith(moduleSelectors, version, ALL_SELECTORS)) {
            module.select(moduleRevision);
            return true;
        }
        final List<SelectorState> selectedBy = moduleRevision.allResolvers;
        if (selected != null && selected != moduleRevision) {
            if (DependencyGraphBuilder.allSelectorsAgreeWith(moduleRevision.allResolvers, selected.getVersion(), ALL_SELECTORS)) {
                return true;
            }
            if (DependencyGraphBuilder.allSelectorsAgreeWith(moduleSelectors, version, new Predicate<SelectorState>(){

                public boolean apply(@Nullable SelectorState input) {
                    return !selectedBy.contains(input);
                }
            })) {
                resolveState.getDeselectVersionAction().execute(moduleId);
                module.softSelect(moduleRevision);
                return true;
            }
        }
        return false;
    }

    private void resolveEdges(NodeState node, List<EdgeState> dependencies, List<EdgeState> dependenciesMissingMetadataLocally, ResolveState resolveState, Map<ModuleVersionIdentifier, ComponentIdentifier> componentIdentifierCache) {
        if (dependencies.isEmpty()) {
            return;
        }
        this.performSelectionSerially(dependencies, resolveState);
        this.computePreemptiveDownloadList(dependencies, dependenciesMissingMetadataLocally, componentIdentifierCache);
        this.downloadMetadataConcurrently(node, dependenciesMissingMetadataLocally);
        this.attachToTargetRevisionsSerially(dependencies);
    }

    private void attachToTargetRevisionsSerially(List<EdgeState> dependencies) {
        for (EdgeState dependency : dependencies) {
            if (dependency.getTargetComponent() == null) continue;
            dependency.attachToTargetConfigurations();
        }
    }

    private void downloadMetadataConcurrently(NodeState node, final List<EdgeState> dependencies) {
        if (dependencies.isEmpty()) {
            return;
        }
        LOGGER.debug("Submitting {} metadata files to resolve in parallel for {}", (Object)dependencies.size(), (Object)node);
        this.buildOperationExecutor.runAll((Action)new Action<BuildOperationQueue<RunnableBuildOperation>>(){

            public void execute(BuildOperationQueue<RunnableBuildOperation> buildOperationQueue) {
                for (EdgeState dependency : dependencies) {
                    buildOperationQueue.add((BuildOperation)new DownloadMetadataOperation(dependency.getTargetComponent()));
                }
            }
        });
    }

    private void performSelectionSerially(List<EdgeState> dependencies, ResolveState resolveState) {
        for (EdgeState dependency : dependencies) {
            ComponentState moduleRevision = dependency.resolveModuleRevisionId();
            if (moduleRevision == null) continue;
            this.performSelection(resolveState, moduleRevision);
        }
    }

    private void computePreemptiveDownloadList(List<EdgeState> dependencies, List<EdgeState> dependenciesToBeResolvedInParallel, Map<ModuleVersionIdentifier, ComponentIdentifier> componentIdentifierCache) {
        for (EdgeState dependency : dependencies) {
            ComponentState targetComponent = dependency.getTargetComponent();
            if (targetComponent == null || targetComponent.fastResolve() || !DependencyGraphBuilder.performPreemptiveDownload(targetComponent) || this.metaDataResolver.isFetchingMetadataCheap(DependencyGraphBuilder.toComponentId(targetComponent.getId(), componentIdentifierCache))) continue;
            dependenciesToBeResolvedInParallel.add(dependency);
        }
        if (dependenciesToBeResolvedInParallel.size() == 1) {
            dependenciesToBeResolvedInParallel.clear();
        }
    }

    private static ComponentIdentifier toComponentId(ModuleVersionIdentifier id, Map<ModuleVersionIdentifier, ComponentIdentifier> componentIdentifierCache) {
        ComponentIdentifier identifier = componentIdentifierCache.get(id);
        if (identifier == null) {
            identifier = DefaultModuleComponentIdentifier.newId(id);
            componentIdentifierCache.put(id, identifier);
        }
        return identifier;
    }

    private static boolean performPreemptiveDownload(ComponentState state) {
        return state.isSelected();
    }

    private void assembleResult(ResolveState resolveState, DependencyGraphVisitor visitor) {
        visitor.start(resolveState.getRoot());
        for (DependencyGraphSelector dependencyGraphSelector : resolveState.getSelectors()) {
            visitor.visitSelector(dependencyGraphSelector);
        }
        for (NodeState nodeState : resolveState.getNodes()) {
            if (!nodeState.isSelected()) continue;
            visitor.visitNode(nodeState);
        }
        ArrayList<ComponentState> queue = new ArrayList<ComponentState>();
        for (ModuleResolveState module : resolveState.getModules()) {
            if (module.getSelected() == null) continue;
            queue.add(module.getSelected());
        }
        while (!queue.isEmpty()) {
            ComponentState componentState = (ComponentState)queue.get(0);
            if (componentState.getVisitState() == VisitState.NotSeen) {
                componentState.setVisitState(VisitState.Visiting);
                int pos = 0;
                for (NodeState node : componentState.getNodes()) {
                    if (!node.isSelected()) continue;
                    for (EdgeState edge : node.getIncomingEdges()) {
                        ComponentState owner = edge.getFrom().getOwner();
                        if (owner.getVisitState() != VisitState.NotSeen) continue;
                        queue.add(pos, owner);
                        ++pos;
                    }
                }
                if (pos != 0) continue;
                componentState.setVisitState(VisitState.Visited);
                queue.remove(0);
                for (NodeState node : componentState.getNodes()) {
                    if (!node.isSelected()) continue;
                    visitor.visitEdges(node);
                }
                continue;
            }
            if (componentState.getVisitState() == VisitState.Visiting) {
                componentState.setVisitState(VisitState.Visited);
                queue.remove(0);
                for (NodeState node : componentState.getNodes()) {
                    if (!node.isSelected()) continue;
                    visitor.visitEdges(node);
                }
                continue;
            }
            queue.remove(0);
        }
        visitor.finish(resolveState.getRoot());
    }

    private static boolean allSelectorsAgreeWith(Collection<SelectorState> allSelectors, String version, Predicate<SelectorState> filter) {
        boolean atLeastOneAgrees = false;
        for (SelectorState selectorState : allSelectors) {
            ResolvedVersionConstraint versionConstraint;
            if (!filter.apply((Object)selectorState) || (versionConstraint = selectorState.getVersionConstraint()) == null) continue;
            VersionSelector candidateSelector = versionConstraint.getPreferredSelector();
            if (candidateSelector == null || !candidateSelector.canShortCircuitWhenVersionAlreadyPreselected() || !candidateSelector.accept(version)) {
                return false;
            }
            candidateSelector = versionConstraint.getRejectedSelector();
            if (candidateSelector != null && candidateSelector.accept(version)) {
                return false;
            }
            atLeastOneAgrees = true;
        }
        return atLeastOneAgrees;
    }

    static enum VisitState {
        NotSeen,
        Visiting,
        Visited;

    }
}

