/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import com.google.common.collect.Lists;
import java.util.List;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.ComponentSelectorConverter;
import org.gradle.api.internal.artifacts.DependencySubstitutionInternal;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DependencySubstitutionApplicator;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.DependencyState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.NodeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.PendingDependencies;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.PendingDependenciesHandler;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.PendingDependenciesState;

public class DefaultPendingDependenciesHandler
implements PendingDependenciesHandler {
    private final PendingDependenciesState pendingDependencies = new PendingDependenciesState();
    private final DependencySubstitutionApplicator dependencySubstitutionApplicator;
    private final ComponentSelectorConverter componentSelectorConverter;

    public DefaultPendingDependenciesHandler(ComponentSelectorConverter componentSelectorConverter, DependencySubstitutionApplicator dependencySubstitutionApplicator) {
        this.componentSelectorConverter = componentSelectorConverter;
        this.dependencySubstitutionApplicator = dependencySubstitutionApplicator;
    }

    @Override
    public PendingDependenciesHandler.Visitor start(boolean isOptionalConfiguration) {
        return new DefaultVisitor(isOptionalConfiguration);
    }

    public class DefaultVisitor
    implements PendingDependenciesHandler.Visitor {
        private final boolean isOptionalConfiguration;
        private List<PendingDependencies> noLongerPending;

        public DefaultVisitor(boolean isOptionalConfiguration) {
            this.isOptionalConfiguration = isOptionalConfiguration;
        }

        @Override
        public boolean maybeAddAsPendingDependency(NodeState node, DependencyState dependencyState) {
            ModuleIdentifier key = this.lookupModuleIdentifier(dependencyState);
            PendingDependencies pendingDependencies = DefaultPendingDependenciesHandler.this.pendingDependencies.getPendingDependencies(key);
            boolean pending = pendingDependencies.isPending();
            if (dependencyState.getDependencyMetadata().isPending() && !this.isOptionalConfiguration && pending) {
                pendingDependencies.addNode(node);
                return true;
            }
            if (pending) {
                if (this.noLongerPending == null) {
                    this.noLongerPending = Lists.newLinkedList();
                }
                this.noLongerPending.add(pendingDependencies);
            }
            DefaultPendingDependenciesHandler.this.pendingDependencies.notPending(key);
            return false;
        }

        private ModuleIdentifier lookupModuleIdentifier(DependencyState dependencyState) {
            DependencySubstitutionApplicator.SubstitutionResult substitutionResult = DefaultPendingDependenciesHandler.this.dependencySubstitutionApplicator.apply(dependencyState.getDependencyMetadata());
            DependencySubstitutionInternal details = substitutionResult.getResult();
            if (details != null && details.isUpdated()) {
                return DefaultPendingDependenciesHandler.this.componentSelectorConverter.getModule(details.getTarget());
            }
            return dependencyState.getModuleIdentifier();
        }

        @Override
        public void complete() {
            if (this.noLongerPending != null) {
                for (PendingDependencies pendingDependencies : this.noLongerPending) {
                    pendingDependencies.turnIntoHardDependencies();
                }
                this.noLongerPending = null;
            }
        }
    }
}

