/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.gradle.api.artifacts.ComponentMetadata;
import org.gradle.api.artifacts.ComponentSelection;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ComponentSelectionRulesInternal;
import org.gradle.api.internal.artifacts.DefaultComponentSelection;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ComponentSelectionRulesProcessor;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.MetadataProvider;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentResolveState;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.VersionInfo;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.VersionedComponentChooser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionComparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelector;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.resolve.result.BuildableModuleComponentMetaDataResolveResult;
import org.gradle.internal.resolve.result.ComponentSelectionContext;
import org.gradle.internal.rules.SpecRuleAction;
import org.gradle.util.CollectionUtils;

class DefaultVersionedComponentChooser
implements VersionedComponentChooser {
    private final ComponentSelectionRulesProcessor rulesProcessor = new ComponentSelectionRulesProcessor();
    private final VersionComparator versionComparator;
    private final ComponentSelectionRulesInternal componentSelectionRules;

    DefaultVersionedComponentChooser(VersionComparator versionComparator, ComponentSelectionRulesInternal componentSelectionRules) {
        this.versionComparator = versionComparator;
        this.componentSelectionRules = componentSelectionRules;
    }

    @Override
    public ComponentResolveMetadata selectNewestComponent(ComponentResolveMetadata one, ComponentResolveMetadata two) {
        if (one == null || two == null) {
            return two == null ? one : two;
        }
        int comparison = this.versionComparator.compare(new VersionInfo(one.getId().getVersion()), new VersionInfo(two.getId().getVersion()));
        if (comparison == 0) {
            if (this.isMissingModuleDescriptor(one) && !this.isMissingModuleDescriptor(two)) {
                return two;
            }
            return one;
        }
        return comparison < 0 ? two : one;
    }

    private boolean isMissingModuleDescriptor(ComponentResolveMetadata componentResolveMetadata) {
        return componentResolveMetadata.isMissing();
    }

    @Override
    public void selectNewestMatchingComponent(Collection<? extends ModuleComponentResolveState> versions, ComponentSelectionContext result, VersionSelector requestedVersionMatcher, VersionSelector rejectedVersionSelector) {
        Collection<SpecRuleAction<? super ComponentSelection>> rules = this.componentSelectionRules.getRules();
        for (ModuleComponentResolveState candidate : this.sortLatestFirst(versions)) {
            MetadataProvider metadataProvider = DefaultVersionedComponentChooser.createMetadataProvider(candidate);
            boolean versionMatches = DefaultVersionedComponentChooser.versionMatches(requestedVersionMatcher, candidate, metadataProvider);
            if (this.metadataIsNotUsable(result, metadataProvider)) {
                return;
            }
            String version = candidate.getVersion().getSource();
            if (!versionMatches) {
                result.notMatched(version);
                continue;
            }
            if (rejectedVersionSelector != null && rejectedVersionSelector.accept(version)) {
                result.rejected(version);
                continue;
            }
            ModuleComponentIdentifier candidateIdentifier = candidate.getId();
            if (!this.isRejectedByRules(candidateIdentifier, rules, metadataProvider)) {
                result.matches(candidateIdentifier);
                return;
            }
            result.rejected(version);
            if (!requestedVersionMatcher.matchesUniqueVersion()) continue;
            break;
        }
        result.noMatchFound();
    }

    private boolean metadataIsNotUsable(ComponentSelectionContext result, MetadataProvider metadataProvider) {
        if (!metadataProvider.isUsable()) {
            DefaultVersionedComponentChooser.applyTo(metadataProvider, result);
            return true;
        }
        return false;
    }

    private static MetadataProvider createMetadataProvider(ModuleComponentResolveState candidate) {
        return new MetadataProvider(candidate);
    }

    private static void applyTo(MetadataProvider provider, ComponentSelectionContext result) {
        BuildableModuleComponentMetaDataResolveResult metaDataResult = provider.getResult();
        switch (metaDataResult.getState()) {
            case Unknown: {
                result.noMatchFound();
                break;
            }
            case Missing: {
                result.noMatchFound();
                break;
            }
            case Failed: {
                result.failed(metaDataResult.getFailure());
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected meta-data resolution result.");
            }
        }
    }

    private static boolean versionMatches(VersionSelector selector, ModuleComponentResolveState component, MetadataProvider metadataProvider) {
        if (selector.requiresMetadata()) {
            ComponentMetadata componentMetadata = metadataProvider.getComponentMetadata();
            return componentMetadata != null && selector.accept(componentMetadata);
        }
        return selector.accept(component.getVersion());
    }

    @Override
    public boolean isRejectedComponent(ModuleComponentIdentifier candidateIdentifier, MetadataProvider metadataProvider) {
        return this.isRejectedByRules(candidateIdentifier, this.componentSelectionRules.getRules(), metadataProvider);
    }

    private boolean isRejectedByRules(ModuleComponentIdentifier candidateIdentifier, Collection<SpecRuleAction<? super ComponentSelection>> rules, MetadataProvider metadataProvider) {
        DefaultComponentSelection selection = new DefaultComponentSelection(candidateIdentifier);
        this.rulesProcessor.apply(selection, rules, metadataProvider);
        return selection.isRejected();
    }

    private List<ModuleComponentResolveState> sortLatestFirst(Collection<? extends ModuleComponentResolveState> listing) {
        return CollectionUtils.sort(listing, Collections.reverseOrder(this.versionComparator));
    }
}

