/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.vcs.internal;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Transformer;
import org.gradle.api.invocation.Gradle;
import org.gradle.internal.Actions;
import org.gradle.util.CollectionUtils;
import org.gradle.vcs.VcsMapping;
import org.gradle.vcs.VersionControlSpec;
import org.gradle.vcs.internal.VcsMappingInternal;
import org.gradle.vcs.internal.VcsMappingsStore;

public class DefaultVcsMappingsStore
implements VcsMappingsStore {
    private final Set<Action<VcsMapping>> rootVcsMappings = Sets.newLinkedHashSet();
    private final Map<Gradle, Set<Action<VcsMapping>>> vcsMappings = Maps.newHashMap();

    public Action<VcsMapping> getVcsMappingRule() {
        return new Action<VcsMapping>(){

            public void execute(VcsMapping vcsMapping) {
                VcsMappingInternal vcsMappingInternal = (VcsMappingInternal)vcsMapping;
                Actions.composite((Iterable)DefaultVcsMappingsStore.this.rootVcsMappings).execute((Object)vcsMappingInternal);
                if (!vcsMappingInternal.hasRepository()) {
                    HashSet resolutions = Sets.newHashSet();
                    for (Gradle gradle : DefaultVcsMappingsStore.this.vcsMappings.keySet()) {
                        Actions.composite((Iterable)((Iterable)DefaultVcsMappingsStore.this.vcsMappings.get(gradle))).execute((Object)vcsMappingInternal);
                        if (!vcsMappingInternal.hasRepository()) continue;
                        resolutions.add(vcsMappingInternal.getRepository());
                    }
                    if (resolutions.size() > 1) {
                        Set resolutionDisplayNames = CollectionUtils.collect((Set)resolutions, (Transformer)new Transformer<String, VersionControlSpec>(){

                            public String transform(VersionControlSpec versionControlSpec) {
                                return versionControlSpec.getDisplayName();
                            }
                        });
                        throw new GradleException("Conflicting external source dependency rules were found in nested builds for " + vcsMappingInternal.getRequested().getDisplayName() + ":\n  " + CollectionUtils.join((String)"\n  ", (Iterable)resolutionDisplayNames));
                    }
                }
            }
        };
    }

    public boolean hasRules() {
        return !this.vcsMappings.isEmpty() || !this.rootVcsMappings.isEmpty();
    }

    public void addRule(Action<VcsMapping> rule, Gradle gradle) {
        if (gradle.getParent() == null) {
            this.rootVcsMappings.add(rule);
        } else {
            if (!this.vcsMappings.containsKey(gradle)) {
                this.vcsMappings.put(gradle, Sets.newLinkedHashSet());
            }
            this.vcsMappings.get(gradle).add(rule);
        }
    }
}

